/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.preview;

import java.util.LinkedHashMap;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.Elevator;
import pt.lsts.neptus.mp.maneuvers.FollowTrajectory;
import pt.lsts.neptus.mp.maneuvers.Goto;
import pt.lsts.neptus.mp.maneuvers.Loiter;
import pt.lsts.neptus.mp.maneuvers.PopUp;
import pt.lsts.neptus.mp.maneuvers.RowsManeuver;
import pt.lsts.neptus.mp.maneuvers.StationKeeping;
import pt.lsts.neptus.mp.maneuvers.YoYo;
import pt.lsts.neptus.mp.preview.ElevatorPreview;
import pt.lsts.neptus.mp.preview.FollowTrajectoryPreview;
import pt.lsts.neptus.mp.preview.GotoPreview;
import pt.lsts.neptus.mp.preview.IManeuverPreview;
import pt.lsts.neptus.mp.preview.LoiterPreview;
import pt.lsts.neptus.mp.preview.PopupPreview;
import pt.lsts.neptus.mp.preview.RowsManeuverPreview;
import pt.lsts.neptus.mp.preview.StationKeepingPreview;
import pt.lsts.neptus.mp.preview.YoYoPreview;

public class ManPreviewFactory {
    protected static LinkedHashMap<Class<Maneuver>, Class<IManeuverPreview<Maneuver>>> registeredPreviews = new LinkedHashMap();

    public static IManeuverPreview<?> getPreview(Maneuver maneuver, String vehicleId, SystemPositionAndAttitude state, Object manState) {
        if (maneuver.getClass() == Goto.class) {
            GotoPreview prev = new GotoPreview();
            prev.init(vehicleId, (Goto)maneuver, state, manState);
            return prev;
        }
        if (maneuver.getClass() == PopUp.class) {
            PopupPreview prev = new PopupPreview();
            prev.init(vehicleId, (PopUp)maneuver, state, manState);
            return prev;
        }
        if (maneuver.getClass() == StationKeeping.class) {
            StationKeepingPreview prev = new StationKeepingPreview();
            prev.init(vehicleId, (StationKeeping)maneuver, state, manState);
            return prev;
        }
        if (maneuver.getClass() == Loiter.class) {
            LoiterPreview prev = new LoiterPreview();
            prev.init(vehicleId, (Loiter)maneuver, state, manState);
            return prev;
        }
        if (maneuver.getClass() == RowsManeuver.class) {
            RowsManeuverPreview prev = new RowsManeuverPreview();
            prev.init(vehicleId, (RowsManeuver)maneuver, state, manState);
            return prev;
        }
        if (maneuver.getClass() == Elevator.class) {
            ElevatorPreview prev = new ElevatorPreview();
            prev.init(vehicleId, (Elevator)maneuver, state, manState);
            return prev;
        }
        if (FollowTrajectory.class.isAssignableFrom(maneuver.getClass())) {
            FollowTrajectoryPreview prev = new FollowTrajectoryPreview();
            prev.init(vehicleId, (FollowTrajectory)maneuver, state, manState);
            return prev;
        }
        if (YoYo.class.isAssignableFrom(maneuver.getClass())) {
            YoYoPreview prev = new YoYoPreview();
            prev.init(vehicleId, (YoYo)maneuver, state, manState);
            return prev;
        }
        return null;
    }
}

