/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.preview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.ChartLauncher;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.colormaps.ColorMapRainbow;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.global.Settings;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.builder.Builder;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.LineStrip;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Shape;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.legends.Legend;
import org.jzy3d.plot3d.rendering.legends.colorbars.ColorbarLegend;
import pt.lsts.neptus.colormap.DataDiscretizer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.preview.PlanSimulationOverlay;
import pt.lsts.neptus.mp.preview.SimulationEngine;
import pt.lsts.neptus.mra.plots.Marker3d;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class PlanSimulation3D
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected Chart chart = null;
    protected LineStrip path = null;
    protected PlanSimulationOverlay overlay;
    protected PlanType plan;

    protected void init() {
        double[] offsets;
        while (!this.overlay.simulationFinished) {
            Thread.yield();
        }
        Settings.getInstance().setHardwareAccelerated(true);
        this.chart = new Chart(Quality.Advanced, "swing");
        this.path = new LineStrip();
        Coord3d firstCoord = null;
        Coord3d lastCoord = new Coord3d();
        for (int i = 0; i < this.overlay.getStates().size(); ++i) {
            SystemPositionAndAttitude state = this.overlay.getStates().get(i);
            Color c = this.overlay.colors.get(i).darker();
            LocationType loc = state.getPosition();
            double[] offsets2 = loc.getOffsetFrom(this.overlay.ref);
            double depth = -loc.getDepth();
            lastCoord = new Coord3d(-offsets2[0], offsets2[1], depth);
            this.path.add(new Point(lastCoord, new org.jzy3d.colors.Color(c.getRed(), c.getGreen(), c.getBlue()), 1.0f));
            if (firstCoord != null) continue;
            firstCoord = new Coord3d(-offsets2[0], offsets2[1], depth);
        }
        Vector relevantLocations = new Vector();
        if (this.plan != null) {
            for (Maneuver m : this.plan.getGraph().getAllManeuvers()) {
                LineStrip strip;
                ArrayList<Coord3d> coords;
                if (!(m instanceof LocatedManeuver)) continue;
                ManeuverLocation loc = ((LocatedManeuver)((Object)m)).getStartLocation();
                offsets = loc.getOffsetFrom(this.overlay.ref);
                if (loc.getZUnits() == ManeuverLocation.Z_UNITS.DEPTH) {
                    this.chart.getScene().add((AbstractDrawable)new Marker3d(m.getId(), new Coord3d(-offsets[0], offsets[1], -loc.getZ()), Color.blue));
                    coords = new ArrayList<Coord3d>();
                    coords.add(new Coord3d(-offsets[0], offsets[1], 0.0));
                    coords.add(new Coord3d(-offsets[0], offsets[1], -loc.getZ()));
                    strip = new LineStrip(coords);
                    strip.setWireframeColor(new org.jzy3d.colors.Color(0, 100, 100, 100));
                    this.chart.getScene().add((AbstractDrawable)strip);
                    continue;
                }
                if (loc.getZUnits() == ManeuverLocation.Z_UNITS.ALTITUDE) {
                    this.chart.getScene().add((AbstractDrawable)new Marker3d(m.getId(), new Coord3d(-offsets[0], offsets[1], -(SimulationEngine.simBathym.getSimulatedDepth(loc) - loc.getZ())), Color.blue));
                    coords = new ArrayList();
                    coords.add(new Coord3d(-offsets[0], offsets[1], -SimulationEngine.simBathym.getSimulatedDepth(loc)));
                    coords.add(new Coord3d(-offsets[0], offsets[1], -(SimulationEngine.simBathym.getSimulatedDepth(loc) - loc.getZ())));
                    strip = new LineStrip(coords);
                    strip.setWireframeColor(new org.jzy3d.colors.Color(0, 100, 100, 100));
                    this.chart.getScene().add((AbstractDrawable)strip);
                    continue;
                }
                this.chart.getScene().add((AbstractDrawable)new Marker3d(m.getId(), new Coord3d(-offsets[0], offsets[1], 0.0), Color.blue));
            }
        }
        LocationType loc = new LocationType(this.overlay.ref);
        LinkedHashMap<LocationType, Double> soundings = SimulationEngine.simBathym.getSoundings();
        if (!soundings.isEmpty()) {
            DataDiscretizer dd = new DataDiscretizer(3.0);
            for (Map.Entry<LocationType, Double> entry : soundings.entrySet()) {
                offsets = entry.getKey().getOffsetFrom(this.overlay.ref);
                dd.addPoint(-offsets[0], offsets[1], -entry.getValue().doubleValue());
            }
            for (LocationType l : relevantLocations) {
                offsets = l.getOffsetFrom(this.overlay.ref);
                dd.addPoint(-offsets[0], offsets[1], -SimulationEngine.simBathym.getSimulatedDepth(loc));
            }
            DataDiscretizer.DataPoint[] data = dd.getDataPoints();
            if (data.length == 0) {
                return;
            }
            ArrayList<Coord3d> coords = new ArrayList<Coord3d>();
            for (DataDiscretizer.DataPoint p : data) {
                coords.add(new Coord3d(p.getPoint2D().getX(), p.getPoint2D().getY(), p.getValue()));
            }
            Shape surface = Builder.buildDelaunay(coords);
            surface.setColorMapper(new ColorMapper((IColorMap)new ColorMapRainbow(), surface.getBounds().getZmin(), surface.getBounds().getZmax(), new org.jzy3d.colors.Color(1.0f, 0.5f, 0.5f, 0.5f)));
            surface.setWireframeDisplayed(false);
            surface.setLegend((Legend)new ColorbarLegend((AbstractDrawable)surface, this.chart.getView().getAxe().getLayout().getZTickProvider(), this.chart.getView().getAxe().getLayout().getZTickRenderer()));
            surface.setLegendDisplayed(true);
            this.chart.getScene().add((AbstractDrawable)surface);
        }
        this.path.add(new Point(lastCoord, new org.jzy3d.colors.Color(0, 0, 0, 0), 0.0f));
        this.path.add(new Point(firstCoord, new org.jzy3d.colors.Color(0, 0, 0, 0), 0.0f));
        this.path.setWidth(2.0f);
        this.chart.getScene().add((AbstractDrawable)this.path);
        this.chart.getView().setMaximized(true);
        ChartLauncher.configureControllers((Chart)this.chart, (String)"chart", (boolean)true, (boolean)false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlanSimulation3D.this.add((Component)PlanSimulation3D.this.chart.getCanvas());
                PlanSimulation3D.this.revalidate();
                PlanSimulation3D.this.repaint();
            }
        });
    }

    public void cleanup() {
        if (this.chart != null) {
            this.chart.stopAnimator();
            this.chart.clear();
            this.chart.dispose();
        }
    }

    public PlanSimulation3D(PlanSimulationOverlay overlay, PlanType plan) {
        this.setLayout(new BorderLayout());
        this.overlay = overlay;
        this.plan = plan;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                PlanSimulation3D.this.init();
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public static void showSimulation(Window owner, PlanSimulationOverlay overlay, PlanType plan) {
        final PlanSimulation3D sim3d = new PlanSimulation3D(overlay, plan);
        JDialog dialog = new JDialog(owner, I18n.text("Plan execution preview"));
        dialog.setSize(600, 400);
        dialog.getContentPane().add(sim3d);
        dialog.setResizable(false);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                sim3d.cleanup();
            }
        });
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
    }
}

