/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.preview;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Vector;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.preview.PlanSimulationListener;
import pt.lsts.neptus.mp.preview.SimulationEngine;
import pt.lsts.neptus.mp.preview.SimulationState;
import pt.lsts.neptus.mp.preview.payloads.PayloadFactory;
import pt.lsts.neptus.mp.preview.payloads.PayloadFingerprint;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.PlanUtil;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class PlanSimulationOverlay
implements Renderer2DPainter {
    protected LocationType ref;
    protected Vector<SystemPositionAndAttitude> states = new Vector();
    protected Vector<Color> colors = new Vector();
    protected Vector<SimulationState> simStates = new Vector();
    public boolean simulationFinished = false;
    public static double bottomDepth = 10.0;
    private HashSet<PlanSimulationListener> listeners = new HashSet();
    private double totalTime = 0.0;
    protected LinkedHashMap<String, Collection<PayloadFingerprint>> payloads;
    protected PlanType plan;

    public PlanSimulationOverlay(PlanType plan, final double usedBattHours, final double remainingBattHours, SystemPositionAndAttitude start) {
        this.ref = new LocationType(plan.getMissionType().getHomeRef());
        this.plan = plan;
        final SimulationEngine engine = new SimulationEngine(plan);
        this.payloads = PayloadFactory.getPayloads(plan);
        if (start == null) {
            start = new SystemPositionAndAttitude(plan.getMissionType().getHomeRef(), 0.0, 0.0, 0.0);
            Vector<LocatedManeuver> manLocs = PlanUtil.getLocationsAsSequence(plan);
            if (!manLocs.isEmpty()) {
                start.setPosition(manLocs.firstElement().getStartLocation());
            }
        }
        engine.setState(start);
        Thread t = new Thread("Plan simulation overlay"){

            @Override
            public void run() {
                double ellapsedTime = 0.0;
                double lastPoint = 0.0;
                ColorMap cmap = ColorMapFactory.createRedYellowGreenColorMap();
                double totalBattTime = (usedBattHours + remainingBattHours) * 3600.0;
                double usedBatt = usedBattHours * 3600.0;
                while (!engine.isFinished() && ellapsedTime < 36000.0) {
                    ellapsedTime += engine.getTimestep();
                    engine.simulationStep();
                    if (ellapsedTime - lastPoint > 1.0) {
                        Color c = cmap.getColor(1.0 - (ellapsedTime + usedBatt) / totalBattTime);
                        PlanSimulationOverlay.this.addPoint(engine.getState(), c, new SimulationState(engine.getManId(), engine.getCurPreview() == null ? null : engine.getCurPreview().getState(), engine.getState()));
                        lastPoint = ellapsedTime;
                    }
                    Thread.yield();
                }
                PlanSimulationOverlay.this.simulationFinished = true;
                PlanSimulationOverlay.this.totalTime = ellapsedTime;
                for (PlanSimulationListener l : PlanSimulationOverlay.this.listeners) {
                    l.simulationFinished(PlanSimulationOverlay.this);
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public void addListener(PlanSimulationListener l) {
        this.listeners.add(l);
    }

    public void removeListener(PlanSimulationListener l) {
        this.listeners.remove(l);
    }

    protected void addPoint(double northing, double easting, Color color) {
        LocationType loc = new LocationType(this.ref);
        loc.translatePosition(northing, easting, 0.0);
        this.addPoint(loc, color);
    }

    protected void addPoint(LocationType loc, Color color) {
        this.addPoint(loc, color, null);
    }

    protected void addPoint(LocationType loc) {
        if (this.colors.size() > 0) {
            this.addPoint(loc, this.colors.lastElement());
        } else {
            this.addPoint(loc, Color.white);
        }
    }

    public void addPoint(SystemPositionAndAttitude state, Color color, SimulationState simState) {
        this.states.add(state);
        this.colors.add(color);
        this.simStates.add(simState);
    }

    public void addPoint(LocationType loc, Color color, SimulationState simState) {
        this.addPoint(new SystemPositionAndAttitude(loc, 0.0, 0.0, 0.0), color, simState);
    }

    public final Vector<SimulationState> getSimStates() {
        return this.simStates;
    }

    public final Vector<SystemPositionAndAttitude> getStates() {
        return this.states;
    }

    public SimulationState nearestState(SystemPositionAndAttitude state, double minDistThreshold) {
        int nearest = 0;
        double nearestDistance = Double.MAX_VALUE;
        for (int i = 0; i < this.simStates.size(); ++i) {
            LocationType center = this.states.get(i).getPosition();
            double dist = center.getHorizontalDistanceInMeters(state.getPosition()) + 2.0 * Math.abs(state.getYaw() - this.states.get(i).getYaw());
            if (!(dist < nearestDistance)) continue;
            nearestDistance = dist;
            nearest = i;
        }
        if (nearestDistance < minDistThreshold) {
            return this.simStates.get(nearest);
        }
        return null;
    }

    public LinkedHashMap<String, String> statistics(SystemPositionAndAttitude state) {
        LinkedHashMap<String, String> stats = new LinkedHashMap<String, String>();
        if (!this.simStates.isEmpty()) {
            SimulationState nearest = this.simStates.get(0);
            if (state != null) {
                nearest = this.nearestState(state, 2.147483647E9);
            }
            int pos = this.simStates.indexOf(nearest);
            int time = this.states.size() - pos;
            String timeUnits = I18n.text("seconds");
            if (time > 300) {
                timeUnits = I18n.text("minutes");
                time /= 60;
            }
            stats.put(I18n.text("Completion status"), I18n.textf("%percent % complete", (double)(pos * 1000 / this.simStates.size()) / 10.0));
            stats.put(I18n.text("Time until completion"), time + " " + timeUnits);
        }
        return stats;
    }

    public double getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(double totalTime) {
        this.totalTime = totalTime;
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        int i;
        Point2D center = renderer.getScreenPosition(this.ref);
        g.setColor(Color.white);
        for (i = 0; i < this.states.size(); ++i) {
            String man = this.simStates.get(i).getCurrentManeuver();
            Graphics2D g2 = (Graphics2D)g.create();
            Point2D pt = renderer.getScreenPosition(this.states.get(i).getPosition());
            g2.translate(pt.getX(), pt.getY());
            g2.scale(renderer.getZoom(), renderer.getZoom());
            g2.rotate(-renderer.getRotation() + this.states.get(i).getYaw());
            for (PayloadFingerprint pf : this.payloads.get(man)) {
                SystemPositionAndAttitude state = this.states.get(i);
                state.setAltitude(SimulationEngine.simBathym.getSimulatedDepth(state.getPosition()));
                Area a = pf.getFingerprint(this.states.get(i));
                g2.setColor(pf.getColor());
                g2.fill(a);
            }
        }
        g.translate(center.getX(), center.getY());
        g.rotate(-renderer.getRotation());
        for (i = 0; i < this.states.size(); ++i) {
            g.setColor(this.colors.get(i));
            double zoom = renderer.getZoom();
            double[] neOffsets = this.states.get(i).getPosition().getOffsetFrom(this.ref);
            g.fillRect((int)(neOffsets[1] * zoom) - 1, (int)(-(neOffsets[0] * zoom)) - 1, 2, 2);
        }
    }
}

