/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.preview;

import pt.lsts.imc.EstimatedState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.preview.PlanSimulationOverlay;
import pt.lsts.neptus.mp.preview.SimulationEngine;
import pt.lsts.neptus.mp.preview.SimulationState;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class PlanSimulator {
    SimulationEngine engine = null;
    protected Thread simulationThread = null;
    protected boolean finished = false;
    protected PlanSimulationOverlay simulatedPath = null;
    protected double timestep = 0.25;
    protected PlanType plan;
    protected String vehicleId;

    public PlanSimulator(PlanType plan, SystemPositionAndAttitude start) {
        this.plan = plan;
        this.vehicleId = plan.getVehicle();
        this.engine = new SimulationEngine(plan);
        Maneuver[] mans = plan.getGraph().getManeuversSequence();
        if (start == null) {
            LocationType loc = new LocationType(plan.getMissionType().getStartLocation());
            start = new SystemPositionAndAttitude(loc, 0.0, 0.0, 0.0);
            for (int i = 0; i < mans.length; ++i) {
                if (!(mans[i] instanceof LocatedManeuver)) continue;
                ManeuverLocation l = ((LocatedManeuver)((Object)mans[i])).getManeuverLocation();
                start.setPosition(l);
            }
        }
        this.simulatedPath = new PlanSimulationOverlay(plan, 0.0, 4.0, start);
    }

    public SystemPositionAndAttitude getState() {
        return this.engine.getState();
    }

    public void setState(SystemPositionAndAttitude state) {
        this.engine.setState(state);
    }

    public PlanType getPlan() {
        return this.plan;
    }

    public String getManId() {
        return this.engine.manId;
    }

    public void setManId(String manId) throws Exception {
        this.engine.setManeuverId(manId);
    }

    public void startSimulation() {
        if (this.simulationThread != null) {
            this.simulationThread.interrupt();
        }
        this.simulationThread = new Thread("Plan Execution Simulator"){

            @Override
            public void run() {
                while (!PlanSimulator.this.finished) {
                    PlanSimulator.this.engine.simulationStep();
                    try {
                        Thread.sleep((long)(1000.0 * PlanSimulator.this.timestep));
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (Exception e) {
                        NeptusLog.pub().error((Object)e);
                    }
                }
                PlanSimulator.this.simulationThread = null;
            }
        };
        this.simulationThread.setDaemon(true);
        this.simulationThread.start();
    }

    public void setPositionEstimation(EstimatedState state, double distanceThreshold) {
        LocationType loc = new LocationType();
        loc.setLatitudeRads(state.getLat());
        loc.setLongitudeRads(state.getLon());
        loc.setDepth(state.getDepth());
        loc.translatePosition(state.getX(), state.getY(), state.getZ());
        SystemPositionAndAttitude s = new SystemPositionAndAttitude(this.getState());
        s.setPosition(loc);
        SimulationState newState = this.simulatedPath.nearestState(s, distanceThreshold);
        if (newState != null) {
            this.engine.setSimulationState(state, newState);
        }
    }

    public void setEstimatedState(EstimatedState state) {
        LocationType loc = new LocationType();
        loc.setLatitudeRads(state.getLat());
        loc.setLongitudeRads(state.getLon());
        loc.setDepth(state.getDepth());
        loc.translatePosition(state.getX(), state.getY(), state.getZ());
        SystemPositionAndAttitude s = new SystemPositionAndAttitude(this.getState());
        s.setPosition(loc);
        SimulationState newState = this.simulatedPath.nearestState(s, 2.147483647E9);
        if (newState != null) {
            this.engine.setSimulationState(state, newState);
        }
    }

    public void stopSimulation() {
        if (this.simulationThread != null) {
            this.simulationThread.interrupt();
        }
        this.simulationThread = null;
    }

    public double getTimestep() {
        return this.timestep;
    }

    public void setTimestep(double timestep) {
        this.timestep = timestep;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isRunning() {
        return this.simulationThread != null;
    }

    public final String getVehicleId() {
        return this.vehicleId;
    }

    public final void setVehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
    }

    public final PlanSimulationOverlay getSimulationOverlay() {
        return this.simulatedPath;
    }
}

