/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.preview;

import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.PopUp;
import pt.lsts.neptus.mp.preview.IManeuverPreview;
import pt.lsts.neptus.mp.preview.SpeedConversion;
import pt.lsts.neptus.mp.preview.UnicycleModel;
import pt.lsts.neptus.types.coord.LocationType;

public class PopupPreview
implements IManeuverPreview<PopUp> {
    protected LocationType destination;
    protected double speed;
    protected boolean finished = false;
    protected double totalTime = 0.0;
    protected double surfaceTime = 0.0;
    protected double maxTime;
    protected double duration;
    UnicycleModel model = new UnicycleModel();

    @Override
    public boolean init(String vehicleId, PopUp man, SystemPositionAndAttitude state, Object manState) {
        this.destination = new LocationType(man.getManeuverLocation());
        this.destination.setAbsoluteDepth(0.0);
        this.maxTime = man.getMaxTime();
        this.duration = man.getDuration();
        this.speed = man.getSpeed();
        this.model.setMaxSteeringRad(Math.toRadians(9.0));
        if (man.getUnits().equals("RPM")) {
            this.speed = SpeedConversion.convertRpmtoMps(this.speed);
        } else if (man.getUnits().equals("%")) {
            this.speed = SpeedConversion.convertPercentageToMps(this.speed);
        }
        this.speed = Math.min(this.speed, 2.0);
        this.model.setState(state);
        return true;
    }

    @Override
    public SystemPositionAndAttitude step(SystemPositionAndAttitude state, double timestep) {
        this.model.setState(state);
        boolean there = this.model.guide(this.destination, this.speed, null);
        if (this.totalTime >= this.maxTime || this.surfaceTime >= this.duration) {
            this.finished = true;
        } else {
            this.model.advance(timestep);
        }
        this.totalTime += timestep;
        if (there && this.model.getDepth() <= 0.1) {
            this.surfaceTime += timestep;
        }
        return this.model.getState();
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void reset(SystemPositionAndAttitude state) {
        this.model.setState(state);
    }

    @Override
    public Object getState() {
        return null;
    }
}

