/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.preview;

import java.util.Vector;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.RowsManeuver;
import pt.lsts.neptus.mp.preview.IManeuverPreview;
import pt.lsts.neptus.mp.preview.SpeedConversion;
import pt.lsts.neptus.mp.preview.UnicycleModel;
import pt.lsts.neptus.types.coord.LocationType;

public class RowsManeuverPreview
implements IManeuverPreview<RowsManeuver> {
    protected Vector<LocationType> locs = new Vector();
    protected int locIndex = 0;
    protected String vehicleId = null;
    protected double speed;
    protected UnicycleModel model = new UnicycleModel();
    protected boolean finished = false;

    @Override
    public boolean init(String vehicleId, RowsManeuver man, SystemPositionAndAttitude state, Object manState) {
        this.locs.addAll(man.getPathLocations());
        for (LocationType loc : this.locs) {
            if (man.getManeuverLocation().getZUnits() == ManeuverLocation.Z_UNITS.DEPTH) {
                loc.setDepth(man.getManeuverLocation().getZ());
                continue;
            }
            if (man.getManeuverLocation().getZUnits() != ManeuverLocation.Z_UNITS.ALTITUDE) continue;
            loc.setDepth(-man.getManeuverLocation().getZ());
        }
        this.vehicleId = vehicleId;
        this.locIndex = 0;
        this.speed = man.getSpeed();
        if (man.getUnits().equals("RPM")) {
            this.speed = SpeedConversion.convertRpmtoMps(this.speed);
        } else if (man.getUnits().equals("%")) {
            this.speed = SpeedConversion.convertPercentageToMps(this.speed);
        }
        this.speed = Math.min(this.speed, 2.0);
        this.model.setState(state);
        if (manState != null && manState instanceof Integer) {
            this.locIndex = (Integer)manState;
        }
        return true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void reset(SystemPositionAndAttitude state) {
    }

    @Override
    public SystemPositionAndAttitude step(SystemPositionAndAttitude state, double timestep) {
        if (this.locIndex >= this.locs.size()) {
            this.finished = true;
            return state;
        }
        this.model.setState(state);
        LocationType destination = this.locs.get(this.locIndex);
        if (this.model.guide(destination, this.speed, destination.getDepth() >= 0.0 ? null : Double.valueOf(-destination.getDepth()))) {
            ++this.locIndex;
        } else {
            this.model.advance(timestep);
        }
        return this.model.getState();
    }

    @Override
    public Object getState() {
        return new Integer(this.locIndex);
    }
}

