/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.preview;

import java.util.Date;
import pt.lsts.imc.EstimatedState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.plugins.planning.SimulatedBathymetry;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.preview.IManeuverPreview;
import pt.lsts.neptus.mp.preview.ManPreviewFactory;
import pt.lsts.neptus.mp.preview.SimulationState;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class SimulationEngine {
    protected PlanType plan;
    protected double timestep = 0.25;
    protected String vehicleId;
    protected String manId;
    protected SystemPositionAndAttitude state;
    protected boolean finished = false;
    protected IManeuverPreview<?> curPreview = null;
    public static SimulatedBathymetry simBathym = new SimulatedBathymetry();

    public SimulationEngine(PlanType plan) {
        this.plan = plan;
        this.vehicleId = plan.getVehicle();
        this.manId = plan.getGraph().getInitialManeuverId();
        for (Maneuver m : plan.getGraph().getManeuversSequence()) {
            if (!(m instanceof LocatedManeuver)) continue;
            ManeuverLocation loc = ((LocatedManeuver)((Object)m)).getStartLocation();
            this.state = new SystemPositionAndAttitude(loc, 0.0, 0.0, 0.0);
            break;
        }
        if (this.state == null) {
            this.state = new SystemPositionAndAttitude(plan.getMissionType().getStartLocation(), 0.0, 0.0, 0.0);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSimulationState(EstimatedState state, SimulationState simState) {
        Maneuver m = this.plan.getGraph().getManeuver(simState.getCurrentManeuver());
        SimulationEngine simulationEngine = this;
        synchronized (simulationEngine) {
            this.finished = false;
            this.manId = simState.getCurrentManeuver();
            this.setState(simState.getSysState());
            this.curPreview = ManPreviewFactory.getPreview(m, this.vehicleId, this.getState(), simState.getManeuverState());
            this.simulationStep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManeuverId(String manId) throws Exception {
        if (this.manId.equals(manId)) {
            return;
        }
        Maneuver m = this.plan.getGraph().getManeuver(manId);
        SimulationEngine simulationEngine = this;
        synchronized (simulationEngine) {
            this.finished = false;
            this.manId = manId;
            this.curPreview = ManPreviewFactory.getPreview(m, this.vehicleId, this.state, null);
            if (this.curPreview == null) {
                throw new Exception(manId + " cannot be previewed");
            }
            this.simulationStep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulationStep() {
        Maneuver next;
        Maneuver m = this.plan.getGraph().getManeuver(this.manId);
        if (m == null) {
            return;
        }
        if (this.curPreview == null) {
            SimulationEngine simulationEngine = this;
            synchronized (simulationEngine) {
                this.curPreview = ManPreviewFactory.getPreview(m, this.vehicleId, this.state, null);
            }
            if (this.curPreview == null) {
                next = this.plan.getGraph().getFollowingManeuver(m.getId());
                if (next == null) {
                    this.finished = true;
                } else {
                    this.manId = next.getId();
                    NeptusLog.pub().debug((Object)("Simulating " + this.manId));
                }
                return;
            }
            NeptusLog.pub().debug((Object)("now simulating using " + this.curPreview.getClass().getSimpleName()));
        }
        this.state = this.curPreview.step(this.state, this.timestep);
        if (this.curPreview.isFinished() || this.curPreview == null) {
            try {
                next = this.plan.getGraph().getFollowingManeuver(m.getId());
                if (next == null) {
                    this.finished = true;
                    NeptusLog.pub().debug((Object)("Plan finished at " + new Date()));
                } else {
                    this.manId = next.getId();
                    NeptusLog.pub().debug((Object)("Simulating " + this.manId));
                }
            }
            catch (Exception e) {
                this.finished = true;
            }
            this.curPreview = null;
        }
    }

    public double getTimestep() {
        return this.timestep;
    }

    public final SystemPositionAndAttitude getState() {
        return this.state;
    }

    public final void setState(SystemPositionAndAttitude state) {
        this.state = state;
    }

    public final String getManId() {
        return this.manId;
    }

    public final IManeuverPreview<?> getCurPreview() {
        return this.curPreview;
    }
}

