/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.preview;

import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.StationKeeping;
import pt.lsts.neptus.mp.preview.IManeuverPreview;
import pt.lsts.neptus.mp.preview.SpeedConversion;
import pt.lsts.neptus.mp.preview.UnicycleModel;
import pt.lsts.neptus.types.coord.LocationType;

public class StationKeepingPreview
implements IManeuverPreview<StationKeeping> {
    protected LocationType destination;
    protected double speed;
    protected boolean finished = false;
    protected double sk_time = -0.1;
    protected double maxTime;
    protected double duration;
    protected boolean arrived = false;
    UnicycleModel model = new UnicycleModel();

    @Override
    public boolean init(String vehicleId, StationKeeping man, SystemPositionAndAttitude state, Object manState) {
        this.destination = new LocationType(man.getManeuverLocation());
        if (man.getManeuverLocation().getZUnits() == ManeuverLocation.Z_UNITS.DEPTH) {
            this.destination.setDepth(man.getManeuverLocation().getZ());
        } else {
            this.destination.setDepth(Math.max(0.5, 10.0 - man.getManeuverLocation().getZ()));
        }
        this.speed = man.getSpeed();
        if (man.getSpeedUnits().equals("RPM")) {
            this.speed = SpeedConversion.convertRpmtoMps(this.speed);
        } else if (man.getSpeedUnits().equals("%")) {
            this.speed = SpeedConversion.convertPercentageToMps(this.speed);
        }
        this.speed = Math.min(this.speed, 2.0);
        this.duration = man.getDuration();
        this.model.setState(state);
        return true;
    }

    @Override
    public SystemPositionAndAttitude step(SystemPositionAndAttitude state, double timestep) {
        if (!this.arrived) {
            this.model.setState(state);
            this.arrived = this.model.guide(this.destination, this.speed, this.destination.getDepth() >= 0.0 ? null : Double.valueOf(-this.destination.getDepth()));
        } else {
            this.sk_time += timestep;
            this.finished = this.duration == 0.0 ? this.model.getDepth() <= 0.0 : this.sk_time >= this.duration;
        }
        this.model.advance(timestep);
        return this.model.getState();
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void reset(SystemPositionAndAttitude state) {
        this.model.setState(state);
    }

    @Override
    public Object getState() {
        return null;
    }
}

