/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.preview;

import java.util.Vector;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.preview.SimulationEngine;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;

public class UnicycleModel {
    protected double latRad;
    protected double lonRad;
    protected double x;
    protected double y;
    protected double rollRad;
    protected double pitchRad;
    protected double yawRad;
    protected double depth;
    protected double speedMPS;
    protected double targetLatRad;
    protected double targetLonRad;
    protected double maxSteeringRad = Math.toRadians(7.0);
    protected boolean arrived = true;

    public double getCurrentAltitude() {
        double a = SimulationEngine.simBathym.getSimulatedDepth(this.getCurrentPosition());
        return a - this.depth;
    }

    public LocationType getCurrentPosition() {
        LocationType loc = new LocationType();
        loc.setLatitudeDegs(Math.toDegrees(this.latRad));
        loc.setLongitudeDegs(Math.toDegrees(this.lonRad));
        loc.setDepth(this.depth);
        loc.setOffsetEast(this.x);
        loc.setOffsetNorth(this.y);
        return loc;
    }

    public SystemPositionAndAttitude getState() {
        LocationType loc = new LocationType();
        loc.setLatitudeDegs(Math.toDegrees(this.latRad));
        loc.setLongitudeDegs(Math.toDegrees(this.lonRad));
        loc.setDepth(this.depth);
        loc.setOffsetEast(this.x);
        loc.setOffsetNorth(this.y);
        return new SystemPositionAndAttitude(loc, this.rollRad, this.pitchRad, this.yawRad);
    }

    public void setState(SystemPositionAndAttitude state) {
        if (state == null) {
            NeptusLog.pub().error((Object)"setState(null)");
            return;
        }
        LocationType pos = state.getPosition();
        pos.convertToAbsoluteLatLonDepth();
        this.latRad = pos.getLatitudeRads();
        this.lonRad = pos.getLongitudeRads();
        this.y = 0.0;
        this.x = 0.0;
        this.depth = pos.getDepth();
        this.speedMPS = state.getVx();
        this.rollRad = state.getRoll();
        this.pitchRad = state.getPitch();
        this.yawRad = state.getYaw();
    }

    public void setLocation(LocationType loc) {
        LocationType old = this.getCurrentPosition();
        loc.convertToAbsoluteLatLonDepth();
        this.latRad = loc.getLatitudeRads();
        this.lonRad = loc.getLongitudeRads();
        this.depth = loc.getDepth();
        this.y = 0.0;
        this.x = 0.0;
        this.rollRad = 0.0;
        this.pitchRad = 0.0;
        this.yawRad = old.getXYAngle(loc);
    }

    public void advance(double timestepSecs) {
        double angle = this.yawRad;
        this.x += this.speedMPS * timestepSecs * Math.sin(angle);
        this.y += this.speedMPS * timestepSecs * Math.cos(angle);
        this.depth += this.speedMPS * timestepSecs * Math.sin(this.pitchRad);
        if (this.depth > 0.0) {
            this.depth -= 0.05 * timestepSecs;
        }
    }

    public boolean guide(LocationType loc, double speed, Double altitude) {
        double diffAng;
        if (loc.getHorizontalDistanceInMeters(this.getCurrentPosition()) < speed) {
            this.pitchRad = 0.0;
            this.rollRad = 0.0;
            this.speedMPS = 0.0;
            return true;
        }
        this.speedMPS = speed;
        if (altitude != null) {
            double curBathym = SimulationEngine.simBathym.getSimulatedDepth(this.getCurrentPosition());
            double curAltitude = curBathym - this.depth;
            if (curAltitude > altitude) {
                this.pitchRad = Math.toRadians(12.0);
            } else if (curAltitude < altitude) {
                this.pitchRad = -Math.toRadians(12.0);
            } else {
                this.depth = SimulationEngine.simBathym.getSimulatedDepth(this.getCurrentPosition()) - altitude;
            }
        } else if (loc.getDepth() > this.depth + 0.1) {
            this.pitchRad = Math.toRadians(12.0);
        } else if (loc.getDepth() < this.depth - 0.1) {
            this.pitchRad = -Math.toRadians(12.0);
        } else {
            this.depth = loc.getDepth();
            this.pitchRad = 0.0;
        }
        double ang = this.getCurrentPosition().getXYAngle(loc);
        for (diffAng = this.yawRad - ang; diffAng > Math.PI; diffAng -= Math.PI * 2) {
        }
        while (diffAng < -Math.PI) {
            diffAng += Math.PI * 2;
        }
        this.yawRad = Math.abs(diffAng) < this.maxSteeringRad ? ang : (diffAng > 0.0 ? (this.yawRad -= this.maxSteeringRad) : (this.yawRad += this.maxSteeringRad));
        return false;
    }

    public double getLatRad() {
        return this.latRad;
    }

    public void setLatRad(double latRad) {
        this.latRad = latRad;
    }

    public double getLonRad() {
        return this.lonRad;
    }

    public void setLonRad(double lonRad) {
        this.lonRad = lonRad;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getDepth() {
        return this.depth;
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public double getRollRad() {
        return this.rollRad;
    }

    public void setRollRad(double rollRad) {
        this.rollRad = rollRad;
    }

    public double getPitchRad() {
        return this.pitchRad;
    }

    public void setPitchRad(double pitchRad) {
        this.pitchRad = pitchRad;
    }

    public double getYawRad() {
        return this.yawRad;
    }

    public void setYawRad(double yawRad) {
        this.yawRad = yawRad;
    }

    public double getMaxSteeringRad() {
        return this.maxSteeringRad;
    }

    public void setMaxSteeringRad(double maxSteeringRad) {
        this.maxSteeringRad = maxSteeringRad;
    }

    public static void main(String[] args) {
        LocationType loc = new LocationType();
        Vector<LocationType> locs = new Vector<LocationType>();
        loc.setLatitudeDegs(41.0);
        loc.setLongitudeDegs(-8.0);
        StateRenderer2D r2d = new StateRenderer2D(new LocationType(loc));
        locs.add(new LocationType(loc));
        loc.translatePosition(10.0, -20.0, 2.0);
        locs.add(new LocationType(loc));
        loc.translatePosition(30.0, 30.0, 0.0);
        locs.add(new LocationType(loc));
        loc.translatePosition(-30.0, 0.0, -2.0);
        locs.add(new LocationType(loc));
        loc.convertToAbsoluteLatLonDepth();
        loc.setLatitudeDegs(41.0);
        loc.setLongitudeDegs(-8.0);
        locs.add(new LocationType(loc));
        UnicycleModel model = new UnicycleModel();
        model.setMaxSteeringRad(Math.toRadians(3.0));
        GuiUtils.testFrame(r2d);
    }
}

