/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.preview;

import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.YoYo;
import pt.lsts.neptus.mp.preview.IManeuverPreview;
import pt.lsts.neptus.mp.preview.SpeedConversion;
import pt.lsts.neptus.mp.preview.UnicycleModel;
import pt.lsts.neptus.types.coord.LocationType;

public class YoYoPreview
implements IManeuverPreview<YoYo> {
    protected LocationType destination;
    protected double speed;
    protected boolean finished = false;
    double amplitude = 0.0;
    boolean descending = true;
    boolean altitude = false;
    double maxZ;
    double minZ;
    UnicycleModel model = new UnicycleModel();

    @Override
    public boolean init(String vehicleId, YoYo man, SystemPositionAndAttitude state, Object manState) {
        this.destination = new LocationType(man.getManeuverLocation());
        if (man.getManeuverLocation().getZUnits() == ManeuverLocation.Z_UNITS.DEPTH) {
            this.destination.setDepth(man.getManeuverLocation().getZ());
            this.altitude = false;
            this.amplitude = man.getAmplitude();
            this.minZ = man.getManeuverLocation().getZ() - this.amplitude;
            this.maxZ = man.getManeuverLocation().getZ() + this.amplitude;
        } else {
            this.destination.setDepth(Math.max(0.5, 10.0 - man.getManeuverLocation().getZ()));
            this.altitude = true;
            this.minZ = man.getManeuverLocation().getZ() + this.amplitude;
            this.maxZ = man.getManeuverLocation().getZ() - this.amplitude;
        }
        this.speed = man.getSpeed();
        if (man.getUnits().equals("RPM")) {
            this.speed = SpeedConversion.convertRpmtoMps(this.speed);
        } else if (man.getUnits().equals("%")) {
            this.speed = SpeedConversion.convertPercentageToMps(this.speed);
        }
        this.speed = Math.min(this.speed, 2.0);
        this.amplitude = man.getAmplitude();
        this.model.setState(state);
        return true;
    }

    @Override
    public SystemPositionAndAttitude step(SystemPositionAndAttitude state, double timestep) {
        this.model.setState(state);
        boolean arrivedZ = false;
        boolean arrivedXY = false;
        if (this.descending) {
            LocationType dest = new LocationType(this.destination);
            dest.translatePosition(0.0, 0.0, this.amplitude);
            dest.convertToAbsoluteLatLonDepth();
            arrivedXY = this.model.guide(dest, this.speed, this.altitude ? Double.valueOf(this.maxZ) : null);
            arrivedZ = !this.altitude ? Math.abs(this.model.getCurrentPosition().getDepth() - this.maxZ) < 0.5 : Math.abs(this.model.getCurrentAltitude() - this.maxZ) < 0.5;
        } else {
            LocationType dest = new LocationType(this.destination);
            dest.translatePosition(0.0, 0.0, -this.amplitude);
            dest.convertToAbsoluteLatLonDepth();
            arrivedXY = this.model.guide(dest, this.speed, this.altitude ? Double.valueOf(this.minZ) : null);
            if (!this.altitude) {
                arrivedZ = Math.abs(this.model.getCurrentPosition().getDepth() - this.minZ) < 0.25;
            } else {
                boolean bl = arrivedZ = Math.abs(this.model.getCurrentAltitude() - this.minZ) < 0.25;
            }
        }
        if (arrivedXY) {
            this.finished = true;
        } else if (arrivedZ) {
            boolean bl = this.descending = !this.descending;
        }
        if (!this.finished) {
            this.model.advance(timestep);
        }
        return this.model.getState();
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void reset(SystemPositionAndAttitude state) {
        this.model.setState(state);
    }

    @Override
    public Object getState() {
        return null;
    }
}

