/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.preview.payloads;

import java.awt.Color;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.preview.payloads.PayloadFingerprint;

public class MultibeamFingerprint
extends PayloadFingerprint {
    protected double range;
    protected double amplitude;

    public MultibeamFingerprint(double range, double amplitude) {
        super("Multibeam", new Color(0, 0, 192, 128));
        this.range = range;
        this.amplitude = amplitude;
    }

    @Override
    public Area getFingerprint(SystemPositionAndAttitude pose) {
        if (pose.getAltitude() > this.range) {
            return new Area(new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0));
        }
        double hyp = pose.getAltitude() / Math.cos(this.amplitude);
        if (hyp >= this.range) {
            double mbRange = pose.getAltitude() * Math.tan(this.amplitude) / 2.0;
            return new Area(new Rectangle2D.Double(-mbRange, -1.3, mbRange * 2.0, 1.6));
        }
        double visibleAngle = Math.acos(pose.getAltitude() / this.range);
        double mbRange = pose.getAltitude() * Math.tan(visibleAngle) / 2.0;
        return new Area(new Rectangle2D.Double(-mbRange, -1.3, mbRange * 2.0, 1.6));
    }
}

