/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.preview.payloads;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import pt.lsts.imc.EntityParameter;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.SetEntityParameters;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.preview.payloads.MultibeamFingerprint;
import pt.lsts.neptus.mp.preview.payloads.PayloadFingerprint;
import pt.lsts.neptus.mp.preview.payloads.SidescanFingerprint;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class PayloadFactory {
    public static Collection<PayloadFingerprint> getPayloads(Maneuver m) {
        IMCMessage[] msgs;
        Vector<PayloadFingerprint> payloads = new Vector<PayloadFingerprint>();
        for (IMCMessage msg : msgs = m.getStartActions().getAllMessages()) {
            if (!(msg instanceof SetEntityParameters)) continue;
            payloads.addAll(PayloadFactory.parse((SetEntityParameters)msg));
        }
        return payloads;
    }

    public static LinkedHashMap<String, Collection<PayloadFingerprint>> getPayloads(PlanType plan) {
        LinkedHashMap<String, Collection<PayloadFingerprint>> payloads = new LinkedHashMap<String, Collection<PayloadFingerprint>>();
        for (Maneuver m : plan.getGraph().getAllManeuvers()) {
            payloads.put(m.getId(), PayloadFactory.getPayloads(m));
        }
        return payloads;
    }

    private static Collection<PayloadFingerprint> parse(SetEntityParameters msg) {
        Vector<PayloadFingerprint> pf = new Vector<PayloadFingerprint>();
        if (msg.getName().equals("Sidescan")) {
            boolean active = false;
            Vector<SidescanFingerprint> sidescanRanges = new Vector<SidescanFingerprint>();
            for (EntityParameter p : msg.getParams()) {
                if (p.getName().equals("Range") || p.getName().equals("High-Frequency Range") || p.getName().equals("Low-Frequency Range")) {
                    sidescanRanges.add(new SidescanFingerprint(Double.parseDouble(p.getValue())));
                    continue;
                }
                if (!p.getName().equals("Active")) continue;
                active = p.getValue().equalsIgnoreCase("true");
            }
            if (active) {
                pf.addAll(sidescanRanges);
            }
        } else if (msg.getName().equals("Multibeam")) {
            double range = 0.0;
            boolean active = false;
            for (EntityParameter p : msg.getParams()) {
                if (p.getName().equals("Active")) {
                    active = p.getValue().equalsIgnoreCase("true");
                    continue;
                }
                if (!p.getName().equals("Range")) continue;
                range = Double.parseDouble(p.getValue());
            }
            if (active) {
                pf.add(new MultibeamFingerprint(range, Math.toRadians(60.0)));
            }
        }
        return pf;
    }
}

