/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.templates;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Window;
import javax.swing.ImageIcon;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.mp.templates.InfiniteRectTemplate;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public abstract class AbstractPlanTemplate
implements PropertiesProvider {
    protected MissionType mission = null;
    protected MapGroup map = null;

    public boolean editProperties(Window parentComp, MissionType mission) {
        return PropertiesEditor.editProperties((PropertiesProvider)this, parentComp, true);
    }

    public MissionType getMission() {
        return this.mission;
    }

    public void setMission(MissionType mission) {
        this.mission = mission;
    }

    public abstract PlanType generatePlan() throws Exception;

    @Override
    public DefaultProperty[] getProperties() {
        return PluginUtils.getPluginProperties(this);
    }

    @Override
    public void setProperties(Property[] properties) {
        PluginUtils.setPluginProperties((Object)this, properties);
    }

    @Override
    public String getPropertiesDialogTitle() {
        return PluginUtils.getPluginName(this.getClass()) + " parameters";
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return PluginUtils.validatePluginProperties((Object)this, properties);
    }

    public String getName() {
        return PluginUtils.getPluginName(this.getClass());
    }

    public String getDescription() {
        return PluginUtils.getPluginDescription(this.getClass());
    }

    public ImageIcon getImageIcon() {
        return ImageUtils.getIcon(PluginUtils.getPluginIcon(this.getClass()));
    }

    public static PlanType addTemplateToMission(Window parentComp, MissionType mt, Class<?> templateClass) {
        try {
            AbstractPlanTemplate planTemplate = (AbstractPlanTemplate)templateClass.newInstance();
            planTemplate.mission = mt;
            boolean canceled = planTemplate.editProperties(parentComp, mt);
            if (canceled) {
                return null;
            }
            PlanType plan = planTemplate.generatePlan();
            return plan;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        MissionType mt = new MissionType();
        AbstractPlanTemplate.addTemplateToMission(null, mt, InfiniteRectTemplate.class);
    }
}

