/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.templates;

import com.l2fprod.common.propertysheet.DefaultProperty;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.templates.AbstractPlanTemplate;
import pt.lsts.neptus.mp.templates.PlanCreator;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.conf.ConfigFetch;

@PluginDescription(name="Infinite Rectangle", author="ZP", description="Follows a rectangle forever, optionally having multiple depths")
public class InfiniteRectTemplate
extends AbstractPlanTemplate {
    @NeptusProperty(name="Width", description="Width of the rectangle, in meters")
    public double width = 50.0;
    @NeptusProperty(name="Height", description="Height of the rectangle, in meters")
    public double height = 50.0;
    @NeptusProperty(name="Depths", description="Enter the various depths, separated by commas")
    public String depths = "0,1";
    @NeptusProperty(name="Start location", description="The place to start from")
    public LocationType loc = new LocationType();
    @NeptusProperty(name="Is infinite", description="Set to true links the last maneuver to the first creating a cicled plan")
    public boolean isInfinite = false;

    @Override
    public DefaultProperty[] getProperties() {
        if (this.loc.getDistanceInMeters(LocationType.ABSOLUTE_ZERO) == 0.0 && this.mission != null) {
            this.loc.setLocation(IMCUtils.lookForStartPosition(this.mission));
        }
        return super.getProperties();
    }

    private double[] parseDepths() throws Exception {
        String[] parts = this.depths.split("[, ]");
        double[] depths = new double[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            depths[i] = Double.parseDouble(parts[i]);
        }
        return depths;
    }

    @Override
    public PlanType generatePlan() throws Exception {
        double[] depths = this.parseDepths();
        LocationType l = new LocationType(this.loc);
        PlanCreator planCreator = new PlanCreator(this.mission);
        String lastId = "1";
        for (int i = 0; i < depths.length; ++i) {
            l.setAbsoluteDepth(depths[i]);
            planCreator.setLocation(l);
            planCreator.setZ(depths[i], ManeuverLocation.Z_UNITS.DEPTH);
            planCreator.addGoto(null);
            planCreator.move(this.width, 0.0);
            planCreator.addGoto(null);
            planCreator.move(0.0, this.height);
            planCreator.addGoto(null);
            planCreator.move(-this.width, 0.0);
            lastId = planCreator.addGoto(null);
        }
        PlanType plan = planCreator.getPlan();
        if (this.isInfinite) {
            plan.getGraph().addTransition(lastId, "1", "true");
        }
        return plan;
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        InfiniteRectTemplate sq = new InfiniteRectTemplate();
        sq.loc = new LocationType();
        sq.loc.translatePosition(100.0, 100.0, 20.0);
        sq.depths = "0";
        sq.width = 40.0;
        try {
            PlanType plan = sq.generatePlan();
            NeptusLog.pub().info((Object)("<###> " + plan.asXML()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

