/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.templates;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.Goto;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.maneuvers.Loiter;
import pt.lsts.neptus.mp.maneuvers.PopUp;
import pt.lsts.neptus.mp.maneuvers.Unconstrained;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.ReflectionUtil;

public class PlanCreator {
    protected PlanType plan;
    protected double speed = 1000.0;
    protected Maneuver.SPEED_UNITS speed_units = Maneuver.SPEED_UNITS.RPM;
    protected ManeuverLocation loc = new ManeuverLocation();
    protected int count = 1;
    private LinkedHashMap<String, Class<?>> maneuvers = new LinkedHashMap();

    public PlanCreator(MissionType mission) {
        Class<?>[] mans;
        for (Class<?> c : mans = ReflectionUtil.listManeuvers()) {
            this.maneuvers.put(c.getSimpleName().toLowerCase(), c);
        }
        this.plan = new PlanType(mission);
    }

    public void setDepth(double depth) {
        this.setZ(depth, ManeuverLocation.Z_UNITS.DEPTH);
    }

    public void setSpeed(double speed, Maneuver.SPEED_UNITS units) {
        this.speed = speed;
        this.speed_units = units;
    }

    public void setZ(double z, ManeuverLocation.Z_UNITS units) {
        this.loc.setZ(z);
        this.loc.setZUnits(units);
    }

    public void move(double north, double east) {
        this.loc.translatePosition(north, east, 0.0);
    }

    public void move(double north, double east, double down) {
        this.loc.translatePosition(north, east, down);
    }

    public void setLocation(LocationType loc) {
        if (loc != null) {
            this.loc.setLocation(loc);
        }
    }

    public void addTransition(String sourceManeuver, String targetManeuver, String condition) {
        this.plan.getGraph().addTransition(sourceManeuver, targetManeuver, condition);
    }

    public String addManeuver(String name, Map<Object, Object> obj) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        for (Object o : obj.keySet()) {
            props.put(o.toString(), obj.get(o.toString()));
        }
        return this.addManeuver(name, props);
    }

    public String addManeuver(String name, Object ... values) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (int i = 0; i < values.length; i += 2) {
            if (!(values[i] instanceof String) || values[i + 1] == null) continue;
            properties.put(values[i].toString(), values[i + 1]);
        }
        return this.addManeuver(name, properties);
    }

    public String addManeuver(String name) {
        return this.addManeuver(name, new LinkedHashMap<String, Object>());
    }

    public String addManeuver(String name, LinkedHashMap<String, Object> properties) {
        Class<?> man = this.maneuvers.get(name.toLowerCase());
        if (man != null) {
            return this.addManeuver(man, properties);
        }
        NeptusLog.pub().info((Object)("<###>The maneuver " + name + " was not found"));
        return null;
    }

    public String addManeuver(Maneuver man, LinkedHashMap<String, Object> properties) {
        String before = "" + (this.count - 1);
        String id = "" + this.count;
        try {
            Method speedSetter = man.getClass().getMethod("setSpeed", Double.TYPE);
            Method speedUnitsSetter = man.getClass().getMethod("setSpeedUnits", String.class);
            speedSetter.invoke((Object)man, this.speed);
            switch (this.speed_units) {
                case RPM: {
                    speedUnitsSetter.invoke((Object)man, "RPM");
                    break;
                }
                case METERS_PS: {
                    speedUnitsSetter.invoke((Object)man, "m/s");
                    break;
                }
                case PERCENTAGE: {
                    speedUnitsSetter.invoke((Object)man, "%");
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (properties != null) {
            Iterator<String> i$ = properties.keySet().iterator();
            while (i$.hasNext()) {
                String key;
                String k = key = i$.next();
                if (Character.isLetter(key.charAt(0))) {
                    k = Character.toUpperCase(key.charAt(0)) + key.substring(1);
                }
                try {
                    for (Method m : man.getClass().getDeclaredMethods()) {
                        if (!m.getName().equalsIgnoreCase("set" + k) || m.getParameterTypes().length != 1) continue;
                        if (m.getParameterTypes()[0].isAssignableFrom(properties.get(key).getClass())) {
                            Object o = m.getParameterTypes()[0].cast(properties.get(key));
                            m.invoke((Object)man, o);
                            continue;
                        }
                        if (!m.getParameterTypes()[0].isPrimitive()) continue;
                        Class<?> c = m.getParameterTypes()[0];
                        Object obj = properties.get(key);
                        Double d = (double)Double.valueOf(obj.toString());
                        if (c == Integer.TYPE) {
                            obj = d.intValue();
                        } else if (c == Float.TYPE) {
                            obj = Float.valueOf(d.floatValue());
                        } else if (c == Short.TYPE) {
                            obj = d.shortValue();
                        } else if (c == Byte.TYPE) {
                            obj = d.byteValue();
                        } else if (c == Long.TYPE) {
                            obj = d.longValue();
                        }
                        m.invoke((Object)man, obj);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (man instanceof LocatedManeuver) {
            ((LocatedManeuver)((Object)man)).setManeuverLocation(this.loc.clone());
        }
        man.setId(id);
        if (this.plan.getGraph().getAllManeuvers().length == 0) {
            man.setInitialManeuver(true);
        }
        this.plan.getGraph().addManeuver(man);
        if (this.plan.getGraph().getManeuver(before) != null) {
            this.addTransition(before, id, "true");
        }
        ++this.count;
        return id;
    }

    public String addManeuver(Class<?> manClass, LinkedHashMap<String, Object> properties) {
        try {
            Maneuver man = (Maneuver)manClass.newInstance();
            return this.addManeuver(man, properties);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public PlanType getPlan() {
        return this.plan;
    }

    public String addGoto(LinkedHashMap<String, Object> properties) {
        return this.addManeuver(Goto.class, properties);
    }

    public String addLoiter(LinkedHashMap<String, Object> properties) {
        return this.addManeuver(Loiter.class, properties);
    }

    public String addUnconstrained(LinkedHashMap<String, Object> properties) {
        return this.addManeuver(Unconstrained.class, properties);
    }

    public String addPopup(LinkedHashMap<String, Object> properties) {
        return this.addManeuver(PopUp.class, properties);
    }
}

