/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.templates;

import com.l2fprod.common.propertysheet.DefaultProperty;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.templates.AbstractPlanTemplate;
import pt.lsts.neptus.mp.templates.PlanCreator;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;

@PluginDescription(name="Rows Plan", author="ZP", description="Multiple tracks over a rectangular area")
public class RowsTemplate
extends AbstractPlanTemplate {
    @NeptusProperty(name="Length", description="Length, in meters of the area to be surveyed")
    public double height = 100.0;
    @NeptusProperty(name="Width", description="Width, in meters of the area to be surveyed")
    public double width = 100.0;
    @NeptusProperty(name="Number of Rows", description="The number of tracks to be generated. Distance between rows will be (Width/NumberOfRows)")
    public int numRows = 5;
    @NeptusProperty(name="Depths", description="Enter the various depths to scan, separated by commas.")
    public String depths = "1,2,3";
    @NeptusProperty(name="Start location", description="The place to start from")
    public LocationType loc = new LocationType();
    protected static final int DIR_YUP = 0;
    protected static final int DIR_X1 = 1;
    protected static final int DIR_YDOWN = 2;
    protected static final int DIR_X2 = 3;

    @Override
    public DefaultProperty[] getProperties() {
        if (this.loc.getDistanceInMeters(LocationType.ABSOLUTE_ZERO) == 0.0 && this.mission != null) {
            this.loc.setLocation(IMCUtils.lookForStartPosition(this.mission));
        }
        return super.getProperties();
    }

    private double[] parseDepths() throws Exception {
        String[] parts = this.depths.split("[ ,]");
        double[] depths = new double[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            depths[i] = Double.parseDouble(parts[i]);
        }
        return depths;
    }

    @Override
    public PlanType generatePlan() throws Exception {
        double[] depths = this.parseDepths();
        PlanCreator planCreator = new PlanCreator(this.mission);
        LocationType l = new LocationType(this.loc);
        planCreator.setLocation(l);
        planCreator.setZ(depths[0], ManeuverLocation.Z_UNITS.DEPTH);
        planCreator.addGoto(null);
        int direction = 3;
        int sign = 1;
        for (int i = 0; i < depths.length; ++i) {
            planCreator.setZ(depths[i], ManeuverLocation.Z_UNITS.DEPTH);
            double x = 0.0;
            boolean done = false;
            block5: while (!done) {
                ++direction;
                switch (direction %= 4) {
                    case 0: {
                        planCreator.move(this.width, 0.0);
                        planCreator.addGoto(null);
                        continue block5;
                    }
                    case 2: {
                        planCreator.move(-this.width, 0.0);
                        planCreator.addGoto(null);
                        continue block5;
                    }
                }
                x += this.height / (double)this.numRows;
                if (x > this.height) {
                    done = true;
                    --direction;
                    continue;
                }
                planCreator.move(0.0, this.height / (double)this.numRows * (double)sign);
                planCreator.addGoto(null);
            }
            sign = -sign;
        }
        return planCreator.getPlan();
    }
}

