/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.templates;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.mp.templates.AbstractPlanTemplate;
import pt.lsts.neptus.mp.templates.PlanCreator;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class ScriptedPlanTemplate
extends AbstractPlanTemplate {
    protected ScriptEngineManager manager = new ScriptEngineManager();
    protected ScriptEngine engine = this.manager.getEngineByName("js");
    protected CompiledScript script = null;
    protected String source = "";
    protected LinkedHashMap<String, Object> properties = new LinkedHashMap();
    private String commonScript = "importPackage(java.util);\nfunction param(name, value) {\nif (mode == 0)\nproperties.put(name, value);\nreturn properties.get(name);\n}\nfunction move(north, east, down) {\nplan.move(north, east, down);\n}\nfunction maneuver(name, props) {\nif (props)\nreturn plan.addManeuver(name, props);\nelse\nreturn plan.addManeuver(name);\n}\n";

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public PlanType generatePlan() throws Exception {
        if (this.script == null) {
            this.script = ((Compilable)((Object)this.engine)).compile(this.commonScript + this.source);
        }
        PlanCreator planCreator = new PlanCreator(this.mission);
        Bindings bindings = this.engine.createBindings();
        bindings.put("properties", (Object)this.properties);
        bindings.put("mode", (Object)1);
        bindings.put("mission", (Object)this.mission);
        bindings.put("plan", (Object)planCreator);
        this.script.eval(bindings);
        return planCreator.getPlan();
    }

    @Override
    public DefaultProperty[] getProperties() {
        LinkedHashMap properties = new LinkedHashMap();
        try {
            if (this.script == null) {
                this.script = ((Compilable)((Object)this.engine)).compile(this.source + this.commonScript);
            }
            PlanCreator planCreator = new PlanCreator(this.mission);
            Bindings bindings = this.engine.createBindings();
            bindings.put("mode", (Object)0);
            bindings.put("mission", (Object)this.mission);
            bindings.put("plan", (Object)planCreator);
            bindings.put("properties", (Object)properties);
            this.script.eval(bindings);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Vector<DefaultProperty> props = new Vector<DefaultProperty>();
        for (String name : properties.keySet()) {
            Object value = properties.get(name);
            if (name.equals("name")) continue;
            props.add(PropertiesEditor.getPropertyInstance(name, value.getClass(), value, true));
        }
        return props.toArray(new DefaultProperty[0]);
    }

    @Override
    public void setProperties(Property[] properties) {
        for (Property p : properties) {
            this.properties.put(p.getName(), p.getValue());
        }
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        MissionType mt = new MissionType("missions/APDL/missao-apdl.nmisz");
        String script = FileUtil.getFileAsString(new File("conf/planscripts/rows.js"));
        ScriptedPlanTemplate planTemplate = new ScriptedPlanTemplate();
        planTemplate.mission = mt;
        planTemplate.source = script;
        PropertiesEditor.editProperties(planTemplate, true);
    }
}

