/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.templates;

import com.l2fprod.common.propertysheet.DefaultProperty;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.templates.AbstractPlanTemplate;
import pt.lsts.neptus.mp.templates.PlanCreator;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;

@PluginDescription(name="YoYo Survey", author="ZP", description="Survey the water column around a moving point")
public class YoYoTemplate
extends AbstractPlanTemplate {
    @NeptusProperty(name="Center location", description="The center of the survey (point of interest)")
    public LocationType loc = new LocationType();
    @NeptusProperty(name="Size", description="Length, in meters of the side length of the survey")
    public double size = 100.0;
    @NeptusProperty(name="Maximum Depth", description="Maximum depth of the yoyo behavior")
    public double maxdepth = 20.0;
    @NeptusProperty(name="Minimum Depth", description="Maximum depth of the yoyo behavior")
    public double mindepth = 2.0;
    @NeptusProperty(name="Speed", description="Travelling speed (in m/s)")
    public double speed = 1.1;
    @NeptusProperty(name="Rotation", description="Rotation of the survey square, in degrees")
    public double rot = 0.0;
    @NeptusProperty(name="Movement towards north", description="Velocity of the point of interest")
    public double vn = 0.0;
    @NeptusProperty(name="Movement towards east", description="Velocity of the point of interest")
    public double ve = 0.0;
    @NeptusProperty(name="Popup duration", description="Duration of the popups at corners")
    public int popup = 60;
    @NeptusProperty(name="Pitch angle", description="Pitch angle to be used in yoyo maneuvers (degrees)")
    public double pitch = 15.0;
    protected static final int DIR_YUP = 0;
    protected static final int DIR_X1 = 1;
    protected static final int DIR_YDOWN = 2;
    protected static final int DIR_X2 = 3;

    @Override
    public DefaultProperty[] getProperties() {
        if (this.loc.getDistanceInMeters(LocationType.ABSOLUTE_ZERO) == 0.0 && this.mission != null) {
            this.loc.setLocation(IMCUtils.lookForStartPosition(this.mission));
        }
        return super.getProperties();
    }

    @Override
    public PlanType generatePlan() throws Exception {
        PlanCreator planCreator = new PlanCreator(this.mission);
        planCreator.setSpeed(this.speed, Maneuver.SPEED_UNITS.METERS_PS);
        LocationType center = new LocationType(this.loc);
        double radius = Math.sqrt(this.size * this.size / 2.0);
        double ang = Math.toRadians(45.0 + this.rot);
        double time = 0.0;
        planCreator.setLocation(center);
        planCreator.move(Math.sin(ang) * radius + this.vn * time, Math.cos(ang) * radius + this.ve * time);
        planCreator.setDepth(this.mindepth);
        planCreator.addGoto(null);
        if (this.popup > 0) {
            planCreator.setDepth(0.0);
            planCreator.addManeuver("PopUp", "duration", this.popup, "radius", 20);
        }
        double amplitude = (this.maxdepth - this.mindepth) / 2.0;
        double depth = (this.maxdepth + this.mindepth) / 2.0;
        for (int i = 0; i < 4; ++i) {
            ang = Math.toRadians((double)(i * 90 + 135) + this.rot);
            planCreator.setLocation(center);
            planCreator.move(Math.sin(ang) * radius + (time += this.size * this.speed) * this.vn, Math.cos(ang) * radius + time * this.ve);
            planCreator.setDepth(depth);
            planCreator.addManeuver("YoYo", "amplitude", amplitude, "pitchAngle", Math.toRadians(this.pitch));
            if (this.popup <= 0) continue;
            planCreator.setDepth(0.0);
            planCreator.addManeuver("PopUp", "duration", this.popup, "radius", 20);
        }
        return planCreator.getPlan();
    }
}

