/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.types.coord.LocationType;

public class LogMarker
implements Serializable,
Comparable<LogMarker> {
    private static final long serialVersionUID = 1L;
    private String label;
    private double timestamp;
    private double lat;
    private double lon;

    public LogMarker(String label, double timestamp, double lat, double lon) {
        this.label = label;
        this.timestamp = timestamp;
        this.lat = lat;
        this.lon = lon;
    }

    @Override
    public int compareTo(LogMarker o) {
        if (o.timestamp > this.timestamp) {
            return -1;
        }
        if (o.timestamp < this.timestamp) {
            return 1;
        }
        return 0;
    }

    public static Collection<LogMarker> load(IMraLogGroup source) {
        ArrayList<LogMarker> logMarkers = new ArrayList<LogMarker>();
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(source.getFile("Data.lsf").getParent() + "/marks.dat"));
            for (LogMarker marker : (ArrayList)ois.readObject()) {
                logMarkers.add(marker);
            }
            ois.close();
        }
        catch (Exception e) {
            NeptusLog.pub().info((Object)"No markers for this log, or erroneous mark file");
        }
        return logMarkers;
    }

    public static void save(ArrayList<LogMarker> logMarkers, IMraLogGroup source) {
        try {
            ObjectOutputStream dos = new ObjectOutputStream(new FileOutputStream(source.getFile(".").getParent() + "/marks.dat"));
            dos.writeObject(logMarkers);
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LocationType getLocation() {
        return new LocationType(Math.toDegrees(this.lat), Math.toDegrees(this.lon));
    }

    public String getLabel() {
        return this.label;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public Date getDate() {
        return new Date((long)this.timestamp);
    }
}

