/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeriesCollection;
import pt.lsts.neptus.gui.SelectAllFocusListener;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.LogStatisticsItem;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.MRAProperties;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.MRA2DPlot;
import pt.lsts.neptus.mra.plots.MRATimeSeriesPlot;
import pt.lsts.neptus.mra.plots.TimedXYDataItem;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.llf.LsfReport;
import pt.lsts.neptus.util.llf.LsfReportProperties;
import pt.lsts.neptus.util.llf.chart.LLFChart;

public class MRAChartPanel
extends JPanel
implements ChartMouseListener {
    private static final long serialVersionUID = 1L;
    private LLFChart chart;
    private double timestep = MRAProperties.defaultTimestep;
    private ChartPanel cpanel = null;
    private IMraLogGroup source;
    private JTextField timeStepField;
    private JButton selectEntities;
    private JLabel lblX = new JLabel();
    private JLabel lblY = new JLabel();
    JPanel controlPanel = new JPanel(new FlowLayout(2));
    MRAPanel mraPanel;
    double mouseValue;

    public MRAChartPanel(LLFChart chart, IMraLogGroup source, MRAPanel panel) {
        this.mraPanel = panel;
        this.chart = chart;
        this.source = source;
        this.timestep = chart.supportsVariableTimeSteps() ? Math.max(chart.getDefaultTimeStep(), this.timestep) : 0.0;
        this.setLayout(new BorderLayout(2, 2));
        final Vector<LogStatisticsItem> items = chart.getStatistics();
        final String chartName = chart.getName();
        this.controlPanel.add(this.lblX);
        this.controlPanel.add(this.lblY);
        if (items != null) {
            JButton info = new JButton(I18n.text("Statistics..."));
            info.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[][] model = new String[items.size()][2];
                    for (int i = 0; i < items.size(); ++i) {
                        model[i][0] = ((LogStatisticsItem)items.get(i)).getName();
                        model[i][1] = ((LogStatisticsItem)items.get(i)).getValue();
                    }
                    JTable table = new JTable(model, new String[]{I18n.text("Name"), I18n.text("Value")});
                    JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(MRAChartPanel.this));
                    dialog.setTitle(I18n.textf("Statistics for %chartname", chartName));
                    JScrollPane scroll = new JScrollPane(table);
                    dialog.getContentPane().add(scroll);
                    dialog.setSize(300, 500);
                    GuiUtils.centerOnScreen(dialog);
                    dialog.setDefaultCloseOperation(2);
                    dialog.setVisible(true);
                }
            });
            this.controlPanel.add(info);
        }
        if (chart.supportsVariableTimeSteps()) {
            JButton redraw = new JButton(I18n.text("Redraw"));
            this.timeStepField = new JTextField("" + this.timestep, 4);
            if (MRATimeSeriesPlot.class.isAssignableFrom(chart.getClass())) {
                this.selectEntities = new JButton(I18n.text("Series..."));
                this.controlPanel.add(this.selectEntities);
                this.selectEntities.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        MRAChartPanel.this.selectEntities();
                    }
                });
            }
            this.controlPanel.add(new JLabel(I18n.text("Time Step:")));
            this.controlPanel.add(this.timeStepField);
            this.controlPanel.add(redraw);
            ActionListener l = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double val = Double.NaN;
                    try {
                        val = Double.parseDouble(MRAChartPanel.this.timeStepField.getText());
                    }
                    catch (Exception ex) {
                        val = Double.NaN;
                    }
                    if (!(val < 0.0) && !Double.isNaN(val) && val != MRAChartPanel.this.timestep) {
                        MRAChartPanel.this.timestep = val;
                        MRAChartPanel.this.regeneratePanel();
                    }
                    MRAChartPanel.this.timeStepField.setText(MRAChartPanel.this.timestep + "");
                }
            };
            redraw.addActionListener(l);
            this.timeStepField.addActionListener(l);
            this.timeStepField.addFocusListener(new SelectAllFocusListener());
        }
        if (chart.supportsVariableTimeSteps() || chart.getStatistics() != null) {
            this.add((Component)this.controlPanel, "South");
        }
        this.regeneratePanel();
    }

    public ChartPanel getCpanel() {
        return this.cpanel;
    }

    protected void selectEntities() {
        boolean allSelected = true;
        MRATimeSeriesPlot chart = (MRATimeSeriesPlot)this.chart;
        JCheckBox[] checks = new JCheckBox[chart.getSeriesNames().size() + 1];
        int i = 0;
        for (String name : chart.getSeriesNames()) {
            checks[i] = new JCheckBox(name);
            checks[i].setOpaque(false);
            checks[i].setForeground(Color.black);
            if (chart.getForbiddenSeries().contains(name)) {
                checks[i].setSelected(false);
                allSelected = false;
            } else {
                checks[i].setSelected(true);
            }
            ++i;
        }
        i = chart.getSeriesNames().size();
        checks[i] = new JCheckBox(I18n.text("ALL"));
        checks[i].setOpaque(false);
        checks[i].setForeground(Color.black);
        checks[i].setSelected(allSelected);
        final JList<JCheckBox> list = new JList<JCheckBox>(checks);
        list.setCellRenderer((ListCellRenderer<JCheckBox>)new ListCellRenderer<Object>(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JCheckBox check = (JCheckBox)value;
                return check;
            }
        });
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JCheckBox item;
                int selectedIndex = list.locationToIndex(e.getPoint());
                if (selectedIndex < 0) {
                    return;
                }
                item.setSelected(!(item = (JCheckBox)list.getModel().getElementAt(selectedIndex)).isSelected());
                list.setSelectedIndex(selectedIndex);
                if (!item.isSelected()) {
                    ((JCheckBox)list.getModel().getElementAt(list.getModel().getSize() - 1)).setSelected(false);
                }
                if (selectedIndex == list.getModel().getSize() - 1) {
                    for (int i = 0; i < list.getModel().getSize(); ++i) {
                        ((JCheckBox)list.getModel().getElementAt(i)).setSelected(item.isSelected());
                    }
                }
                list.repaint();
            }
        });
        final JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(this));
        dialog.getContentPane().setLayout(new BorderLayout());
        JPanel inner = new JPanel();
        inner.setBackground(list.getBackground());
        inner.setLayout(new BoxLayout(inner, 3));
        dialog.getContentPane().add((Component)inner, "Center");
        inner.add(new JScrollPane(list, 20, 31));
        inner.add(new JLabel());
        JButton okButton = new JButton(new AbstractAction(I18n.text("OK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        GuiUtils.reactEnterKeyPress(okButton);
        dialog.getContentPane().add((Component)okButton, "South");
        dialog.setSize(300, 400);
        dialog.setTitle(I18n.text("Select Entities"));
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        GuiUtils.centerParent(dialog, SwingUtilities.getWindowAncestor(this));
        dialog.setVisible(true);
        chart.getForbiddenSeries().clear();
        for (int o = 0; o < checks.length - 1; ++o) {
            if (checks[o].isSelected()) continue;
            chart.getForbiddenSeries().add(checks[o].getText());
        }
        this.regeneratePanel();
    }

    public void regeneratePanel() {
        if (this.cpanel != null) {
            this.remove((Component)this.cpanel);
        }
        JFreeChart c = this.chart.getChart(this.source, this.timestep);
        this.cpanel = new ChartPanel(c);
        this.cpanel.getPopupMenu().add(I18n.text("Add Mark")).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LsfReportProperties.generatingReport) {
                    GuiUtils.infoMessage(MRAChartPanel.this.mraPanel.getRootPane(), I18n.text("Can not add Marks"), I18n.text("Can not add Marks - Generating Report."));
                    return;
                }
                String res = JOptionPane.showInputDialog(I18n.text("Marker name"));
                if (res != null && !res.isEmpty()) {
                    MRAChartPanel.this.mraPanel.addMarker(new LogMarker(res, MRAChartPanel.this.mouseValue, 0.0, 0.0));
                }
            }
        });
        this.cpanel.getPopupMenu().add(I18n.text("Save as PDF")).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileFilter(GuiUtils.getCustomFileFilter(I18n.text("PDF files"), "pdf"));
                int op = chooser.showSaveDialog(MRAChartPanel.this);
                if (op == 0) {
                    if (LsfReport.savePdf(MRAChartPanel.this.source, MRAChartPanel.this.chart, chooser.getSelectedFile())) {
                        GuiUtils.infoMessage(MRAChartPanel.this, I18n.text("Save as PDF"), I18n.textf("File saved successfully to %fileLocation", chooser.getSelectedFile().getAbsolutePath()));
                    } else {
                        GuiUtils.errorMessage(MRAChartPanel.this, I18n.text("Save as PDF"), I18n.text("Error exporting to PDF"));
                    }
                }
            }
        });
        this.cpanel.addChartMouseListener(new ChartMouseListener(){
            protected final long localTimeOffset = Calendar.getInstance().get(16) + Calendar.getInstance().get(15);

            public void chartMouseMoved(ChartMouseEvent e) {
                MouseEvent me = e.getTrigger();
                int x = me.getX();
                if (!MRAChartPanel.this.cpanel.getPopupMenu().isVisible()) {
                    if (MRAChartPanel.this.chart instanceof MRA2DPlot) {
                        ChartEntity entity = e.getEntity();
                        if (entity != null && entity instanceof XYItemEntity) {
                            XYItemEntity ent = (XYItemEntity)entity;
                            int sindex = ent.getSeriesIndex();
                            int iindex = ent.getItem();
                            MRAChartPanel.this.mouseValue = ((TimedXYDataItem)((XYSeriesCollection)e.getChart().getXYPlot().getDataset()).getSeries((int)sindex).getDataItem((int)iindex)).timestamp;
                        }
                    } else if (e.getChart().getPlot() instanceof XYPlot) {
                        MRAChartPanel.this.mouseValue = e.getChart().getXYPlot().getDomainAxis().java2DToValue((double)x, MRAChartPanel.this.cpanel.getScreenDataArea(), e.getChart().getXYPlot().getDomainAxisEdge()) + (double)this.localTimeOffset;
                    } else if (e.getChart().getPlot() instanceof CategoryPlot) {
                        MRAChartPanel.this.mouseValue = e.getChart().getCategoryPlot().getRangeAxis().java2DToValue((double)x, MRAChartPanel.this.cpanel.getScreenDataArea(), e.getChart().getCategoryPlot().getRangeAxisEdge()) + (double)this.localTimeOffset;
                    }
                }
            }

            public void chartMouseClicked(ChartMouseEvent e) {
            }
        });
        this.add((Component)this.cpanel);
        this.revalidate();
    }

    public void chartMouseClicked(ChartMouseEvent arg0) {
    }

    public void chartMouseMoved(ChartMouseEvent e) {
        Insets insets = this.cpanel.getInsets();
        int x = (int)((double)(e.getTrigger().getX() - insets.left) / this.cpanel.getScaleX());
        double dx = e.getChart().getXYPlot().getDataset().getX(0, x).doubleValue();
        double dy = ((Number)e.getChart().getXYPlot().getDataset().getYValue(0, x)).intValue();
        this.lblX.setText(dx + "");
        this.lblY.setText(dy + "");
    }
}

