/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.zip.GZIPInputStream;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.io.FileUtils;
import pt.lsts.imc.lsf.LsfIndexListener;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.loader.FileHandler;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.NeptusMRA;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.RecentlyOpenedFilesUtil;
import pt.lsts.neptus.util.StreamUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.llf.LsfLogSource;
import pt.lsts.neptus.util.llf.LsfReport;
import pt.lsts.neptus.util.llf.LsfReportProperties;

public class MRAFilesHandler
implements FileHandler {
    private static final String RECENTLY_OPENED_LOGS = "conf/mra_recent.xml";
    private LinkedHashMap<JMenuItem, File> miscFilesOpened = new LinkedHashMap();
    private NeptusMRA mra;
    private File tmpFile = null;
    private InputStream activeInputStream = null;

    public MRAFilesHandler(NeptusMRA mra) {
        this.mra = mra;
    }

    public boolean openLog(File fx) {
        this.mra.getBgp().block(true);
        File fileToOpen = null;
        String errorMessage = "";
        if (fx.getName().toLowerCase().endsWith("lsf.gz")) {
            fileToOpen = this.extractGzip(fx);
        } else if (fx.getName().toLowerCase().endsWith("lsf.bz2")) {
            fileToOpen = this.extractBzip2(fx);
        } else if (fx.getName().toLowerCase().endsWith("lsf")) {
            fileToOpen = fx;
        }
        this.mra.getBgp().block(false);
        if (fileToOpen == null) {
            errorMessage = this.mra.getBgp().getText();
            GuiUtils.errorMessage(this.mra, I18n.text("Invalid LSF file"), I18n.text("LSF file does not exist!") + "\n" + errorMessage);
            return false;
        }
        return this.openLSF(fileToOpen);
    }

    protected void abortPendingOpenLogActions() {
        if (this.activeInputStream != null) {
            try {
                this.activeInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.activeInputStream = null;
        }
        if (this.tmpFile != null && this.tmpFile.exists()) {
            try {
                this.tmpFile.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void closeLogSource() {
        if (this.mra.getMraPanel() != null) {
            this.mra.getMraPanel().cleanup();
            this.mra.setMraPanel(null);
            this.mra.getContentPane().removeAll();
            NeptusLog.pub().info((Object)"Log source was closed.");
        }
    }

    private void openLogSource(IMraLogGroup source) {
        this.abortPendingOpenLogActions();
        this.closeLogSource();
        this.mra.getContentPane().removeAll();
        this.mra.setMraPanel(new MRAPanel(source, this.mra));
        this.mra.getContentPane().add(this.mra.getMraPanel());
        this.mra.invalidate();
        this.mra.validate();
        this.mra.getMRAMenuBar().getSetMissionMenuItem().setEnabled(true);
        this.mra.getMRAMenuBar().getGenReportMenuItem().setEnabled(true);
        this.mra.getMRAMenuBar().getGenReportCustomOptionsMenuItem().setEnabled(true);
    }

    private boolean openLSF(File f) {
        this.mra.getBgp().block(true);
        this.mra.getBgp().setText(I18n.text("Loading LSF Data"));
        if (!f.exists()) {
            this.mra.getBgp().block(false);
            GuiUtils.errorMessage(this.mra, I18n.text("Invalid LSF file"), I18n.text("LSF file does not exist!"));
            return false;
        }
        File lsfDir = f.getParentFile();
        boolean alreadyConverted = false;
        if (lsfDir.isDirectory()) {
            if (new File(lsfDir, "mra/lsf.index").canRead()) {
                alreadyConverted = true;
            }
        } else if (new File(lsfDir, "mra/lsf.index").canRead()) {
            alreadyConverted = true;
        }
        if (alreadyConverted) {
            int option = JOptionPane.showConfirmDialog(this.mra, I18n.text("This log seems to have already been indexed. Index again?"));
            if (option == 0) {
                try {
                    FileUtils.deleteDirectory((File)new File(lsfDir, "mra"));
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)"Error while trying to delete mra/ folder", (Throwable)e);
                }
            }
            if (option == 2) {
                this.mra.getBgp().block(false);
                return false;
            }
        }
        this.mra.getBgp().setText(I18n.text("Loading LSF Data"));
        try {
            LsfLogSource source = new LsfLogSource(f, new LsfIndexListener(){

                public void updateStatus(String messageToDisplay) {
                    MRAFilesHandler.this.mra.getBgp().setText(messageToDisplay);
                }
            });
            this.updateMissionFilesOpened(f);
            this.mra.getBgp().setText(I18n.text("Starting interface"));
            this.openLogSource(source);
            this.mra.getBgp().setText(I18n.text("Done"));
            this.mra.getBgp().block(false);
            return true;
        }
        catch (Exception e) {
            this.mra.getBgp().block(false);
            e.printStackTrace();
            GuiUtils.errorMessage(this.mra, I18n.text("Invalid LSF index"), I18n.text(e.getMessage()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extractGzip(File f) {
        try {
            this.mra.getBgp().setText(I18n.text("Decompressing LSF Data..."));
            GZIPInputStream ginstream = new GZIPInputStream(new FileInputStream(f));
            this.activeInputStream = ginstream;
            File outputFile = new File(f.getParent(), "Data.lsf");
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
            FileOutputStream outstream = new FileOutputStream(outputFile, false);
            byte[] buf = new byte[2048];
            try {
                int len;
                while ((len = ginstream.read(buf)) > 0) {
                    outstream.write(buf, 0, len);
                }
            }
            catch (Exception e) {
                GuiUtils.errorMessage(this.mra, e);
                NeptusLog.pub().error((Object)e);
            }
            finally {
                ginstream.close();
                outstream.close();
            }
            File res = new File(f.getParent(), "Data.lsf");
            return res;
        }
        catch (Exception ioe) {
            System.err.println("Exception has been thrown: " + ioe);
            this.mra.getBgp().setText(I18n.text("Decompressing LSF Data...") + "   " + ioe.getMessage());
            ioe.printStackTrace();
            return null;
        }
    }

    private File extractBzip2(File f) {
        this.mra.getBgp().setText(I18n.text("Decompressing BZip2 LSF Data..."));
        try {
            FileInputStream fxInStream = new FileInputStream(f);
            this.activeInputStream = fxInStream;
            BZip2CompressorInputStream gzDataLog = new BZip2CompressorInputStream((InputStream)fxInStream);
            File outFile = new File(f.getParent(), "Data.lsf");
            if (!outFile.exists()) {
                outFile.createNewFile();
            }
            FilterCopyDataMonitor fis = new FilterCopyDataMonitor((InputStream)gzDataLog){
                long target;
                protected String decompressed;
                {
                    this.target = 0x100000L;
                    this.decompressed = I18n.text("Decompressed");
                }

                @Override
                public void updateValueInMessagePanel() {
                    if (this.downloadedSize > this.target) {
                        MRAFilesHandler.this.mra.getBgp().setText(this.decompressed + " " + MathMiscUtils.parseToEngineeringRadix2Notation(this.downloadedSize, 2) + "B");
                        this.target += 0x100000L;
                    }
                }
            };
            StreamUtil.copyStreamToFile(fis, outFile);
            fxInStream.close();
            return outFile;
        }
        catch (Exception e) {
            System.err.println("Exception has been thrown: " + e);
            this.mra.getBgp().setText(I18n.text("Decompressing LSF Data...") + "   " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public void generatePDFReport(final File f) {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                GuiUtils.infoMessage(MRAFilesHandler.this.mra, I18n.text("Generating PDF Report..."), I18n.text("Generating PDF Report..."));
                MRAFilesHandler.this.mra.getMRAMenuBar().getReportMenuItem().setEnabled(false);
                LsfReportProperties.generatingReport = true;
                MRAFilesHandler.this.mra.getMraPanel().addStatusBarMsg("Generating Report...");
                return LsfReport.generateReport(MRAFilesHandler.this.mra.getMraPanel().getSource(), f, MRAFilesHandler.this.mra.getMraPanel());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                super.done();
                try {
                    this.get();
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e);
                }
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        GuiUtils.infoMessage(MRAFilesHandler.this.mra, I18n.text("Generate PDF Report"), I18n.text("File saved to") + " " + f.getAbsolutePath());
                        final String pdfF = f.getAbsolutePath();
                        new Thread(){

                            @Override
                            public void run() {
                                MRAFilesHandler.this.openPDFInExternalViewer(pdfF);
                            }
                        }.start();
                    }
                }
                catch (Exception e) {
                    GuiUtils.errorMessage(MRAFilesHandler.this.mra, I18n.text("PDF Creation Process"), "<html>" + I18n.text("PDF <b>was not</b> saved to file.") + "<br>" + I18n.text("Error") + ": " + e.getMessage() + "</html>");
                    e.printStackTrace();
                }
                finally {
                    MRAFilesHandler.this.mra.getBgp().block(false);
                    MRAFilesHandler.this.mra.getMRAMenuBar().getReportMenuItem().setEnabled(true);
                    LsfReportProperties.generatingReport = false;
                    MRAFilesHandler.this.mra.getMraPanel().reDrawStatusBar();
                }
            }
        };
        worker.execute();
    }

    private void openPDFInExternalViewer(String pdf) {
        try {
            if (ConfigFetch.getOS() == 0) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + pdf);
            } else {
                String[] readers = new String[]{"xpdf", "kpdf", "FoxitReader", "evince", "acroread"};
                String reader = null;
                for (int count = 0; count < readers.length && reader == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", readers[count]}).waitFor() != 0) continue;
                    reader = readers[count];
                }
                if (reader == null) {
                    throw new Exception(I18n.text("Could not find PDF reader"));
                }
                Runtime.getRuntime().exec(new String[]{reader, pdf});
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        GuiUtils.infoMessage(this.mra, I18n.text("PDF Report Generated"), I18n.text("File saved to") + " " + pdf);
    }

    public void loadRecentlyOpenedFiles() {
        String recentlyOpenedFiles = ConfigFetch.resolvePath(RECENTLY_OPENED_LOGS);
        if (recentlyOpenedFiles == null || !new File(recentlyOpenedFiles).exists()) {
            return;
        }
        Method methodUpdate = null;
        try {
            Class[] params = new Class[]{File.class};
            methodUpdate = this.getClass().getMethod("updateMissionFilesOpened", params);
            if (methodUpdate == null) {
                NeptusLog.pub().info((Object)"Method update = null");
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(this + "loadRecentlyOpenedFiles"), (Throwable)e);
            return;
        }
        RecentlyOpenedFilesUtil.loadRecentlyOpenedFiles(recentlyOpenedFiles, methodUpdate, this);
    }

    public boolean updateMissionFilesOpened(File fx) {
        RecentlyOpenedFilesUtil.updateFilesOpenedMenuItems(fx, this.getMiscFilesOpened(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object key = e.getSource();
                File value = MRAFilesHandler.this.getMiscFilesOpened().get(key);
                if (!(value instanceof File)) {
                    return;
                }
                final File fx = value;
                Thread t = new Thread("Open Log"){

                    @Override
                    public void run() {
                        MRAFilesHandler.this.mra.getMraFilesHandler().openLog(fx);
                    }
                };
                t.start();
            }
        });
        this.mra.getMRAMenuBar().getRecentlyOpenFilesMenu();
        this.storeRecentlyOpenedFiles();
        return true;
    }

    private void storeRecentlyOpenedFiles() {
        String recentlyOpenedFiles = ConfigFetch.resolvePathBasedOnConfigFile(RECENTLY_OPENED_LOGS);
        LinkedHashMap<JMenuItem, File> hMap = this.getMiscFilesOpened();
        String header = I18n.text("Recently opened mission files") + ".";
        RecentlyOpenedFilesUtil.storeRecentlyOpenedFiles(recentlyOpenedFiles, hMap, header);
    }

    public LinkedHashMap<JMenuItem, File> getMiscFilesOpened() {
        return this.miscFilesOpened;
    }

    public void setMiscFilesOpened(LinkedHashMap<JMenuItem, File> miscFilesOpened) {
        this.miscFilesOpened = miscFilesOpened;
    }

    @Override
    public void handleFile(File f) {
        this.openLog(f);
    }

    @Override
    public String getName() {
        return null;
    }

    private abstract class FilterCopyDataMonitor
    extends FilterInputStream {
        public long downloadedSize;

        public FilterCopyDataMonitor(InputStream in) {
            super(in);
            this.downloadedSize = 0L;
            this.downloadedSize = 0L;
        }

        @Override
        public int read() throws IOException {
            int tmp = super.read();
            this.downloadedSize += tmp == -1 ? 0L : 1L;
            if (tmp != -1) {
                this.updateValueInMessagePanel();
            }
            return tmp;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int tmp = super.read(b, off, len);
            this.downloadedSize += tmp == -1 ? 0L : (long)tmp;
            if (tmp != -1) {
                this.updateValueInMessagePanel();
            }
            return tmp;
        }

        public abstract void updateValueInMessagePanel();
    }
}

