/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra;

import foxtrot.AsyncTask;
import foxtrot.AsyncWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ProgressMonitor;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.gui.AboutPanel;
import pt.lsts.neptus.gui.MissionFileChooser;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.WaitPanel;
import pt.lsts.neptus.gui.swing.NeptusFileView;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.NeptusMRA;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.importers.lsf.ConcatenateLsfLog;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.PluginsRepository;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.RecentlyOpenedFilesUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.llf.LogUtils;
import pt.lsts.neptus.util.llf.LsfReport;
import pt.lsts.neptus.util.logdownload.LogsDownloaderWorker;

public class MRAMenuBar {
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu reportMenu;
    private JMenu settingsMenu;
    private JMenu toolsMenu;
    private JMenu helpMenu;
    private JMenu recentlyOpenFilesMenu = null;
    private JMenu exporters;
    private boolean isExportersAdded = false;
    private AbstractAction openLsf;
    private AbstractAction exit;
    protected AbstractAction genReport;
    protected AbstractAction genReportCustomOptions;
    protected AbstractAction reportOptions;
    private AbstractAction batchReport;
    private AbstractAction preferences;
    private AbstractAction httpDuneDownload;
    private AbstractAction httpVehicleDownload;
    private AbstractAction concatenateLSFLogs;
    private AbstractAction fuseLSFLogs;
    protected AbstractAction setMission;
    private LinkedHashMap<JMenuItem, File> miscFilesOpened;
    private NeptusMRA mra;

    public MRAMenuBar(NeptusMRA mra) {
        this.mra = mra;
    }

    public JMenuBar createMRAMenuBar() {
        this.miscFilesOpened = this.mra.getMraFilesHandler().getMiscFilesOpened();
        this.setMenuBar(new JMenuBar());
        this.setUpFileMenu();
        this.setUpReportMenu();
        this.setUpSettingsMenu();
        this.setUpToolsMenu();
        this.setUpHelpMenu();
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.reportMenu);
        this.menuBar.add(this.settingsMenu);
        this.menuBar.add(this.toolsMenu);
        this.menuBar.add(this.helpMenu);
        return this.menuBar;
    }

    private void setUpFileMenu() {
        this.fileMenu = new JMenu(I18n.text("File"));
        this.getRecentlyOpenFilesMenu();
        this.mra.getMraFilesHandler().loadRecentlyOpenedFiles();
        this.fileMenu.add(this.getRecentlyOpenFilesMenu());
        this.openLsf = new AbstractAction(I18n.text("Open LSF log"), ImageUtils.getIcon("images/menus/zipfolder.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                File lastFile = null;
                try {
                    File file = lastFile = MRAMenuBar.this.miscFilesOpened.size() == 0 ? null : (File)MRAMenuBar.this.miscFilesOpened.values().iterator().next();
                    if (lastFile != null && !lastFile.isDirectory()) {
                        lastFile = lastFile.getParentFile();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                JFileChooser fileChooser = lastFile != null && lastFile.isDirectory() && lastFile.canRead() ? new JFileChooser(lastFile) : (!new File("./log/downloaded/").canRead() ? new JFileChooser(ConfigFetch.getConfigFile()) : new JFileChooser(new File("./log/downloaded/")));
                fileChooser.setFileView(new NeptusFileView());
                fileChooser.setFileFilter(GuiUtils.getCustomFileFilter(I18n.text("LSF log files"), "lsf", "lsf.gz", "lsf.bz2"));
                if (fileChooser.showOpenDialog(MRAMenuBar.this.mra) == 0) {
                    final File log = fileChooser.getSelectedFile();
                    LogUtils.LogValidity validity = LogUtils.isValidLSFSource(log.getParentFile());
                    if (validity != LogUtils.LogValidity.VALID) {
                        String message = null;
                        if (validity == LogUtils.LogValidity.NO_DIRECTORY) {
                            message = "No such directory / No read permissions";
                        }
                        if (validity == LogUtils.LogValidity.NO_VALID_LOG_FILE) {
                            message = "No valid LSF log file present";
                        }
                        if (validity == LogUtils.LogValidity.NO_XML_DEFS) {
                            message = "No valid XML definition present";
                        }
                        GuiUtils.errorMessage(MRAMenuBar.this.mra, I18n.text("Open LSF log"), I18n.text(message));
                        return;
                    }
                    new Thread("Open Log"){

                        @Override
                        public void run() {
                            MRAMenuBar.this.mra.getMraFilesHandler().openLog(log);
                        }
                    }.start();
                }
            }
        };
        this.openLsf.putValue("ShortDescription", I18n.text("Choose and Open a Lsf log") + ".");
        this.exit = new AbstractAction(I18n.text("Exit"), ImageUtils.getIcon("images/menus/exit.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MRAMenuBar.this.mra.getMraPanel() != null) {
                    MRAMenuBar.this.mra.getMraPanel().cleanup();
                }
                MRAMenuBar.this.mra.setVisible(false);
                MRAMenuBar.this.mra.dispose();
            }
        };
        this.exit.putValue("ShortDescription", I18n.text("Exit MRA") + ".");
        this.fileMenu.add(this.openLsf);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exit);
    }

    public JMenu getRecentlyOpenFilesMenu() {
        if (this.recentlyOpenFilesMenu == null) {
            this.recentlyOpenFilesMenu = new JMenu();
            this.recentlyOpenFilesMenu.setText(I18n.text("Recently opened"));
            this.recentlyOpenFilesMenu.setToolTipText("Most recently opened log files.");
            this.recentlyOpenFilesMenu.setIcon(ImageUtils.getIcon("images/menus/open.png"));
            RecentlyOpenedFilesUtil.constructRecentlyFilesMenuItems(this.recentlyOpenFilesMenu, this.miscFilesOpened);
        } else {
            RecentlyOpenedFilesUtil.constructRecentlyFilesMenuItems(this.recentlyOpenFilesMenu, this.miscFilesOpened);
        }
        return this.recentlyOpenFilesMenu;
    }

    private void setUpReportMenu() {
        this.reportMenu = new JMenu(I18n.text("Report"));
        this.reportOptions = new AbstractAction(I18n.text("PDF Report Options"), ImageUtils.getIcon("images/menus/settings.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)MRAMenuBar.this.mra.getReportProperties(), MRAMenuBar.this.mra, true);
                try {
                    PluginUtils.saveProperties("conf/report.properties", MRAMenuBar.this.mra.getReportProperties());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.genReport = new AbstractAction(I18n.text("Save as PDF"), ImageUtils.getIcon("images/menus/document-pdf.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int resp;
                File f = new File(MRAMenuBar.this.mra.getMraPanel().getSource().getDir().toString() + "/" + MRAMenuBar.this.mra.getMraPanel().getSource().name() + " - " + System.currentTimeMillis() + ".pdf");
                if (f.exists() && (resp = JOptionPane.showConfirmDialog(MRAMenuBar.this.mra, I18n.text("Do you want to overwrite the existing file?"))) != 0) {
                    return;
                }
                MRAMenuBar.this.mra.getMraFilesHandler().generatePDFReport(f);
            }
        };
        this.genReport.putValue("ShortDescription", I18n.text("Generate a pdf file report from Log") + ".");
        this.reportMenu.add(this.genReport);
        this.genReport.setEnabled(false);
        this.batchReport = new AbstractAction(I18n.text("Batch PDF report"), ImageUtils.getIcon("images/menus/document-pdf.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(new File("."));
                chooser.setFileSelectionMode(1);
                int res = chooser.showOpenDialog(MRAMenuBar.this.mra);
                if (res != 0) {
                    return;
                }
                final File f = chooser.getSelectedFile();
                final WaitPanel panel = new WaitPanel();
                panel.start((JFrame)MRAMenuBar.this.mra, Dialog.ModalityType.DOCUMENT_MODAL);
                AsyncTask task = new AsyncTask(){

                    public void finish() {
                        panel.stop();
                        GuiUtils.infoMessage(MRAMenuBar.this.mra, I18n.text("Batch report ended successfully"), I18n.text("Files saved to") + " " + new File(".").getAbsolutePath());
                    }

                    public Object run() throws Exception {
                        LsfReport.generateLogs(f, MRAMenuBar.this.mra.getMraPanel());
                        return null;
                    }
                };
                AsyncWorker.post((AsyncTask)task);
            }
        };
        this.batchReport.putValue("ShortDescription", I18n.text("Generate report from selected log files") + ".");
        this.reportMenu.add(this.batchReport);
        this.reportMenu.addSeparator();
        this.reportMenu.add(this.reportOptions);
        this.genReportCustomOptions = new AbstractAction(I18n.text("Save as PDF with custom settings"), ImageUtils.getIcon("images/menus/document-pdf.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int resp;
                PropertiesEditor.editProperties((PropertiesProvider)MRAMenuBar.this.mra.getReportProperties(), MRAMenuBar.this.mra, true);
                try {
                    PluginUtils.saveProperties("conf/report.properties", MRAMenuBar.this.mra.getReportProperties());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                File f = new File(MRAMenuBar.this.mra.getMraPanel().getSource().getDir().toString() + "/" + MRAMenuBar.this.mra.getMraPanel().getSource().name() + " - " + System.currentTimeMillis() + ".pdf");
                if (f.exists() && (resp = JOptionPane.showConfirmDialog(MRAMenuBar.this.mra, I18n.text("Do you want to overwrite the existing file?"))) != 0) {
                    return;
                }
                MRAMenuBar.this.mra.getMraFilesHandler().generatePDFReport(f);
            }
        };
        this.genReportCustomOptions.putValue("ShortDescription", I18n.text("Generate a pdf file report from Log with custom options") + ".");
        this.reportMenu.add(this.genReportCustomOptions);
        this.genReportCustomOptions.setEnabled(false);
    }

    private void setUpSettingsMenu() {
        this.settingsMenu = new JMenu(I18n.text("Settings"));
        this.setMission = new AbstractAction(I18n.text("Set mission"), ImageUtils.getIcon("images/menus/mapeditor.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = MissionFileChooser.showOpenMissionDialog(new String[]{"nmis", "nmisz"});
                if (f != null) {
                    MissionType mission = new MissionType(f.getAbsolutePath());
                    if (MRAMenuBar.this.mra.getMraPanel() != null) {
                        MRAMenuBar.this.mra.getMraPanel().warnChangeListeners(mission);
                    }
                }
            }
        };
        this.setMission.putValue("ShortDescription", I18n.text("Load a mission file to add relevant marks to log analysis") + ".");
        this.setMission.setEnabled(false);
        this.preferences = new AbstractAction(I18n.text("Preferences"), ImageUtils.getScaledIcon("images/settings.png", 16, 16)){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PropertiesEditor.editProperties((PropertiesProvider)MRAMenuBar.this.mra.getMraProperties(), MRAMenuBar.this.mra, true)) {
                    try {
                        NeptusLog.pub().info((Object)"Saving MRA configuration to disk");
                        MRAMenuBar.this.mra.getMraProperties().save();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        this.preferences.putValue("ShortDescription", I18n.text("Configure MRA preferences") + ".");
        this.settingsMenu.add(this.setMission);
        this.settingsMenu.addSeparator();
        this.settingsMenu.add(this.preferences);
    }

    private void setUpToolsMenu() {
        this.toolsMenu = new JMenu(I18n.text("Tools"));
        try {
            this.httpVehicleDownload = new AbstractAction(I18n.text("Choose an active vehicle to download logs (FTP)"), ImageUtils.getScaledIcon("images/buttons/web.png", 16, 16)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final LinkedHashSet<ImcSystem> selectedVehicle = new LinkedHashSet<ImcSystem>();
                    JPanel panel = new JPanel();
                    panel.setLayout(new BorderLayout());
                    JList logsList = new JList();
                    DefaultListModel<ImcSystem> listModel = new DefaultListModel<ImcSystem>();
                    LinkedHashMap sysList = ImcMsgManager.getManager().getCommInfo();
                    for (ImcId16 system : sysList.keySet()) {
                        ImcSystem sys3 = ImcSystemsHolder.lookupSystem(system);
                        try {
                            if (sys3.getType() != VehicleType.SystemTypeEnum.VEHICLE) continue;
                            listModel.addElement(sys3);
                        }
                        catch (Exception e1) {
                            NeptusLog.pub().info((Object)("<###> " + system + " " + I18n.text("not selectable")));
                        }
                    }
                    final JList lis = logsList = new JList(listModel);
                    lis.setSelectionMode(0);
                    JScrollPane listScrollPane = new JScrollPane(logsList);
                    panel.add((Component)listScrollPane, "Center");
                    if (listModel.size() == 1) {
                        selectedVehicle.add((ImcSystem)listModel.get(0));
                    } else {
                        final JDialog dialog = new JDialog(MRAMenuBar.this.mra);
                        JButton but = new JButton(new AbstractAction(I18n.text("Select Vehicle")){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                List l = lis.getSelectedValuesList();
                                for (ImcSystem f : l) {
                                    selectedVehicle.add(f);
                                }
                                dialog.setVisible(false);
                                dialog.dispose();
                            }
                        });
                        panel.add((Component)but, "South");
                        dialog.add(panel);
                        dialog.setSize(300, 300);
                        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                        dialog.setLocationRelativeTo(MRAMenuBar.this.mra);
                        dialog.setVisible(true);
                    }
                    if (selectedVehicle.size() == 1) {
                        ImcSystem sys = (ImcSystem)selectedVehicle.iterator().next();
                        LogsDownloaderWorker logFetcher = new LogsDownloaderWorker();
                        logFetcher.setHost(sys.getHostAddress());
                        logFetcher.setLogLabel(sys.getName().toLowerCase());
                        Vector<URI> sUri = sys.getServiceProvided("ftp", "");
                        if (sUri.size() > 0) {
                            logFetcher.setHost(sUri.get(0).getHost());
                            logFetcher.setPort(sUri.get(0).getPort() <= 0 ? 21 : sUri.get(0).getPort());
                        }
                        logFetcher.setEnableHost(false);
                        logFetcher.setEnablePort(false);
                        logFetcher.setEnableLogLabel(false);
                        logFetcher.setVisible(true);
                    }
                }
            };
            this.httpVehicleDownload.setEnabled(true);
        }
        catch (Error e) {
            e.printStackTrace();
        }
        this.httpVehicleDownload.putValue("ShortDescription", I18n.text("Choose an active vehicle to download logs (FTP)") + ".");
        this.httpDuneDownload = new AbstractAction(I18n.text("Download logs from location (FTP)"), ImageUtils.getScaledIcon("images/buttons/web.png", 16, 16)){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogsDownloaderWorker logFetcher = new LogsDownloaderWorker();
                logFetcher.setConfigPanelVisible(true);
                logFetcher.setEnableLogLabel(true);
                logFetcher.setVisible(true);
            }
        };
        this.httpDuneDownload.setEnabled(true);
        this.httpDuneDownload.putValue("ShortDescription", I18n.text("Download logs from location") + ".");
        this.concatenateLSFLogs = new AbstractAction(I18n.text("Concatenate LSF logs"), ImageUtils.getIcon("images/menus/cat.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                File[] folders = ConcatenateLsfLog.chooseFolders(MRAMenuBar.this.mra, new File(".").getAbsolutePath());
                if (folders != null) {
                    JFileChooser chooser = new JFileChooser(new File("."));
                    chooser.setDialogTitle(I18n.text("Select folder where to save concatenated log"));
                    chooser.setFileSelectionMode(1);
                    int op = chooser.showOpenDialog(MRAMenuBar.this.mra);
                    if (op == 0) {
                        try {
                            ConcatenateLsfLog.concatenateFolders(folders, chooser.getSelectedFile(), null);
                            MRAMenuBar.this.mra.getMraFilesHandler().openLog(new File(chooser.getSelectedFile(), "Data.lsf"));
                        }
                        catch (Exception ex) {
                            GuiUtils.errorMessage(MRAMenuBar.this.mra, ex);
                        }
                    }
                }
            }
        };
        this.concatenateLSFLogs.putValue("ShortDescription", I18n.text("Concatenate LSF logs") + ".");
        this.fuseLSFLogs = new AbstractAction(I18n.text("Fuse LSF logs"), ImageUtils.getIcon("images/menus/merge.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                File[] folders = ConcatenateLsfLog.chooseFolders(MRAMenuBar.this.mra, new File(".").getAbsolutePath());
                if (folders != null) {
                    JFileChooser chooser = new JFileChooser(new File("."));
                    chooser.setDialogTitle(I18n.text("Select folder where to save concatenated log"));
                    chooser.setFileSelectionMode(1);
                    int op = chooser.showOpenDialog(MRAMenuBar.this.mra);
                    if (op == 0) {
                        try {
                            ConcatenateLsfLog.concatenateFolders(folders, chooser.getSelectedFile(), null);
                            MRAMenuBar.this.mra.getMraFilesHandler().openLog(new File(chooser.getSelectedFile(), "Data.lsf"));
                        }
                        catch (Exception ex) {
                            GuiUtils.errorMessage(MRAMenuBar.this.mra, ex);
                        }
                    }
                }
            }
        };
        this.fuseLSFLogs.putValue("ShortDescription", I18n.text("Fuse LSF logs") + ".");
        this.toolsMenu.add(this.httpVehicleDownload);
        this.toolsMenu.add(this.httpDuneDownload);
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(this.concatenateLSFLogs);
        this.toolsMenu.add(this.fuseLSFLogs);
    }

    private void setUpHelpMenu() {
        this.helpMenu = new JMenu(I18n.text("Help"));
        JMenuItem aboutMenuItem = new JMenuItem();
        aboutMenuItem.setText(I18n.text("About"));
        aboutMenuItem.setIcon(ImageUtils.getIcon("images/menus/info.png"));
        aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutPanel ap = new AboutPanel();
                ap.setVisible(true);
            }
        });
        this.helpMenu.add(aboutMenuItem);
    }

    public void setUpExportersMenu(final IMraLogGroup source) {
        LinkedHashMap<String, Class<MRAExporter>> exporterMap = PluginsRepository.listExtensions(MRAExporter.class);
        Vector<MRAExporter> exporterList = new Vector<MRAExporter>();
        for (Class<MRAExporter> clazz : exporterMap.values()) {
            try {
                exporterList.add(clazz.getConstructor(IMraLogGroup.class).newInstance(source));
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        if (this.getExportersMenu() != null) {
            this.toolsMenu.remove(this.getExportersMenu());
        }
        this.setExportersMenu(new JMenu(I18n.text("Exporters")));
        this.getExportersMenu().setIcon(ImageUtils.getIcon("images/menus/export.png"));
        this.getExportersMenu().setToolTipText(I18n.text("Export data to") + "...");
        for (final MRAExporter exp : exporterList) {
            if (!exp.canBeApplied(source)) continue;
            JMenuItem item = new JMenuItem(new AbstractAction(exp.getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread t = new Thread(exp.getName() + " processing"){

                        @Override
                        public void run() {
                            ProgressMonitor monitor = new ProgressMonitor(MRAMenuBar.this.mra.getMraPanel(), exp.getName(), "", 0, 100);
                            String res = exp.process(source, monitor);
                            if (res != null) {
                                GuiUtils.infoMessage(MRAMenuBar.this.mra.getMraPanel(), exp.getName(), res);
                            }
                            monitor.close();
                        }
                    };
                    t.setDaemon(true);
                    t.start();
                }
            });
            item.setIcon(ImageUtils.getIcon("images/menus/export.png"));
            this.getExportersMenu().add(item);
        }
        if (this.getExportersMenu().getItemCount() > 0) {
            if (!this.isExportersAdded) {
                this.toolsMenu.addSeparator();
                this.isExportersAdded = true;
            }
            this.toolsMenu.add(this.getExportersMenu());
        }
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    private void setMenuBar(JMenuBar menuBar) {
        this.menuBar = menuBar;
    }

    public AbstractAction getSetMissionMenuItem() {
        return this.setMission;
    }

    public AbstractAction getGenReportMenuItem() {
        return this.genReport;
    }

    public JMenu getReportMenuItem() {
        return this.reportMenu;
    }

    public AbstractAction getGenReportCustomOptionsMenuItem() {
        return this.genReportCustomOptions;
    }

    public AbstractAction getReportOptionsMenuItem() {
        return this.reportOptions;
    }

    private JMenu getExportersMenu() {
        return this.exporters;
    }

    private void setExportersMenu(JMenu exportersMenu) {
        this.exporters = exportersMenu;
    }
}

