/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXStatusBar;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.gui.InfiniteProgressPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAProperties;
import pt.lsts.neptus.mra.NeptusMRA;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.LogMarkerListener;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.PluginsRepository;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.llf.LogTree;
import pt.lsts.neptus.util.llf.LogUtils;
import pt.lsts.neptus.util.llf.LsfReportProperties;
import pt.lsts.neptus.util.llf.LsfTree;
import pt.lsts.neptus.util.llf.LsfTreeMouseAdapter;
import pt.lsts.neptus.util.llf.chart.MRAChartFactory;

public class MRAPanel
extends JPanel {
    private LsfTree tree;
    private LogTree logTree;
    private IMraLogGroup source = null;
    private final JXStatusBar statusBar = new JXStatusBar();
    private final JPanel leftPanel = new JPanel((LayoutManager)new MigLayout("ins 0"));
    private final JPanel mainPanel = new JPanel((LayoutManager)new MigLayout());
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private JScrollPane jspMessageTree;
    private JScrollPane jspLogTree;
    private final LinkedHashMap<String, MRAVisualization> visualizationList = new LinkedHashMap();
    private final LinkedHashMap<String, Component> openVisualizationList = new LinkedHashMap();
    private final ArrayList<String> loadingVisualizations = new ArrayList();
    private final ArrayList<LogMarker> logMarkers = new ArrayList();
    private MRAVisualization shownViz = null;
    private Vector<MissionChangeListener> mcl = new Vector();
    private NeptusMRA mra;
    InfiniteProgressPanel loader = InfiniteProgressPanel.createInfinitePanelBeans("");

    public MRAPanel(IMraLogGroup source, NeptusMRA mra) {
        this.source = source;
        this.mra = mra;
        if (new File("conf/tides.txt").canRead() && source.getFile("tides.txt") == null) {
            FileUtil.copyFile("conf/tides.txt", new File(source.getFile("."), "tides.txt").getAbsolutePath());
        }
        this.setLayout(new BorderLayout(3, 3));
        mra.getBgp().setText(I18n.text("Starting up left panel..."));
        this.setUpLeftPanel();
        mra.getBgp().setText(I18n.text("Starting up status bar..."));
        this.setUpStatusBar();
        mra.getBgp().setText(I18n.text("Starting up main panel..."));
        this.setUpMainPanel();
        JSplitPane splitPane = new JSplitPane();
        splitPane.setLeftComponent(this.leftPanel);
        splitPane.setRightComponent(this.mainPanel);
        splitPane.setDividerLocation(250);
        splitPane.setResizeWeight(0.0);
        this.add((Component)splitPane, "Center");
        this.add((Component)this.statusBar, "South");
        mra.getBgp().setText(I18n.text("Loading markers..."));
        this.loadMarkers();
        mra.getMRAMenuBar().setUpExportersMenu(source);
    }

    private void setUpLeftPanel() {
        this.tree = new LsfTree(this.source);
        this.logTree = new LogTree(this.source, this);
        this.jspMessageTree = new JScrollPane(this.tree);
        this.jspLogTree = new JScrollPane(this.logTree);
        this.tabbedPane.addTab(I18n.text("Visualizations"), this.jspLogTree);
        this.tabbedPane.addTab(I18n.text("Messages"), this.jspMessageTree);
        this.leftPanel.add((Component)this.tabbedPane, "wrap, w 100%, h 100%");
        for (int i = 0; i < this.logTree.getRowCount(); ++i) {
            this.logTree.expandRow(i);
        }
        this.tree.addMouseListener(new LsfTreeMouseAdapter(this));
    }

    private void setUpStatusBar() {
        VehicleType veh = LogUtils.getVehicle(this.source);
        Date startDate = LogUtils.getStartDate(this.source);
        String date = startDate != null ? " | <b>" + I18n.text("Date") + ":</b> " + new SimpleDateFormat("dd/MMM/yyyy").format(startDate) : "";
        this.statusBar.add((Component)new JLabel("<html><b>" + I18n.text("Log") + ":</b> " + this.source.name() + date + (veh != null ? " | <b>" + I18n.text("System") + ":</b> " + veh.getName() : "")));
    }

    public void addStatusBarMsg(String msg) {
        JLabel jlabel = new JLabel(msg);
        this.statusBar.add((Component)jlabel);
        this.updateUI();
    }

    public void reDrawStatusBar() {
        this.statusBar.removeAll();
        this.remove((Component)this.statusBar);
        this.setUpStatusBar();
        this.add((Component)this.statusBar, "South");
        this.updateUI();
    }

    private void setUpMainPanel() {
        Vector<MRAVisualization> visualizations = new Vector<MRAVisualization>();
        for (String visName : PluginsRepository.getMraVisualizations().keySet()) {
            try {
                Class<? extends MRAVisualization> vis = PluginsRepository.getMraVisualizations().get(visName);
                if (!this.mra.getMraProperties().isVisualizationActive(vis)) continue;
                MRAVisualization visualization = vis.getDeclaredConstructor(MRAPanel.class).newInstance(this);
                PluginUtils.loadProperties(visualization, "mra");
                if (visualization.canBeApplied(this.source)) {
                    visualizations.add(visualization);
                }
                if (!(visualization instanceof MissionChangeListener)) continue;
                this.addMissionChangeListener((MissionChangeListener)((Object)visualization));
            }
            catch (Exception e1) {
                NeptusLog.pub().error((Object)(I18n.text("MRA Visualization not loading properly") + ": " + visName + "  [" + e1.getMessage() + "]"));
            }
            catch (Error e2) {
                NeptusLog.pub().error((Object)(I18n.text("MRA Visualization not loading properly") + ": " + visName + "  [" + e2.getMessage() + "]"));
            }
        }
        visualizations.addAll(MRAChartFactory.getScriptedPlots(this));
        Collections.sort(visualizations, new Comparator<MRAVisualization>(){

            @Override
            public int compare(MRAVisualization o1, MRAVisualization o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (MRAVisualization viz : visualizations) {
            try {
                this.loadVisualization(viz, false);
            }
            catch (Exception e1) {
                NeptusLog.pub().error((Object)(I18n.text("MRA Visualization not loading properly") + ": " + viz.getName() + "  [" + e1.getMessage() + "]"));
            }
            catch (Error e2) {
                NeptusLog.pub().error((Object)(I18n.text("MRA Visualization not loading properly") + ": " + viz.getName() + "  [" + e2.getMessage() + "]"));
            }
        }
    }

    public void loadVisualization(MRAVisualization vis, boolean open) {
        if (!this.visualizationList.keySet().contains(vis.getName())) {
            ImageIcon icon = vis.getIcon();
            if (icon == null) {
                icon = ImageUtils.getIcon("images/menus/graph.png");
            }
            this.visualizationList.put(vis.getName(), vis);
            this.logTree.addVisualization(vis);
            if (open) {
                this.openVisualization(vis);
            }
        } else if (open) {
            this.openVisualization(vis);
        }
    }

    public void openVisualization(MRAVisualization viz) {
        new Thread((Runnable)new LoadTask(viz), "Open viz " + viz.getName()).start();
    }

    public void cleanup() {
        NeptusLog.pub().info((Object)"MRA Cleanup");
        this.tree.removeAll();
        this.tree = null;
        this.mcl.clear();
        this.logTree.removeAll();
        this.logTree = null;
        for (MRAVisualization vis : this.visualizationList.values()) {
            vis.onCleanup();
            Object var2_2 = null;
        }
        this.openVisualizationList.clear();
        this.saveMarkers();
        this.source.cleanup();
        this.source = null;
    }

    public void removeTreeObject(Object obj) {
        this.logTree.remove(obj);
    }

    public void synchVisualizations(LogMarker marker) {
        for (MRAVisualization v : this.visualizationList.values()) {
            if (!(v instanceof LogMarkerListener)) continue;
            ((LogMarkerListener)((Object)v)).GotoMarker(marker);
        }
    }

    public boolean existsMark(LogMarker marker) {
        for (LogMarker m : this.logMarkers) {
            if (!m.getLabel().equals(marker.getLabel())) continue;
            return true;
        }
        return false;
    }

    public void getTimestampsForMarker(LogMarker marker, double distance) {
        LocationType l = marker.getLocation();
        for (IMCMessage state : this.source.getLsfIndex().getIterator("EstimatedState")) {
            LocationType loc = new LocationType(Math.toDegrees(state.getDouble("lat")), Math.toDegrees(state.getDouble("lon")));
            loc.translatePosition(state.getDouble("x"), state.getDouble("y"), 0.0);
            if (!(loc.getDistanceInMeters(l) <= distance)) continue;
            NeptusLog.pub().info((Object)("<###> " + marker.getLabel() + " --- " + state.getTimestampMillis()));
        }
    }

    public void addMarker(LogMarker marker) {
        if (LsfReportProperties.generatingReport) {
            return;
        }
        if (this.existsMark(marker)) {
            return;
        }
        if (marker.getLat() == 0.0 && marker.getLon() == 0.0) {
            IMCMessage m = this.source.getLog("EstimatedState").getEntryAtOrAfter(new Double(marker.getTimestamp()).longValue());
            LocationType loc = LogUtils.getLocation(m);
            marker.setLat(loc.getLatitudeRads());
            marker.setLon(loc.getLongitudeRads());
        }
        this.logTree.addMarker(marker);
        this.logMarkers.add(marker);
        for (MRAVisualization vis : this.visualizationList.values()) {
            if (!(vis instanceof LogMarkerListener)) continue;
            try {
                ((LogMarkerListener)((Object)vis)).addLogMarker(marker);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("Error adding marker on " + vis.getName()), (Throwable)e);
            }
        }
        this.saveMarkers();
    }

    public void removeMarker(LogMarker marker) {
        if (LsfReportProperties.generatingReport) {
            GuiUtils.infoMessage(this.getRootPane(), I18n.text("Can not remove Marks"), I18n.text("Can not remove Marks - Generating Report."));
            return;
        }
        this.logTree.removeMarker(marker);
        this.logMarkers.remove(marker);
        for (MRAVisualization vis : this.visualizationList.values()) {
            if (!(vis instanceof LogMarkerListener)) continue;
            try {
                ((LogMarkerListener)((Object)vis)).removeLogMarker(marker);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
    }

    public void loadMarkers() {
        this.logMarkers.clear();
        this.logMarkers.addAll(LogMarker.load(this.source));
        Collections.sort(this.logMarkers);
        for (LogMarker lm : this.logMarkers) {
            this.logTree.addMarker(lm);
        }
    }

    public void saveMarkers() {
        LogMarker.save(this.logMarkers, this.source);
    }

    public LsfTree getTree() {
        return this.tree;
    }

    public final LogTree getLogTree() {
        return this.logTree;
    }

    public final IMraLogGroup getSource() {
        return this.source;
    }

    public ArrayList<LogMarker> getMarkers() {
        return this.logMarkers;
    }

    public InfiniteProgressPanel getLoader() {
        return this.loader;
    }

    public void addMissionChangeListener(MissionChangeListener l) {
        if (!this.mcl.contains(l)) {
            this.mcl.add(l);
        }
    }

    public void warnChangeListeners(MissionType newMission) {
        for (MissionChangeListener m : this.mcl) {
            m.missionReplaced(newMission);
        }
    }

    class LoadTask
    implements Runnable {
        MRAVisualization vis;

        public LoadTask(MRAVisualization vis) {
            this.vis = vis;
        }

        @Override
        public void run() {
            Component c;
            if (MRAPanel.this.openVisualizationList.containsKey(this.vis.getName())) {
                c = (Component)MRAPanel.this.openVisualizationList.get(this.vis.getName());
            } else if (MRAPanel.this.loadingVisualizations.contains(this.vis.getName())) {
                MRAPanel.this.loader.setText(I18n.textf("Loading %visName", this.vis.getName()));
                MRAPanel.this.loader.start();
                c = MRAPanel.this.loader;
            } else {
                MRAPanel.this.loadingVisualizations.add(this.vis.getName());
                MRAPanel.this.mainPanel.removeAll();
                MRAPanel.this.mainPanel.repaint();
                MRAPanel.this.mainPanel.add((Component)MRAPanel.this.loader, "w 100%, h 100%");
                MRAPanel.this.loader.setText(I18n.textf("Loading %visName", this.vis.getName()));
                MRAPanel.this.loader.start();
                c = this.vis.getComponent(MRAPanel.this.source, MRAProperties.defaultTimestep);
                MRAPanel.this.openVisualizationList.put(this.vis.getName(), c);
                if (this.vis instanceof LogMarkerListener) {
                    for (LogMarker marker : MRAPanel.this.logMarkers) {
                        ((LogMarkerListener)((Object)this.vis)).addLogMarker(marker);
                    }
                }
                MRAPanel.this.loader.stop();
                MRAPanel.this.loadingVisualizations.remove(this.vis.getName());
            }
            if (MRAPanel.this.shownViz != null) {
                MRAPanel.this.shownViz.onHide();
            }
            MRAPanel.this.shownViz = this.vis;
            this.vis.onShow();
            MRAPanel.this.mainPanel.removeAll();
            MRAPanel.this.mainPanel.add(c, "w 100%, h 100%");
            MRAPanel.this.mainPanel.revalidate();
            MRAPanel.this.mainPanel.repaint();
        }
    }
}

