/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.BlockingGlassPane;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.loader.NeptusMain;
import pt.lsts.neptus.mra.MRAFilesHandler;
import pt.lsts.neptus.mra.MRAMenuBar;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.MRAProperties;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.llf.LsfReportProperties;

public class NeptusMRA
extends JFrame {
    private static final String MRA_TITLE = I18n.text("Neptus Mission Review And Analysis");
    private MRAProperties mraProperties = new MRAProperties();
    private LsfReportProperties reportProperties = new LsfReportProperties();
    private MRAPanel mraPanel = null;
    private BlockingGlassPane bgp = new BlockingGlassPane(400, true);
    private MRAMenuBar mraMenuBar;
    private MRAFilesHandler mraFilesHandler;
    public static boolean vtkEnabled = true;

    public NeptusMRA() {
        super(MRA_TITLE);
        try {
            PluginUtils.loadProperties("conf/mra.properties", (Object)this.getMraProperties());
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(I18n.text("Not possible to open") + " \"conf/mra.properties\""));
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.setSize(1200, 700);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(ConfigFetch.class.getResource("/images/neptus-icon.png")));
        GuiUtils.centerOnScreen(this);
        this.mraMenuBar = new MRAMenuBar(this);
        this.setMraFilesHandler(new MRAFilesHandler(this));
        this.mraMenuBar.createMRAMenuBar();
        this.setJMenuBar(this.mraMenuBar.getMenuBar());
        this.setVisible(true);
        JLabel lbl = new JLabel(MRA_TITLE, 0);
        lbl.setOpaque(false);
        lbl.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        lbl.setFont(new Font("Helvetica", 2, 32));
        lbl.setVerticalTextPosition(3);
        lbl.setHorizontalTextPosition(0);
        lbl.setForeground(new Color(80, 120, 175));
        lbl.revalidate();
        this.getContentPane().add(lbl);
        this.addWindowListener(new WindowAdapter(){
            boolean closed = false;

            @Override
            public void windowActivated(WindowEvent e) {
                super.windowActivated(e);
                ConfigFetch.setSuperParentFrameForced(NeptusMRA.this);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                NeptusMRA.this.setVisible(false);
                if (NeptusMRA.this.getMraPanel() != null) {
                    NeptusMRA.this.getMraPanel().cleanup();
                }
                NeptusMRA.this.setMraPanel(null);
                NeptusMRA.this.getMraFilesHandler().abortPendingOpenLogActions();
                NeptusMRA.this.getContentPane().removeAll();
                NeptusMRA.this.dispose();
                ConfigFetch.setSuperParentFrameForced(null);
            }
        });
        this.setGlassPane(this.getBgp());
    }

    public static NeptusMRA showApplication() {
        ConfigFetch.initialize();
        GuiUtils.setLookAndFeel();
        return new NeptusMRA();
    }

    public void openLog(String logPath) {
        File logFile = new File(logPath);
        if (logFile.exists()) {
            this.getMraFilesHandler().openLog(logFile);
        }
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this.mraMenuBar.getMenuBar();
    }

    public MRAMenuBar getMRAMenuBar() {
        return this.mraMenuBar;
    }

    protected MRAPanel getMraPanel() {
        return this.mraPanel;
    }

    protected void setMraPanel(MRAPanel mraPanel) {
        this.mraPanel = mraPanel;
    }

    protected BlockingGlassPane getBgp() {
        return this.bgp;
    }

    public MRAProperties getMraProperties() {
        return this.mraProperties;
    }

    protected void setMraProperties(MRAProperties mraProperties) {
        this.mraProperties = mraProperties;
    }

    protected LsfReportProperties getReportProperties() {
        return this.reportProperties;
    }

    protected void setReportProperties(LsfReportProperties reportProperties) {
        this.reportProperties = reportProperties;
    }

    public MRAFilesHandler getMraFilesHandler() {
        return this.mraFilesHandler;
    }

    public void setMraFilesHandler(MRAFilesHandler mraFilesHandler) {
        this.mraFilesHandler = mraFilesHandler;
    }

    public static void main(String[] args) {
        NeptusMain.main(new String[]{"mra"});
    }
}

