/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapUtils;
import pt.lsts.neptus.colormap.DataDiscretizer;
import pt.lsts.neptus.types.coord.LocationType;

public class WorldImage {
    private DataDiscretizer dd;
    private ColorMap cmap;
    private LocationType sw = null;
    private LocationType ne = null;
    private LocationType ref = null;
    private int defaultWidth = 1024;
    private int defaultHeight = 768;
    private Double minVal = null;
    private Double maxVal = null;

    public final void setMinVal(Double minVal) {
        this.minVal = minVal;
    }

    public final void setMaxVal(Double maxVal) {
        this.maxVal = maxVal;
    }

    public WorldImage(int cellWidth, ColorMap cmap) {
        this.cmap = cmap;
        this.dd = new DataDiscretizer(cellWidth);
    }

    public void addPoint(LocationType loc, double value) {
        if (this.ref == null) {
            this.ref = new LocationType(loc);
        }
        double[] offsets = loc.getOffsetFrom(this.ref);
        this.dd.addPoint(offsets[1], -offsets[0], value);
    }

    public LocationType getSouthWest() {
        return this.sw;
    }

    public LocationType getNorthEast() {
        return this.ne;
    }

    public BufferedImage processData() {
        double maxX = this.dd.maxX + 5.0;
        double minX = this.dd.minX - 5.0;
        double dx = maxX - minX;
        double maxY = this.dd.maxY + 5.0;
        double minY = this.dd.minY - 5.0;
        double dy = maxY - minY;
        double ratio2 = dx / dy;
        double ratio1 = (double)this.defaultWidth / (double)this.defaultHeight;
        if (ratio2 < ratio1) {
            dx = dy * ratio1;
        } else {
            dy = dx / ratio1;
        }
        double cx = (maxX + minX) / 2.0;
        double cy = (maxY + minY) / 2.0;
        Rectangle2D.Double bounds = new Rectangle2D.Double(cx - dx / 2.0, cy - dy / 2.0, dx, dy);
        BufferedImage img = new BufferedImage(this.defaultWidth, this.defaultHeight, 2);
        try {
            double max = this.maxVal == null ? this.dd.maxVal[0] * 1.005 : this.maxVal;
            double min = this.minVal == null ? this.dd.minVal[0] * 0.995 : this.minVal;
            ColorMapUtils.generateInterpolatedColorMap((Rectangle2D)bounds, this.dd.getDataPoints(), 0, img.createGraphics(), (double)img.getWidth(), (double)img.getHeight(), 255, this.cmap, min, max);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        this.ne = new LocationType(this.ref);
        this.ne.translatePosition(-maxY, maxX, 0.0);
        this.sw = new LocationType(this.ref);
        this.sw.translatePosition(-minY, minX, 0.0);
        return img;
    }
}

