/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.api;

import java.io.File;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mra.api.BathymetryParser;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.importers.deltat.DeltaTParser;
import pt.lsts.neptus.mra.importers.lsf.DVLBathymetryParser;

public class BathymetryParserFactory {
    static File dir;
    static File file;
    static IMraLogGroup source;

    public static BathymetryParser build(IMraLogGroup log) {
        file = null;
        dir = log.getDir();
        source = log;
        return BathymetryParserFactory.getParser();
    }

    public static BathymetryParser build(File fileOrDir) {
        source = null;
        if (fileOrDir.isDirectory()) {
            dir = file;
        } else {
            file = fileOrDir;
        }
        return BathymetryParserFactory.getParser();
    }

    public static BathymetryParser build(IMraLogGroup log, String sensorType) {
        file = null;
        dir = log.getDir();
        source = log;
        return BathymetryParserFactory.getParserByType(sensorType);
    }

    private static BathymetryParser getParser() {
        if (file != null) {
            return null;
        }
        if (dir != null) {
            if (new File(dir.getAbsolutePath() + "/data.83P").exists()) {
                return new DeltaTParser(source);
            }
            if (new File(dir.getAbsolutePath() + "/Data.83P").exists()) {
                return new DeltaTParser(source);
            }
            if (new File(dir.getAbsolutePath() + "/multibeam.83P").exists()) {
                return new DeltaTParser(source);
            }
        }
        if (source.getLsfIndex().containsMessagesOfType(new String[]{"Distance"})) {
            return new DVLBathymetryParser(source);
        }
        return null;
    }

    private static BathymetryParser getParserByType(String sensorType) {
        if (dir != null) {
            if (sensorType.equals("dvl")) {
                if (source.getLsfIndex().containsMessagesOfType(new String[]{"Distance"})) {
                    return new DVLBathymetryParser(source);
                }
                return null;
            }
            if (sensorType.equals("multibeam")) {
                if (dir != null) {
                    if (new File(dir.getAbsolutePath() + "/data.83P").exists()) {
                        return new DeltaTParser(source);
                    }
                    if (new File(dir.getAbsolutePath() + "/Data.83P").exists()) {
                        return new DeltaTParser(source);
                    }
                    if (new File(dir.getAbsolutePath() + "/multibeam.83P").exists()) {
                        return new DeltaTParser(source);
                    }
                }
            } else {
                NeptusLog.pub().error((Object)"Sensor Type is not allowed or isn't supported by Bathymetry Parser");
                return null;
            }
        }
        return null;
    }
}

