/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.lsf.LsfIterator;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.types.coord.LocationType;

public class CorrectedPosition {
    private ArrayList<SystemPositionAndAttitude> positions = new ArrayList();

    public Collection<SystemPositionAndAttitude> getPositions() {
        return Collections.unmodifiableCollection(this.positions);
    }

    public SystemPositionAndAttitude getPosition(double timestamp) {
        if (this.positions.isEmpty()) {
            return null;
        }
        SystemPositionAndAttitude p = new SystemPositionAndAttitude();
        p.setTime((long)timestamp * 1000L);
        int pos = Collections.binarySearch(this.positions, p);
        if (pos < 0) {
            pos = -pos;
        }
        if (pos >= this.positions.size()) {
            return this.positions.get(this.positions.size() - 1);
        }
        return this.positions.get(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CorrectedPosition(IMraLogGroup source) {
        IMraLogGroup iMraLogGroup = source;
        synchronized (iMraLogGroup) {
            File cache = new File(source.getDir(), "mra/positions.cache");
            try {
                if (source.getFile("mra/positions.cache").canRead()) {
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(cache));
                    this.positions = (ArrayList)ois.readObject();
                    ois.close();
                    NeptusLog.pub().info((Object)("Read " + this.positions.size() + " positions from cache file."));
                    return;
                }
            }
            catch (Exception e) {
                NeptusLog.pub().warn((Object)"Positions cache not found. Creating new one.");
            }
            LsfIterator it = source.getLsfIndex().getIterator(EstimatedState.class, 100L);
            Vector<EstimatedState> nonAdjusted = new Vector<EstimatedState>();
            Vector<LocationType> nonAdjustedLocs = new Vector<LocationType>();
            LocationType lastLoc = null;
            double lastTime = 0.0;
            EstimatedState es = (EstimatedState)it.next();
            while (es != null) {
                LocationType thisLoc = new LocationType();
                thisLoc.setLatitudeRads(es.getLat());
                thisLoc.setLongitudeRads(es.getLon());
                if (es.getDepth() > 0.0) {
                    thisLoc.setDepth(es.getDepth());
                }
                if (es.getAlt() > 0.0) {
                    thisLoc.setDepth(-es.getAlt());
                }
                thisLoc.translatePosition(es.getX(), es.getY(), 0.0);
                double speed = Math.sqrt(es.getU() * es.getU() + es.getV() * es.getV() + es.getW() * es.getW());
                thisLoc.convertToAbsoluteLatLonDepth();
                if (lastLoc != null) {
                    double expectedDiff = speed * (es.getTimestamp() - lastTime);
                    lastTime = es.getTimestamp();
                    double diff = lastLoc.getHorizontalDistanceInMeters(thisLoc);
                    if (diff < expectedDiff * 3.0) {
                        nonAdjusted.add(es);
                        nonAdjustedLocs.add(thisLoc);
                    } else if (!nonAdjusted.isEmpty()) {
                        double[] adjustment = thisLoc.getOffsetFrom(lastLoc);
                        EstimatedState firstNonAdjusted = (EstimatedState)nonAdjusted.firstElement();
                        double timeOfAdjustment = es.getTimestamp() - firstNonAdjusted.getTimestamp();
                        double xIncPerSec = adjustment[0] / timeOfAdjustment;
                        double yIncPerSec = adjustment[1] / timeOfAdjustment;
                        for (int i = 0; i < nonAdjusted.size(); ++i) {
                            EstimatedState adj = (EstimatedState)nonAdjusted.get(i);
                            LocationType loc = (LocationType)nonAdjustedLocs.get(i);
                            loc.translatePosition(xIncPerSec * (adj.getTimestamp() - firstNonAdjusted.getTimestamp()), yIncPerSec * (adj.getTimestamp() - firstNonAdjusted.getTimestamp()), 0.0);
                            loc.convertToAbsoluteLatLonDepth();
                            loc.setDepth(adj.getDepth());
                            SystemPositionAndAttitude p = new SystemPositionAndAttitude(adj);
                            p.setPosition(loc);
                            p.setAltitude(adj.getAlt());
                            p.setTime((long)(adj.getTimestamp() * 1000.0));
                            this.positions.add(p);
                        }
                        nonAdjusted.clear();
                        nonAdjustedLocs.clear();
                        nonAdjusted.add(es);
                        nonAdjustedLocs.add(thisLoc);
                    }
                }
                lastLoc = thisLoc;
                lastTime = es.getTimestamp();
                es = (EstimatedState)it.next();
            }
            for (int i = 0; i < nonAdjusted.size(); ++i) {
                EstimatedState adj = (EstimatedState)nonAdjusted.get(i);
                LocationType loc = (LocationType)nonAdjustedLocs.get(i);
                loc.convertToAbsoluteLatLonDepth();
                loc.setDepth(adj.getDepth());
                SystemPositionAndAttitude p = new SystemPositionAndAttitude(adj);
                p.setPosition(loc);
                p.setAltitude(adj.getAlt());
                p.setTime((long)(adj.getTimestamp() * 1000.0));
                this.positions.add(p);
            }
            try {
                ObjectOutputStream ous = new ObjectOutputStream(new FileOutputStream(cache));
                ous.writeObject(this.positions);
                ous.close();
                NeptusLog.pub().info((Object)("Wrote " + this.positions.size() + " positions to cache file."));
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("Error saving positions cache to " + cache));
                e.printStackTrace();
            }
        }
    }

    public static class Position
    implements Comparable<Position> {
        public double lat;
        public double lon;
        public double alt;
        public double depth;
        public double timestamp;

        @Override
        public int compareTo(Position o) {
            return Double.valueOf(this.timestamp).compareTo(o.timestamp);
        }
    }
}

