/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.api;

import java.util.ArrayList;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.SonarData;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mra.api.SidescanLine;
import pt.lsts.neptus.mra.api.SidescanParameters;
import pt.lsts.neptus.mra.api.SidescanParser;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;

public class ImcSidescanParser
implements SidescanParser {
    IMraLog pingParser;
    IMraLog stateParser;
    long firstTimestamp = -1L;
    long lastTimestamp = -1L;
    long lastTimestampRequested;

    public ImcSidescanParser(IMraLogGroup source) {
        this.pingParser = source.getLog("SonarData");
        this.stateParser = source.getLog("EstimatedState");
        this.calcFirstAndLastTimestamps();
    }

    private void calcFirstAndLastTimestamps() {
        IMCMessage msg;
        boolean firstFound = false;
        while ((msg = this.getNextMessage(this.pingParser)) != null) {
            if (!firstFound) {
                firstFound = true;
                this.firstTimestamp = msg.getTimestampMillis();
            }
            this.lastTimestamp = msg.getTimestampMillis();
        }
        this.pingParser.firstLogEntry();
    }

    @Override
    public long firstPingTimestamp() {
        return this.firstTimestamp;
    }

    @Override
    public long lastPingTimestamp() {
        return this.lastTimestamp;
    }

    @Override
    public ArrayList<Integer> getSubsystemList() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(1);
        return l;
    }

    @Override
    public ArrayList<SidescanLine> getLinesBetween(long timestamp1, long timestamp2, int subsystem, SidescanParameters params) {
        IMCMessage ping;
        ArrayList<SidescanLine> list = new ArrayList<SidescanLine>();
        double[] fData = null;
        if (this.lastTimestampRequested > timestamp1) {
            this.pingParser.firstLogEntry();
            this.stateParser.firstLogEntry();
        }
        this.lastTimestampRequested = timestamp1;
        try {
            ping = this.pingParser.getEntryAtOrAfter(timestamp1);
        }
        catch (Exception e) {
            ping = null;
        }
        if (ping == null) {
            return list;
        }
        if ((long)ping.getInteger("type") != SonarData.TYPE.SIDESCAN.value()) {
            ping = this.getNextMessage(this.pingParser);
        }
        IMCMessage state = this.stateParser.getEntryAtOrAfter(ping.getTimestampMillis());
        if (ping == null || state == null) {
            return list;
        }
        int range = ping.getInteger("range");
        if (range == 0) {
            range = ping.getInteger("max_range");
        }
        if (fData == null) {
            // empty if block
        }
        while ((ping == null || ping.getTimestampMillis() <= timestamp2) && ping != null && state != null) {
            fData = new double[ping.getRawData("data").length];
            SystemPositionAndAttitude pose = new SystemPositionAndAttitude();
            pose.setAltitude(state.getDouble("alt"));
            pose.getPosition().setLatitudeRads(state.getDouble("lat"));
            pose.getPosition().setLongitudeRads(state.getDouble("lon"));
            pose.getPosition().setOffsetNorth(state.getDouble("x"));
            pose.getPosition().setOffsetEast(state.getDouble("y"));
            pose.setRoll(state.getDouble("phi"));
            pose.setYaw(state.getDouble("psi"));
            pose.setP(state.getDouble("p"));
            pose.setQ(state.getDouble("q"));
            pose.setR(state.getDouble("r"));
            pose.setU(state.getDouble("u"));
            byte[] data = ping.getRawData("data");
            for (int c = 0; c < data.length; ++c) {
                fData[c] = (double)(data[c] & 0xFF) / 255.0;
            }
            list.add(new SidescanLine(ping.getTimestampMillis(), range, pose, ping.getFloat("frequency"), fData));
            ping = this.getNextMessage(this.pingParser);
            if (ping == null) continue;
            state = this.stateParser.getEntryAtOrAfter(ping.getTimestampMillis());
        }
        return list;
    }

    public long getCurrentTime() {
        return this.pingParser.currentTimeMillis();
    }

    public IMCMessage getNextMessage(IMraLog parser) {
        IMCMessage msg;
        while ((msg = parser.nextLogEntry()) != null) {
            if ((long)msg.getInteger("type") != SonarData.TYPE.SIDESCAN.value()) continue;
            return msg;
        }
        return null;
    }
}

