/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.api;

import java.util.ArrayList;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mra.api.SidescanLine;
import pt.lsts.neptus.mra.api.SidescanParameters;
import pt.lsts.neptus.mra.api.SidescanParser;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;

public class LegacyImcSidescanParser
implements SidescanParser {
    IMraLog pingParser;
    IMraLog stateParser;
    long firstTimestamp = -1L;
    long lastTimestamp = -1L;
    long lastTimestampRequested;

    public LegacyImcSidescanParser(IMraLogGroup source) {
        this.pingParser = source.getLog("SidescanPing");
        this.stateParser = source.getLog("EstimatedState");
    }

    @Override
    public long firstPingTimestamp() {
        if (this.firstTimestamp != -1L) {
            return this.firstTimestamp;
        }
        this.firstTimestamp = this.pingParser.firstLogEntry().getTimestampMillis();
        return this.firstTimestamp;
    }

    @Override
    public long lastPingTimestamp() {
        if (this.lastTimestamp != -1L) {
            return this.lastTimestamp;
        }
        this.lastTimestamp = this.pingParser.getLastEntry().getTimestampMillis();
        this.pingParser.firstLogEntry();
        return this.lastTimestamp;
    }

    @Override
    public ArrayList<Integer> getSubsystemList() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(1);
        return l;
    }

    @Override
    public ArrayList<SidescanLine> getLinesBetween(long timestamp1, long timestamp2, int subsystem, SidescanParameters params) {
        ArrayList<SidescanLine> list = new ArrayList<SidescanLine>();
        double[] fData = null;
        if (this.lastTimestampRequested > timestamp1) {
            this.pingParser.firstLogEntry();
            this.stateParser.firstLogEntry();
        }
        this.lastTimestampRequested = timestamp1;
        IMCMessage ping = this.pingParser.getEntryAtOrAfter(timestamp1);
        if (ping == null) {
            return list;
        }
        IMCMessage state = this.stateParser.getEntryAtOrAfter(ping.getTimestampMillis());
        if (ping == null || state == null) {
            return list;
        }
        int range = ping.getInteger("range");
        while (ping.getTimestampMillis() <= timestamp2 && ping != null && state != null) {
            fData = new double[ping.getRawData("data").length];
            SystemPositionAndAttitude pose = new SystemPositionAndAttitude();
            pose.setAltitude(state.getDouble("alt"));
            pose.getPosition().setLatitudeRads(state.getDouble("lat"));
            pose.getPosition().setLongitudeRads(state.getDouble("lon"));
            pose.getPosition().setOffsetNorth(state.getDouble("x"));
            pose.getPosition().setOffsetEast(state.getDouble("y"));
            pose.setYaw(state.getDouble("psi"));
            pose.setP(state.getDouble("p"));
            pose.setQ(state.getDouble("q"));
            pose.setR(state.getDouble("r"));
            pose.setU(state.getDouble("u"));
            byte[] data = ping.getRawData("data");
            for (int c = 0; c < data.length; ++c) {
                fData[c] = (double)(data[c] & 0xFF) / 255.0;
            }
            list.add(new SidescanLine(ping.getTimestampMillis(), range, pose, ping.getFloat("frequency"), fData));
            ping = this.pingParser.nextLogEntry();
            state = this.stateParser.getEntryAtOrAfter(ping.getTimestampMillis());
        }
        return list;
    }

    public long getCurrentTime() {
        return this.pingParser.currentTimeMillis();
    }
}

