/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.api;

import java.awt.image.BufferedImage;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mra.api.SidescanPoint;
import pt.lsts.neptus.types.coord.LocationType;

public class SidescanLine {
    public long timestampMillis;
    public int xsize;
    public int ysize;
    public int ypos;
    public float range;
    public SystemPositionAndAttitude state;
    public BufferedImage image;
    public double[] data;
    public float frequency;

    public SidescanLine(long timestamp, float range, SystemPositionAndAttitude state, float frequency, double[] data) {
        this.timestampMillis = timestamp;
        this.xsize = data.length;
        this.range = range;
        this.state = state;
        this.data = data;
        this.frequency = frequency;
    }

    public SidescanPoint calcPointForCoord(int x) {
        LocationType location = new LocationType();
        location.setLatitudeStr(this.state.getPosition().getLatitudeStr());
        location.setLongitudeStr(this.state.getPosition().getLongitudeStr());
        double distance = (float)x * (this.range * 2.0f / (float)this.xsize) - this.range;
        double angle = -this.state.getYaw() + (x < this.xsize / 2 ? Math.PI : 0.0);
        double offsetNorth = Math.abs(distance) * Math.sin(angle);
        double offsetEast = Math.abs(distance) * Math.cos(angle);
        location.setOffsetNorth(this.state.getPosition().getOffsetNorth() + offsetNorth);
        location.setOffsetEast(this.state.getPosition().getOffsetEast() + offsetEast);
        return new SidescanPoint(x, this.ypos, this.xsize, (LocationType)location.getNewAbsoluteLatLonDepth());
    }
}

