/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.api;

import java.io.File;
import pt.lsts.neptus.mra.api.ImcSidescanParser;
import pt.lsts.neptus.mra.api.LegacyImcSidescanParser;
import pt.lsts.neptus.mra.api.SidescanParser;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.importers.jsf.JsfSidescanParser;
import pt.lsts.neptus.util.llf.LogUtils;

public class SidescanParserFactory {
    static File dir;
    static File file;
    static IMraLogGroup source;

    public static SidescanParser build(IMraLogGroup log) {
        file = null;
        dir = log.getDir();
        source = log;
        return SidescanParserFactory.getParser();
    }

    public static SidescanParser build(File fileOrDir) {
        source = null;
        if (fileOrDir.isDirectory()) {
            dir = file;
        } else {
            file = fileOrDir;
        }
        return SidescanParserFactory.getParser();
    }

    private static SidescanParser getParser() {
        if (file != null) {
            return null;
        }
        if (dir != null) {
            file = new File(dir.getAbsolutePath() + "/Data.jsf");
            if (file.exists()) {
                return new JsfSidescanParser(file);
            }
            if (source != null) {
                if (LogUtils.hasIMCSidescan(source)) {
                    return new ImcSidescanParser(source);
                }
                if (source.getLog("SidescanPing") != null) {
                    return new LegacyImcSidescanParser(source);
                }
            }
        }
        return null;
    }
}

