/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.exporters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import javax.swing.ProgressMonitor;
import pt.lsts.imc.EntityInfo;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCMessageType;
import pt.lsts.imc.lsf.LsfIterator;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription
public class CSVExporter
implements MRAExporter {
    IMraLogGroup source;
    ProgressMonitor pmonitor;
    LinkedHashMap<Short, String> entityNames = new LinkedHashMap();

    public CSVExporter(IMraLogGroup source) {
        this.source = source;
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return true;
    }

    public String getHeader(String messageType) {
        IMCMessageType type = this.source.getLsfIndex().getDefinitions().getType(messageType);
        String ret = "timestamp (seconds since 01/01/1970), system, entity ";
        for (String field : type.getFieldNames()) {
            if (type.getFieldUnits(field) != null) {
                ret = ret + ", " + field + " (" + type.getFieldUnits(field) + ")";
                continue;
            }
            ret = ret + ", " + field;
        }
        return ret + "\n";
    }

    public String getLine(IMCMessage m) {
        NumberFormat doubles = GuiUtils.getNeptusDecimalFormat(8);
        NumberFormat floats = GuiUtils.getNeptusDecimalFormat(3);
        String entity = this.entityNames.get(m.getSrcEnt());
        if (entity == null) {
            entity = "" + m.getSrcEnt();
        }
        String ret = floats.format(m.getTimestamp()) + ", " + m.getSourceName() + ", " + entity;
        block8: for (String field : m.getFieldNames()) {
            switch (m.getTypeOf(field)) {
                case "fp32_t": {
                    ret = ret + ", " + floats.format(m.getDouble(field));
                    continue block8;
                }
                case "fp64_t": {
                    ret = ret + ", " + doubles.format(m.getDouble(field));
                    continue block8;
                }
                default: {
                    ret = ret + ", " + m.getAsString(field);
                }
            }
        }
        return ret + "\n";
    }

    @Override
    public String process(IMraLogGroup source, ProgressMonitor pmonitor) {
        File dir = new File(source.getFile("mra"), "csv");
        dir.mkdirs();
        this.entityNames.clear();
        LsfIterator it = source.getLsfIndex().getIterator(EntityInfo.class);
        if (it != null) {
            for (EntityInfo ei : it) {
                this.entityNames.put(ei.getId(), ei.getLabel());
            }
        }
        int i = 0;
        for (String message : source.listLogs()) {
            if (pmonitor.isCanceled()) {
                return "Cancelled by the user";
            }
            try {
                File out = new File(dir, message + ".csv");
                BufferedWriter bw = new BufferedWriter(new FileWriter(out));
                pmonitor.setNote(I18n.textf("Exporting %message data to %csvfile...", message, out.getAbsolutePath()));
                pmonitor.setProgress(++i);
                bw.write(this.getHeader(message));
                for (IMCMessage m : source.getLsfIndex().getIterator(message)) {
                    bw.write(this.getLine(m));
                }
                bw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                pmonitor.close();
                return e.getClass().getSimpleName() + ": " + e.getMessage();
            }
        }
        return I18n.text("Process complete");
    }

    @Override
    public String getName() {
        return I18n.text("Export to CSV");
    }
}

