/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.exporters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.swing.JFileChooser;
import javax.swing.ProgressMonitor;
import pt.lsts.imc.Conductivity;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.Temperature;
import pt.lsts.imc.VehicleMedium;
import pt.lsts.imc.lsf.IndexScanner;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mra.api.CorrectedPosition;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.llf.LsfLogSource;

@PluginDescription(name="Export CTD data to CSV")
public class CTDExporter
implements MRAExporter {
    public CTDExporter(IMraLogGroup source) {
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return source.getLsfIndex().getEntityId("CTD") != -1;
    }

    @Override
    public String getName() {
        return PluginUtils.getPluginDescription(this.getClass());
    }

    private String finish(BufferedWriter writer, int count) {
        try {
            writer.close();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
        return "Exported " + count + " samples";
    }

    @Override
    public String process(IMraLogGroup source, ProgressMonitor pmonitor) {
        BufferedWriter writer;
        LsfIndex index = source.getLsfIndex();
        IndexScanner scanner = new IndexScanner(index);
        pmonitor.setMaximum(index.getNumberOfMessages());
        pmonitor.setMinimum(index.getNumberOfMessages());
        pmonitor.setNote("Creating output folder...");
        File dir = new File(source.getFile("mra"), "csv");
        dir.mkdirs();
        pmonitor.setNote("Generating corrected positions...");
        pmonitor.setProgress(10);
        CorrectedPosition cp = new CorrectedPosition(source);
        pmonitor.setNote("Exporting...");
        int count = 0;
        File out = new File(dir, "CTD.csv");
        try {
            writer = new BufferedWriter(new FileWriter(out));
            writer.write("timestamp, gmt_time, latitude, longitude, corrected_lat, corrected_lon, conductivity, temperature, depth, medium\n");
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return "Error creating output file: " + e.getMessage();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Conductivity c;
        while ((c = (Conductivity)scanner.next(Conductivity.class, "CTD")) != null) {
            int idx = scanner.getIndex();
            VehicleMedium m = (VehicleMedium)scanner.next(VehicleMedium.class);
            try {
                scanner.setIndex(idx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Temperature t = (Temperature)scanner.next(Temperature.class, "CTD");
            if (t == null) {
                return this.finish(writer, count);
            }
            EstimatedState d = (EstimatedState)scanner.next(EstimatedState.class);
            if (d == null) {
                return this.finish(writer, count);
            }
            ++count;
            LocationType loc = IMCUtils.parseLocation((IMCMessage)d).convertToAbsoluteLatLonDepth();
            SystemPositionAndAttitude p = cp.getPosition(d.getTimestamp());
            if (p == null) {
                return "error positions is Empty";
            }
            try {
                String medium = "UNKNOWN";
                if (m != null) {
                    medium = m.getMedium().toString();
                }
                writer.write(t.getTimestamp() + ", " + dateFormat.format(t.getDate()) + ", " + loc.getLatitudeDegs() + ", " + loc.getLongitudeDegs() + ", " + (p != null ? p.getPosition().getLatitudeDegs() : loc.getLatitudeDegs()) + ", " + (p != null ? p.getPosition().getLongitudeDegs() : loc.getLongitudeDegs()) + ", " + c.getValue() + ", " + t.getValue() + ", " + d.getDepth() + ", " + medium + "\n");
            }
            catch (Exception e) {
                e.printStackTrace();
                NeptusLog.pub().error((Object)e);
                return "Error writing to file: " + e.getMessage();
            }
            pmonitor.setProgress(scanner.getIndex());
        }
        return this.finish(writer, count);
    }

    private static void exportRecursively(File root) {
        for (File f : root.listFiles()) {
            if (f.isDirectory()) {
                CTDExporter.exportRecursively(f);
                continue;
            }
            if (!f.getName().endsWith(".lsf") && !f.getName().endsWith(".lsf.gz") || !f.getAbsolutePath().contains("trex_plan")) continue;
            try {
                System.out.println(CTDExporter.export(f));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String export(File source) throws Exception {
        LsfLogSource group = new LsfLogSource(source, null);
        CTDExporter exporter = new CTDExporter(group);
        ProgressMonitor pm = new ProgressMonitor(null, "Processing " + source.getAbsolutePath(), "processing", 0, 1000);
        if (exporter.canBeApplied(group)) {
            System.out.println("processing " + source.getAbsolutePath());
            String res = exporter.process(group, pm);
            pm.close();
            return res;
        }
        return null;
    }

    public static void main(String[] args) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        int op = chooser.showOpenDialog(null);
        if (op == 0) {
            File root = chooser.getSelectedFile();
            CTDExporter.exportRecursively(root);
        }
    }
}

