/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.exporters;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.swing.ProgressMonitor;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mra.api.BathymetrySwath;
import pt.lsts.neptus.mra.api.CorrectedPosition;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.importers.deltat.DeltaTHeader;
import pt.lsts.neptus.mra.importers.deltat.DeltaTParser;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.FileUtil;

@PluginDescription
public class DeltaT83PToCorrectedPos83P
implements MRAExporter {
    private IMraLogGroup log = null;
    private CorrectedPosition correctedPosition = null;
    private DeltaTParser deltaParser = null;
    private RandomAccessFile raFile;
    private FileChannel channel;
    private ByteBuffer buf;
    private long curPos = 0L;

    public DeltaT83PToCorrectedPos83P(IMraLogGroup log) {
        this.log = log;
    }

    @Override
    public String getName() {
        return "83P to 83P with Corrected Position";
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return DeltaTParser.canBeApplied(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(IMraLogGroup source, ProgressMonitor pmonitor) {
        if (!this.canBeApplied(source)) {
            return "No data to process!";
        }
        this.log = source;
        if (pmonitor != null) {
            pmonitor.setNote(I18n.text("Copying file"));
        }
        File fileOrig = DeltaTParser.findDataSource(source);
        String destName = FileUtil.getFileNameWithoutExtension(fileOrig) + "Corrected" + "." + FileUtil.getFileExtension(fileOrig);
        File fileDest = new File(fileOrig.getParent(), destName);
        boolean ret = FileUtil.copyFile(fileOrig.getPath(), fileDest.getPath());
        if (!ret) {
            return "Unable to copy data!";
        }
        try {
            this.raFile = new RandomAccessFile(fileDest, "rw");
        }
        catch (FileNotFoundException e1) {
            return "Error getting channel for 83P file!";
        }
        if (pmonitor != null) {
            pmonitor.setNote(I18n.text("Working"));
        }
        this.channel = this.raFile.getChannel();
        this.deltaParser = new DeltaTParser(source);
        this.correctedPosition = this.deltaParser.getCorrectedPosition();
        BathymetrySwath nextSwath = null;
        try {
            Object header;
            nextSwath = this.deltaParser.nextSwath();
            while (nextSwath != null) {
                this.buf = this.channel.map(FileChannel.MapMode.READ_WRITE, this.curPos, 256L);
                header = this.deltaParser.getCurrentHeader();
                this.curPos = this.deltaParser.getCurrentPosition() - (long)((DeltaTHeader)header).numBytes;
                long nextSwathTimeStamp = nextSwath.getTimestamp();
                SystemPositionAndAttitude pos = this.correctedPosition.getPosition(nextSwathTimeStamp);
                LocationType posLoc = pos.getPosition();
                posLoc = posLoc.getNewAbsoluteLatLonDepth();
                String lat83P = CoordinateUtil.latTo83PFormatWorker(posLoc.getLatitudeDegs());
                String lon83P = CoordinateUtil.lonTo83PFormatWorker(posLoc.getLongitudeDegs());
                this.buf.position(33);
                byte[] latBytes = new byte[14];
                this.buf.get(latBytes);
                latBytes = lat83P.getBytes(Charset.forName("ASCII"));
                this.buf.put(latBytes);
                this.buf.position(47);
                byte[] lonBytes = new byte[14];
                this.buf.get(lonBytes);
                lonBytes = lon83P.getBytes(Charset.forName("ASCII"));
                this.buf.put(lonBytes);
                nextSwath = this.deltaParser.nextSwath();
                if (pmonitor == null || !pmonitor.isCanceled()) continue;
                String string = "Export to 83P interrupted!";
                return string;
            }
            header = "Export to 83P completed successfully";
            return header;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "Export to 83P completed with errors! (" + e.getMessage() + ")";
            return string;
        }
        finally {
            if (this.channel != null) {
                try {
                    this.channel.force(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        double[] valsLon;
        double[] valsLat;
        for (double val : valsLat = new double[]{38.276276276766, -9.276276276766, 41.0}) {
            System.out.print(val);
            System.out.print("\t::\t");
            System.out.print(CoordinateUtil.latitudeAsPrettyString(val, false));
            System.out.print("\t::\t");
            String fmt = CoordinateUtil.latTo83PFormatWorker(val);
            System.out.print(fmt);
            System.out.print("\t::\t");
            System.out.println(CoordinateUtil.latFrom83PFormatWorker(fmt));
        }
        for (double val : valsLon = new double[]{13.453, 122.45334343434, 12.45334343434, -2.45334343434, 2.0}) {
            System.out.print(val);
            System.out.print("\t::\t");
            System.out.print(CoordinateUtil.longitudeAsPrettyString(val, false));
            System.out.print("\t::\t");
            String fmt = CoordinateUtil.lonTo83PFormatWorker(val);
            System.out.print(fmt);
            System.out.print("\t::\t");
            System.out.println(CoordinateUtil.lonFrom83PFormatWorker(fmt));
        }
        byte[] by = " 38.22.35324 N".getBytes(Charset.forName("ASCII"));
        System.out.println(by.length);
        System.out.println(by);
        System.out.println(Arrays.toString(by));
        try {
            System.out.println(new String(by, "ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

