/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.exporters;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.ProgressMonitor;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.SonarData;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;

@PluginDescription
public class ImcTo837
implements MRAExporter {
    DataOutputStream os;
    IMraLog pingLog;
    IMraLog esLog;
    int multiBeamEntityId;
    IMraLogGroup log;
    static int st;

    public ImcTo837(IMraLogGroup log) {
        this.log = log;
    }

    @Override
    public String getName() {
        return "IMC to 837";
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        IMCMessage first;
        IMraLog log = source.getLog("SonarData");
        if (log == null) {
            return false;
        }
        IMCMessage msg = first = log.firstLogEntry();
        while (msg != null && msg.getTimestampMillis() <= first.getTimestampMillis() + 2000L) {
            if (msg.getLong("type") == SonarData.TYPE.MULTIBEAM.value()) {
                return true;
            }
            msg = log.nextLogEntry();
        }
        return false;
    }

    @Override
    public String process(IMraLogGroup source, ProgressMonitor pmonitor) {
        try {
            File outFile = new File(this.log.getFile("Data.lsf").getParentFile() + "/multibeam.837");
            this.os = new DataOutputStream(new FileOutputStream(outFile));
            this.pingLog = this.log.getLog("SonarData");
            this.esLog = this.log.getLog("EstimatedState");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return e.getClass().getSimpleName() + " while exporting to 837: " + e.getMessage();
        }
        IMCMessage pingMsg = this.pingLog.firstLogEntry();
        byte[] zeroFill = new byte[236];
        byte[] prevBuffer = new byte[16000];
        String lat = "";
        String lon = "";
        String sTime = "";
        String sMillis = "";
        double[] res = new double[2];
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        new LocationType();
        for (int i = 0; i < zeroFill.length; ++i) {
            zeroFill[i] = 0;
        }
        try {
            while (pingMsg != null) {
                if ((long)pingMsg.getInteger("type") == SonarData.TYPE.MULTIBEAM.value()) {
                    int heading;
                    int pitch;
                    int roll;
                    IMCMessage esMsg = this.esLog.getEntryAtOrAfter(this.pingLog.currentTimeMillis());
                    if (esMsg == null) {
                        roll = 900;
                        pitch = 900;
                        heading = 900;
                    } else {
                        roll = (short)Math.toDegrees(esMsg.getDouble("phi"));
                        pitch = (short)Math.toDegrees(esMsg.getDouble("theta"));
                        heading = (short)Math.toDegrees(esMsg.getDouble("psi"));
                        res = CoordinateUtil.latLonAddNE2(Math.toDegrees(esMsg.getDouble("lat")), Math.toDegrees(esMsg.getDouble("lon")), esMsg.getDouble("x"), esMsg.getDouble("y"));
                        int d = (int)res[0];
                        double m = (res[0] - (double)d) * 60.0;
                        lat = String.format(" %02d.%.5f", Math.abs(d), Math.abs(m)) + (d > 0 ? " N" : " S");
                        d = (int)res[1];
                        m = (res[1] - (double)d) * 60.0;
                        lon = String.format("%03d.%.5f", Math.abs(d), Math.abs(m)) + (d > 0 ? " E" : " W");
                        NeptusLog.pub().info((Object)("<###> " + lat));
                        NeptusLog.pub().info((Object)("<###> " + lon));
                    }
                    long timestamp = this.esLog.currentTimeMillis();
                    cal.setTimeInMillis(timestamp);
                    String month = "";
                    switch (cal.get(2)) {
                        case 0: {
                            month = "JAN";
                            break;
                        }
                        case 1: {
                            month = "FEB";
                            break;
                        }
                        case 2: {
                            month = "MAR";
                            break;
                        }
                        case 3: {
                            month = "APR";
                            break;
                        }
                        case 4: {
                            month = "MAY";
                            break;
                        }
                        case 5: {
                            month = "JUN";
                            break;
                        }
                        case 6: {
                            month = "JUL";
                            break;
                        }
                        case 7: {
                            month = "AUG";
                            break;
                        }
                        case 8: {
                            month = "SEP";
                            break;
                        }
                        case 9: {
                            month = "OCT";
                            break;
                        }
                        case 10: {
                            month = "NOV";
                            break;
                        }
                        case 11: {
                            month = "DEC";
                        }
                    }
                    sTime = String.format("%02d-%s-%d\u0000%02d:%02d:%02d\u0000.00\u0000", cal.get(5), month, cal.get(1), cal.get(11), cal.get(12), cal.get(13));
                    sMillis = String.format(".%03d\u0000", cal.get(14));
                    byte[] buffer = new byte[pingMsg.getRawData("data").length];
                    this.os.write("837".getBytes());
                    this.os.writeByte(buffer.length == 8000 ? 10 : 11);
                    this.os.writeShort(buffer.length == 8000 ? 8192 : 16384);
                    this.os.writeShort(buffer.length + 13);
                    this.os.write(sTime.getBytes());
                    this.os.writeInt(0);
                    this.os.writeByte(131);
                    this.os.writeByte(1);
                    this.os.write(new byte[]{0, 0});
                    this.os.write(new byte[]{0, 0, 7});
                    this.os.writeByte(18);
                    this.os.writeByte(0);
                    this.os.writeShort(0);
                    this.os.write(lat.getBytes());
                    this.os.write(lon.getBytes());
                    this.os.writeByte(0);
                    this.os.writeShort(0);
                    this.os.writeByte(0);
                    this.os.writeShort(260);
                    this.os.writeShort(pitch * 10 + 900 + 32768);
                    this.os.writeShort(roll * 10 + 900 + 32768);
                    this.os.writeShort(32768);
                    this.os.writeShort(97);
                    this.os.writeByte(50);
                    this.os.writeShort(0);
                    this.os.write(sMillis.getBytes());
                    this.os.writeShort(0);
                    this.os.write(buffer.length == 8000 ? "IUX".getBytes() : "IVX".getBytes());
                    this.os.write(new byte[]{16, 0, 7, 36, (byte)pingMsg.getInteger("max_range"), 0, 0});
                    this.os.writeShort(buffer.length);
                    System.arraycopy(pingMsg.getRawData("data"), 0, buffer, 0, buffer.length);
                    this.os.write(buffer);
                    this.os.writeByte(252);
                    this.os.writeFloat(0.0f);
                    this.os.writeFloat(0.0f);
                    this.os.writeFloat(0.0f);
                    this.os.writeByte(1);
                    this.os.writeShort(pitch);
                    this.os.writeShort(roll);
                    this.os.writeShort(heading);
                    this.os.writeShort(0);
                    this.os.writeShort(0);
                    this.os.writeByte(1);
                    this.os.writeFloat(0.0f);
                    this.os.write(new byte[]{0, 0, 0, 0, 0, 0, 0});
                    if (buffer.length == 8000) {
                        this.os.write(zeroFill, 0, 44);
                    } else {
                        this.os.write(zeroFill);
                    }
                    System.arraycopy(buffer, 0, prevBuffer, 0, buffer.length);
                }
                pingMsg = this.pingLog.nextLogEntry();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getClass().getSimpleName() + " while exporting to 837: " + e.getMessage();
        }
        NeptusLog.pub().info((Object)"<###>end");
        return "Export to 837 completed successfully";
    }
}

