/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.exporters;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.util.llf.LsfLogSource;

public class ImcTo872 {
    DataOutputStream os;
    IMraLog pingLog;
    int multiBeamEntityId;
    LsfLogSource log;

    public ImcTo872(LsfLogSource log) {
        try {
            File outFile = new File(log.getFile("Data.lsf").getParentFile() + "/sidescan.872");
            this.os = new DataOutputStream(new FileOutputStream(outFile));
            this.log = log;
            this.pingLog = log.getLog("SidescanPing");
            this.convert();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    void convert() {
        IMCMessage pingMsg = this.pingLog.firstLogEntry();
        int c = 0;
        byte[] zeroFill = new byte[1094];
        for (int i = 0; i < zeroFill.length; ++i) {
            zeroFill[i] = 0;
        }
        try {
            while (pingMsg != null) {
                byte[] buffer = new byte[pingMsg.getRawData("data").length];
                System.arraycopy(pingMsg.getRawData("data"), 0, buffer, 0, buffer.length);
                this.os.write("872".getBytes());
                this.os.writeByte(0);
                this.os.writeInt(++c);
                this.os.writeShort(4096);
                this.os.writeShort(1000);
                this.os.writeByte(1);
                this.os.writeByte(8);
                this.os.writeByte(0);
                this.os.writeShort(3000);
                this.os.writeShort(0);
                this.os.write("01-JAN-2001\u0000".getBytes());
                this.os.write("00:00:00\u0000".getBytes());
                this.os.write(".000\u0000".getBytes());
                this.os.writeByte(1);
                this.os.writeByte(7);
                this.os.writeByte(0);
                this.os.writeByte(30);
                this.os.writeShort(63);
                this.os.writeShort(15000);
                this.os.write("IGXB".getBytes());
                this.os.write(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0});
                this.os.writeInt(0);
                this.os.writeByte(1);
                this.os.writeByte(0);
                byte[] fill = new byte[928];
                for (int z = 0; z < fill.length; ++z) {
                    fill[z] = 0;
                }
                this.os.write(fill);
                this.os.write(buffer);
                this.os.write(zeroFill);
                this.os.writeShort(8192);
                pingMsg = this.pingLog.nextLogEntry();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NeptusLog.pub().info((Object)"<###>end");
    }

    public static void main(String[] args) throws Exception {
        new ImcTo872(new LsfLogSource("/home/jqcorreia/lsts/dune/build/log/115016_Demo_1.6m_900rpm/Data.lsf", null));
    }
}

