/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.exporters;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCInputStream;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.coord.CoordinateUtil;

public class ImcToSds {
    public static int SDS_SYNC = 1398361667;
    private File inputFile;
    private File outputFile;
    private IMCInputStream is;
    private DataOutputStream os;

    public ImcToSds(File input, IMCDefinition defs) {
        this.setInputFile(input);
        try {
            this.is = new IMCInputStream((InputStream)new FileInputStream(input), defs);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setInputFile(File f) {
        this.inputFile = f;
    }

    public void setOutputFile(File f) {
        this.outputFile = f;
    }

    public void writeHeader(int time, int tag, int size, byte misc) throws IOException {
        int dwSize = size;
        int dwTimeStamp = time;
        int dwTag = tag;
        byte[] byMisc = new byte[]{misc, misc, misc};
        byte byChecksum = (byte)((dwSize >>> 24) + (dwSize >>> 16) + (dwSize >>> 8) + dwSize + (dwTimeStamp >>> 24) + (dwTimeStamp >>> 16) + (dwTimeStamp >>> 8) + dwTimeStamp + (dwTag >>> 24) + (dwTag >>> 16) + (dwTag >>> 8) + dwTag + byMisc[0] + byMisc[1] + byMisc[2]);
        this.os.writeInt(Integer.reverseBytes(dwSize));
        this.os.writeInt(Integer.reverseBytes(dwTimeStamp));
        this.os.writeInt(Integer.reverseBytes(dwTag));
        this.os.write(byMisc);
        this.os.write(byChecksum);
    }

    public void writeSyncPacket(int reference, short interval, int time) throws IOException {
        this.writeHeader(time, SDS_SYNC, 6, (byte)-86);
        this.os.writeInt(Integer.reverseBytes(reference));
        this.os.writeShort(Short.reverseBytes(interval));
    }

    public void writeSonarPacket(IMCMessage ping, int elapsedtime, int pingId) {
        int i;
        int dataSize = ping.getRawData("data").length;
        int psize = 60 + dataSize;
        byte[] reserved = new byte[]{0, 0, 0, 0, 0, 0, 0};
        byte[] data = ping.getRawData("data");
        byte[] leftChannel = new byte[dataSize / 2];
        byte[] rightChannel = new byte[dataSize / 2];
        float freq = 0.0f;
        switch (ping.getInteger("frequency")) {
            case 0: {
                freq = 770.0f;
                break;
            }
            case 1: {
                freq = 330.0f;
                break;
            }
            case 2: {
                freq = 260.0f;
            }
        }
        for (i = 0; i < dataSize / 2; ++i) {
            leftChannel[dataSize / 2 - 1 - i] = data[i];
        }
        for (i = dataSize / 2; i < dataSize; ++i) {
            rightChannel[i - dataSize / 2] = data[i];
        }
        try {
            this.writeHeader(elapsedtime, 844254802, psize, (byte)0);
            this.wByte(2);
            this.wInt(pingId);
            this.wFloat(1500.0f);
            this.os.write(reserved);
            this.wShort((short)1);
            this.wShort((short)1);
            this.wFloat(freq * 1000.0f);
            this.wFloat((float)ping.getInteger("range") / 1.5f);
            this.wFloat(0.0f);
            this.wShort((short)1);
            this.wShort((short)1);
            this.wShort((short)1000);
            this.wShort((short)2);
            this.wShort((short)2);
            this.wFloat(freq * 1000.0f);
            this.wFloat((float)ping.getInteger("range") / 1.5f);
            this.wFloat(0.0f);
            this.wShort((short)1);
            this.wShort((short)1);
            this.wShort((short)1000);
            this.os.write(leftChannel);
            this.os.write(rightChannel);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeNavigationPacket(IMCMessage msg, int elapsedtime) throws IOException {
        int psize = 30;
        double[] res = CoordinateUtil.latLonAddNE2(Math.toDegrees(msg.getDouble("lat")), Math.toDegrees(msg.getDouble("lon")), msg.getDouble("x"), msg.getDouble("y"));
        this.writeHeader(elapsedtime, 1312904704, psize, (byte)0);
        this.wShort((short)2);
        this.wDouble(res[0]);
        this.wDouble(res[1]);
        this.wFloat((float)Math.atan2(msg.getDouble("x"), msg.getDouble("y")));
        this.wFloat((float)Math.toDegrees(msg.getDouble("psi")));
        this.wFloat((float)Math.sqrt(Math.pow(msg.getDouble("vx"), 2.0) + Math.pow(msg.getDouble("vy"), 2.0)));
    }

    public void writeFathometerPacket(IMCMessage msg, double depth, int elapsedtime) throws IOException {
        int psize = 10;
        this.writeHeader(elapsedtime, 1178686464, psize, (byte)0);
        this.wShort((short)2);
        this.wFloat((float)depth);
        this.wFloat((float)msg.getDouble("value"));
    }

    public void wByte(int b) throws IOException {
        this.os.write(b);
    }

    public void wFloat(float f) throws IOException {
        this.os.writeInt(Integer.reverseBytes(Float.floatToIntBits(f)));
    }

    public void wInt(int i) throws IOException {
        this.os.writeInt(Integer.reverseBytes(i));
    }

    public void wShort(short s) throws IOException {
        this.os.writeShort(Short.reverseBytes(s));
    }

    public void wDouble(double d) throws IOException {
        this.os.writeLong(Long.reverseBytes(Double.doubleToLongBits(d)));
    }

    public void convertToSDSFile(File file) {
        double firstTime = 0.0;
        IMCMessage msg = null;
        int c = 0;
        double prevTimeMillis = 0.0;
        int n = 0;
        this.setOutputFile(file);
        try {
            this.os = new DataOutputStream(new FileOutputStream(this.outputFile));
            double lastDepth = 0.0;
            while (msg != null) {
                msg = this.is.readMessage();
                if (c == 0) {
                    this.writeSyncPacket((int)msg.getTimestamp(), (short)1000, 0);
                    firstTime = msg.getTimestampMillis();
                    prevTimeMillis = msg.getTimestampMillis();
                } else if ((double)msg.getTimestampMillis() - prevTimeMillis > 1000.0) {
                    this.writeSyncPacket((int)msg.getTimestamp(), (short)1000, ++n * 1000);
                    prevTimeMillis = msg.getTimestampMillis();
                }
                if (msg.getAbbrev().equals("SidescanPing")) {
                    this.writeSonarPacket(msg, (int)((double)msg.getTimestampMillis() - firstTime), c);
                }
                if (msg.getAbbrev().equals("EstimatedState")) {
                    lastDepth = msg.getDouble("z");
                    this.writeNavigationPacket(msg, (int)((double)msg.getTimestampMillis() - firstTime));
                }
                if (msg.getAbbrev().equals("BottomDistance")) {
                    this.writeFathometerPacket(msg, lastDepth, (int)((double)msg.getTimestampMillis() - firstTime));
                }
                ++c;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        NeptusLog.pub().info((Object)("<###>Number of messages processed to SDS: " + c));
        try {
            this.is.close();
            this.os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ImcToSds converter = new ImcToSds(new File(args[0]), IMCDefinition.getInstance());
        NeptusLog.pub().info((Object)("<###> " + converter.inputFile.getAbsolutePath()));
        converter.convertToSDSFile(new File(args[1]));
        NeptusLog.pub().info((Object)("<###> " + converter.outputFile.getAbsolutePath()));
    }
}

