/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.exporters;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.ProgressMonitor;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfGenericIterator;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorBar;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.ColormapOverlay;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAProperties;
import pt.lsts.neptus.mra.WorldImage;
import pt.lsts.neptus.mra.api.BathymetryParser;
import pt.lsts.neptus.mra.api.BathymetryParserFactory;
import pt.lsts.neptus.mra.api.BathymetryPoint;
import pt.lsts.neptus.mra.api.BathymetrySwath;
import pt.lsts.neptus.mra.api.SidescanLine;
import pt.lsts.neptus.mra.api.SidescanParameters;
import pt.lsts.neptus.mra.api.SidescanParser;
import pt.lsts.neptus.mra.api.SidescanParserFactory;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.importers.deltat.DeltaTParser;
import pt.lsts.neptus.mra.importers.jsf.JsfSidescanParser;
import pt.lsts.neptus.mra.importers.lsf.DVLBathymetryParser;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.renderer2d.ImageLayer;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.bathymetry.TidePredictionFactory;
import pt.lsts.neptus.util.bathymetry.TidePredictionFinder;
import pt.lsts.neptus.util.llf.LogUtils;
import pt.lsts.util.WGS84Utilities;

@PluginDescription
public class KMLExporter
implements MRAExporter {
    public double minHeight = 1000.0;
    public double maxHeight = -1.0;
    private IMraLogGroup source;
    private ProgressMonitor pmonitor;
    @NeptusProperty(category="SideScan")
    public double timeVariableGain = 300.0;
    @NeptusProperty(category="SideScan")
    public double normalization = 0.1;
    @NeptusProperty(category="SideScan")
    public double swathLength = 1.0;
    @NeptusProperty(category="SideScan")
    public double swathTransparency = 0.25;
    @NeptusProperty
    public double layerTransparency = 0.5;
    @NeptusProperty(category="SideScan")
    public boolean separateTransducers = false;
    @NeptusProperty(category="SideScan")
    public boolean filterOutNadir = true;
    @NeptusProperty(category="SideScan")
    public double maximumSidescanRange = 50.0;
    @NeptusProperty(name="Seconds Gap in EstimatedState for Path Break")
    public int secondsGapInEstimatedStateForPathBreak = 30;
    @NeptusProperty(category="Visibility")
    public boolean visibilityForBathymetry = true;
    @NeptusProperty(category="Visibility")
    public boolean visibilityForSideScan = true;
    @NeptusProperty(category="Visibility")
    public boolean visibilityForLegends = true;

    public KMLExporter(IMraLogGroup source) {
        this.source = source;
    }

    @Override
    public String getName() {
        return I18n.text("Export to KML");
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return true;
    }

    public String kmlHeader(String title) {
        String ret = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.1\">\n";
        ret = ret + "\t<Document>\n";
        ret = ret + "\t\t<name>" + title + "</name>\n";
        Date d = new Date((long)(1000.0 * this.source.getLsfIndex().getStartTime()));
        ret = ret + "\t\t<description>Plan executed on " + d + "</description>";
        ret = ret + "\t\t<Style id=\"estate\">\n";
        ret = ret + "\t\t\t<LineStyle>\n";
        ret = ret + "\t\t\t<color>99ff0000</color>\n";
        ret = ret + "\t\t\t<width>4</width>\n";
        ret = ret + "\t\t\t</LineStyle>\n";
        ret = ret + "\t\t</Style>\n";
        ret = ret + "\t\t<Style id=\"plan\">\n";
        ret = ret + "\t\t\t<LineStyle>\n";
        ret = ret + "\t\t\t<color>990000ff</color>\n";
        ret = ret + "\t\t\t<width>4</width>\n";
        ret = ret + "\t\t\t</LineStyle>\n";
        ret = ret + "\t\t</Style>\n";
        return ret;
    }

    public String overlay(File imageFile, String title, LocationType sw, LocationType ne, boolean visibility) {
        sw.convertToAbsoluteLatLonDepth();
        ne.convertToAbsoluteLatLonDepth();
        String ret = "\t\t<GroundOverlay>\n";
        try {
            ret = ret + "\t\t\t<name>" + title + "</name>\n";
            ret = ret + "\t\t\t<visibility>" + (visibility ? 1 : 0) + "</visibility>\n";
            ret = ret + "\t\t\t<description></description>\n";
            ret = ret + "\t\t\t<Icon>\n";
            ret = ret + "\t\t\t\t<href>" + imageFile.getName() + "</href>\n";
            ret = ret + "\t\t\t</Icon>\n";
            ret = ret + "\t\t\t<LatLonBox>\n";
            ret = ret + "\t\t\t\t<north>" + ne.getLatitudeDegs() + "</north>\n";
            ret = ret + "\t\t\t\t<south>" + sw.getLatitudeDegs() + "</south>\n";
            ret = ret + "\t\t\t\t<east>" + ne.getLongitudeDegs() + "</east>\n";
            ret = ret + "\t\t\t\t<west>" + sw.getLongitudeDegs() + "</west>\n";
            ret = ret + "\t\t\t\t<rotation>0</rotation>\n";
            ret = ret + "\t\t\t</LatLonBox>\n";
            ret = ret + "\t\t</GroundOverlay>\n";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return ret;
    }

    public String path(Vector<LocationType> coords, String name, String style) {
        String retAll = "";
        int idx = 0;
        int pathNumber = 0;
        while (idx < coords.size()) {
            String ret = "\t\t<Placemark>\n";
            ret = ret + "\t\t\t<name>" + name + " " + pathNumber++ + "</name>\n";
            ret = ret + "\t\t\t<styleUrl>#" + style + "</styleUrl>\n";
            ret = ret + "\t\t\t<LineString>\n";
            ret = ret + "\t\t\t\t<altitudeMode>relative</altitudeMode>\n";
            ret = ret + "\t\t\t\t<coordinates> ";
            LocationType l = coords.get(idx);
            while (idx < coords.size() && l != null) {
                l.convertToAbsoluteLatLonDepth();
                ret = ret + l.getLongitudeDegs() + "," + l.getLatitudeDegs() + ",0\n";
                l = coords.get(idx);
                ++idx;
            }
            ret = ret + "\t\t\t\t</coordinates>\n";
            ret = ret + "\t\t\t</LineString>\n";
            ret = ret + "\t\t</Placemark>\n";
            retAll = retAll + ret;
        }
        return retAll;
    }

    public String kmlFooter() {
        return "\t</Document>\n</kml>\n";
    }

    public String dvlOverlay(File dir, int resolution) {
        ColormapOverlay overlay = new ColormapOverlay("dvlBathymetry", 1, false, 0);
        TidePredictionFinder finder = TidePredictionFactory.create(this.source);
        for (EstimatedState state : this.source.getLsfIndex().getIterator(EstimatedState.class, 100)) {
            if (state.getAlt() < 0.0 || state.getDepth() < MRAProperties.minDepthForBathymetry || Math.abs(state.getTheta()) > Math.toDegrees(10.0)) continue;
            LocationType loc = new LocationType(Math.toDegrees(state.getLat()), Math.toDegrees(state.getLon()));
            loc.translatePosition(state.getX(), state.getY(), 0.0);
            if (finder == null) {
                overlay.addSample(loc, Math.max(0.0, state.getAlt()) + state.getDepth());
                continue;
            }
            try {
                overlay.addSample(loc, Math.max(0.0, state.getAlt()) + state.getDepth() - (double)finder.getTidePrediction(state.getDate(), false).floatValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ImageLayer il = overlay.getImageLayer();
        try {
            ImageIO.write((RenderedImage)il.getImage(), "PNG", new File(dir, "dvl.png"));
            il.setTransparency(this.layerTransparency);
            il.saveToFile(new File(dir.getParentFile(), "dvl.layer"));
            LocationType sw = new LocationType();
            LocationType ne = new LocationType();
            sw.setLatitudeStr(il.getBottomRight().getLatitudeStr());
            sw.setLongitudeStr(il.getTopLeft().getLongitudeStr());
            ne.setLatitudeStr(il.getTopLeft().getLatitudeStr());
            ne.setLongitudeStr(il.getBottomRight().getLongitudeStr());
            return this.overlay(new File(dir, "dvl.png"), "DVL Bathymetry mosaic", sw, ne, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String sidescanOverlay(File dir, double resolution, LocationType topLeft, LocationType bottomRight, Ducer ducer) {
        SidescanParser ssParser = SidescanParserFactory.build(this.source);
        double totalProg = 100.0;
        double startProg = 100.0;
        boolean makeAbs = ssParser instanceof JsfSidescanParser;
        if (ssParser == null || ssParser.getSubsystemList().isEmpty()) {
            return "";
        }
        double[] offsets = topLeft.getOffsetFrom(bottomRight);
        int width = (int)Math.abs(offsets[1] * resolution);
        int height = (int)Math.abs(offsets[0] * resolution);
        if (width <= 0 || height <= 0) {
            return "";
        }
        final BufferedImage img = new BufferedImage(width, height, 2);
        JLabel lbl = new JLabel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                g.drawImage(img, 0, 0, this.getWidth(), this.getHeight(), 0, 0, img.getWidth(), img.getHeight(), null);
            }
        };
        JFrame frm = GuiUtils.testFrame(lbl, "Creating sidescan mosaic...");
        frm.getContentPane().setBackground(Color.white);
        frm.setSize(800, 600);
        GuiUtils.centerOnScreen(frm);
        Graphics2D g = (Graphics2D)img.getGraphics();
        long start = ssParser.firstPingTimestamp();
        long end = ssParser.lastPingTimestamp();
        int sys = ssParser.getSubsystemList().get(0);
        SidescanParameters params = new SidescanParameters(this.normalization, this.timeVariableGain);
        String filename = "sidescan";
        BufferedImage swath = null;
        ColorMap cmap = ColorMapFactory.createBronzeColormap();
        for (long time = start; time < end - 1000L; time += 1000L) {
            ArrayList<SidescanLine> lines;
            if (this.pmonitor.isCanceled()) {
                frm.setVisible(false);
                frm.dispose();
                return "";
            }
            double progress = (double)(time - start) / (double)(end - start) * totalProg + startProg;
            this.pmonitor.setProgress((int)progress);
            try {
                lines = ssParser.getLinesBetween(time, time + 1000L, sys, params);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            BufferedImage previous = new BufferedImage(3, 3, 2);
            for (SidescanLine sl : lines) {
                int endPixel;
                int samplesPerPixel;
                int widthPixels = (int)((double)sl.range * resolution * 2.0);
                int nadirStartPixel = (int)((double)(widthPixels / 2) - sl.state.getAltitude() * resolution * 1.25);
                int nadirFinalPixel = (int)((double)(widthPixels / 2) + sl.state.getAltitude() * resolution * 1.25);
                if (swath == null || swath.getWidth() != widthPixels) {
                    swath = new BufferedImage(widthPixels, 3, 2);
                }
                if (previous != null) {
                    swath.getGraphics().drawImage(previous, 0, 0, swath.getWidth(), 1, 1, 0, 2, previous.getWidth(), null);
                }
                if ((samplesPerPixel = (int)Math.round(1.0 * (double)sl.data.length / (double)widthPixels)) == 0) continue;
                double sum = 0.0;
                int count = 0;
                switch (ducer) {
                    case board: {
                        int startPixel = 0;
                        endPixel = sl.data.length / 2;
                        filename = "sidescan_board";
                        break;
                    }
                    case starboard: {
                        int startPixel = sl.data.length / 2;
                        endPixel = sl.data.length;
                        filename = "sidescan_starboard";
                        break;
                    }
                    default: {
                        int startPixel = 0;
                        endPixel = sl.data.length;
                        filename = "sidescan";
                    }
                }
                int pixelOffset = (int)Math.round(((double)widthPixels - 1.0 * (double)sl.data.length / (double)samplesPerPixel) / 2.0);
                for (int i = startPixel; i < endPixel; ++i) {
                    if (i != 0 && i % samplesPerPixel == 0) {
                        int alpha = (int)(this.swathTransparency * 255.0);
                        double val = sum / (double)count;
                        int pixelInImgToWrite = i / samplesPerPixel - 1 + pixelOffset;
                        if (this.filterOutNadir && pixelInImgToWrite >= nadirStartPixel && pixelInImgToWrite <= nadirFinalPixel) {
                            alpha = Double.isNaN(val) || Double.isInfinite(val) ? 255 : (int)((1.0 - val) * (1.0 - val) * 255.0);
                        }
                        if (Double.isNaN(val) || Double.isInfinite(val)) {
                            alpha = 255;
                        }
                        if (pixelInImgToWrite >= 0 && pixelInImgToWrite < widthPixels) {
                            swath.setRGB(pixelInImgToWrite, 0, cmap.getColor(val).getRGB() ^ (alpha & 0xFF) << 24);
                        }
                        sum = 0.0;
                        count = 0;
                    }
                    if (Double.isNaN(sl.data[i]) || Double.isInfinite(sl.data[i])) continue;
                    ++count;
                    sum += sl.data[i];
                }
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                double[] pos = sl.state.getPosition().getOffsetFrom(topLeft);
                g2.translate(pos[1] * resolution, -pos[0] * resolution);
                if (makeAbs && sl.state.getYaw() < 0.0) {
                    g2.rotate(Math.toRadians(300.0) + sl.state.getYaw());
                } else {
                    g2.rotate(sl.state.getYaw());
                }
                g2.setColor(Color.black);
                g2.scale(1.0, this.swathLength * resolution);
                g2.drawImage((Image)swath, -swath.getWidth() / 2, 0, null);
                g2.dispose();
                previous = swath;
                lbl.repaint();
            }
        }
        frm.setVisible(false);
        frm.dispose();
        try {
            ImageIO.write((RenderedImage)img, "PNG", new File(dir, filename + ".png"));
            ImageLayer il = new ImageLayer("Sidescan mosaic from " + this.source.name(), img, topLeft, bottomRight);
            il.setTransparency(this.layerTransparency);
            String sufix = "";
            switch (ducer) {
                case board: {
                    sufix = " port";
                    break;
                }
                case starboard: {
                    sufix = " starboard";
                    break;
                }
            }
            il.saveToFile(new File(dir.getParentFile(), filename + ".layer"));
            return this.overlay(new File(dir, filename + ".png"), "Sidescan mosaic" + sufix, new LocationType(bottomRight.getLatitudeDegs(), topLeft.getLongitudeDegs()), new LocationType(topLeft.getLatitudeDegs(), bottomRight.getLongitudeDegs()), ducer == Ducer.both ? this.visibilityForSideScan : false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String multibeamLegend(File dir) {
        BufferedImage img = new BufferedImage(100, 170, 2);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(new Color(255, 255, 255, 100));
        g.fillRect(5, 30, 70, 110);
        ColorMap cmap = ColorMapFactory.createJetColorMap();
        ColorBar cb = new ColorBar(1, cmap);
        cb.setSize(15, 80);
        g.setColor(Color.black);
        Font prev = g.getFont();
        g.setFont(new Font("Helvetica", 1, 18));
        g.setFont(prev);
        g.translate(15, 45);
        cb.paint(g);
        g.translate(-10, -15);
        try {
            g.drawString(GuiUtils.getNeptusDecimalFormat(1).format(0L), 28, 20);
            g.drawString(GuiUtils.getNeptusDecimalFormat(1).format(MRAProperties.maxBathymDepth / 2.0), 28, 60);
            g.drawString(GuiUtils.getNeptusDecimalFormat(1).format(MRAProperties.maxBathymDepth), 28, 100);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            e.printStackTrace();
        }
        try {
            ImageIO.write((RenderedImage)img, "PNG", new File(dir, "mb_legend.png"));
            String ret = "\t\t<ScreenOverlay>\n";
            ret = ret + "\t\t\t<name>Multibeam layer legend</name>\n";
            ret = ret + "\t\t\t<visibility>" + this.visibilityForLegends + "</visibility>\n";
            ret = ret + "\t\t\t<Icon>\n";
            ret = ret + "\t\t\t\t<href>" + new File(dir, "mb_legend.png").getName() + "</href>\n";
            ret = ret + "\t\t\t</Icon>\n";
            ret = ret + "\t\t\t<overlayXY x=\"0\" y=\"1\" xunits=\"fraction\" yunits=\"fraction\"/>\n";
            ret = ret + "\t\t\t<screenXY x=\"0\" y=\"1\" xunits=\"fraction\" yunits=\"fraction\"/>\n";
            ret = ret + "\t\t\t<rotationXY x=\"0\" y=\"0\" xunits=\"fraction\" yunits=\"fraction\"/>\n";
            ret = ret + "\t\t\t<size x=\"0\" y=\"0\" xunits=\"fraction\" yunits=\"fraction\"/>\n";
            ret = ret + "\t\t</ScreenOverlay>\n";
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String multibeamOverlay(File dir) {
        BathymetrySwath swath;
        if (this.pmonitor.isCanceled()) {
            return "";
        }
        BathymetryParser parser = BathymetryParserFactory.build(this.source);
        double pixelWidth = 1.0;
        double startProg = 200.0;
        if (parser instanceof DVLBathymetryParser) {
            pixelWidth = 2.5;
        }
        if (parser == null) {
            NeptusLog.pub().info((Object)I18n.text("no multibeam data has been found."));
            return "";
        }
        String legend = this.multibeamLegend(dir);
        parser.rewind();
        LocationType topLeft = new LocationType(parser.getBathymetryInfo().topLeft);
        LocationType bottomRight = new LocationType(parser.getBathymetryInfo().bottomRight);
        topLeft.translatePosition(this.maximumSidescanRange, -this.maximumSidescanRange, 0.0);
        bottomRight.translatePosition(-this.maximumSidescanRange, this.maximumSidescanRange, 0.0);
        topLeft.convertToAbsoluteLatLonDepth();
        bottomRight.convertToAbsoluteLatLonDepth();
        double[] offsets = topLeft.getOffsetFrom(bottomRight);
        double mult = 1.25;
        int width = (int)Math.abs(offsets[1] * mult);
        int height = (int)Math.abs(offsets[0] * mult);
        final BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        long first = (long)(1000.0 * this.source.getLsfIndex().getStartTime());
        long time = (long)(1000.0 * this.source.getLsfIndex().getEndTime()) - first;
        long lastPercent = -1L;
        JLabel lbl = new JLabel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                g.drawImage(img, 0, 0, this.getWidth(), this.getHeight(), 0, 0, img.getWidth(), img.getHeight(), null);
            }
        };
        JFrame frm = GuiUtils.testFrame(lbl, "Creating multibeam mosaic...");
        frm.getContentPane().setBackground(Color.black);
        frm.setSize(800, 600);
        GuiUtils.centerOnScreen(frm);
        ColorMap cmap = ColorMapFactory.createJetColorMap();
        while ((swath = parser.nextSwath(1.0)) != null) {
            if (this.pmonitor.isCanceled()) {
                frm.setVisible(false);
                frm.dispose();
                return "";
            }
            LocationType loc = swath.getPose().getPosition();
            for (BathymetryPoint bp : swath.getData()) {
                LocationType loc2 = new LocationType(loc);
                if (bp == null) continue;
                loc2.translatePosition(bp.north, bp.east, 0.0);
                double[] pos = loc2.getOffsetFrom(topLeft);
                Color c = cmap.getColor(1.0 - (double)bp.depth / MRAProperties.maxBathymDepth);
                g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 64));
                g.fill(new Ellipse2D.Double(pos[1] * mult - pixelWidth / 2.0, -pos[0] * mult - pixelWidth / 2.0, pixelWidth, pixelWidth));
            }
            long percent = (swath.getTimestamp() - first) * 100L / time;
            if (percent != lastPercent) {
                this.pmonitor.setProgress((int)(startProg + (double)percent));
            }
            lastPercent = percent;
            lbl.repaint();
            lbl.setBackground(Color.black);
            try {
                Thread.yield();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        frm.setVisible(false);
        frm.dispose();
        try {
            ImageIO.write((RenderedImage)img, "PNG", new File(dir, "mb_bath2.png"));
            ImageLayer il = new ImageLayer("Bathymetry from " + this.source.name(), img, topLeft, bottomRight);
            il.setTransparency(this.layerTransparency);
            il.saveToFile(new File(dir.getParentFile(), "multibeam.layer"));
            return legend + this.overlay(new File(dir, "mb_bath2.png"), "Multibeam Bathymetry", new LocationType(bottomRight.getLatitudeDegs(), topLeft.getLongitudeDegs()), new LocationType(topLeft.getLatitudeDegs(), bottomRight.getLongitudeDegs()), this.visibilityForBathymetry);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Deprecated
    public String multibeamOverlay_old(File dir) {
        BathymetrySwath swath;
        if (this.source.getFile("multibeam.83P") == null) {
            NeptusLog.pub().info((Object)"no multibeam data hasn been found.");
            return "";
        }
        WorldImage imgMb = new WorldImage(3, ColorMapFactory.createJetColorMap());
        DeltaTParser parser = new DeltaTParser(this.source);
        parser.rewind();
        long first = (long)(1000.0 * this.source.getLsfIndex().getStartTime());
        long time = (long)(1000.0 * this.source.getLsfIndex().getEndTime()) - first;
        long lastPercent = -1L;
        while ((swath = parser.nextSwath(0.1)) != null) {
            LocationType loc = swath.getPose().getPosition();
            for (BathymetryPoint bp : swath.getData()) {
                if (Math.random() < 0.05) continue;
                LocationType loc2 = new LocationType(loc);
                if (bp == null) continue;
                loc2.translatePosition(-bp.north, -bp.east, 0.0);
                imgMb.addPoint(loc2, 1.0f - bp.depth / parser.getBathymetryInfo().maxDepth);
                long percent = (swath.getTimestamp() - first) * 100L / time;
                if (percent != lastPercent) {
                    NeptusLog.pub().info((Object)("MULTIBEAM: " + percent + "% done..."));
                }
                lastPercent = percent;
            }
        }
        try {
            ImageIO.write((RenderedImage)imgMb.processData(), "PNG", new File(dir, "mb_bath.png"));
            return this.overlay(new File(dir, "mb_bath.png"), "Multibeam Bathymetry", imgMb.getSouthWest(), imgMb.getNorthEast(), this.visibilityForBathymetry);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String process(IMraLogGroup source, ProgressMonitor pmonitor) {
        this.pmonitor = pmonitor;
        pmonitor.setMinimum(0);
        pmonitor.setMaximum(320);
        PluginUtils.editPluginProperties(this, true);
        try {
            pmonitor.setNote("Generating output dirs");
            File out = new File(source.getFile("mra"), "kml");
            out.mkdirs();
            out = new File(out, "data.kml");
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            File f = source.getFile(".");
            String name = f.getCanonicalFile().getName();
            bw.write(this.kmlHeader(name));
            Hashtable pathsForSystems = new Hashtable();
            Hashtable<String, IMCMessage> lastEstimatedStateForSystems = new Hashtable<String, IMCMessage>();
            LocationType bottomRight = null;
            LocationType topLeft = null;
            LsfGenericIterator it = source.getLsfIndex().getIterator("EstimatedState", 0, 3000L);
            pmonitor.setProgress(1);
            pmonitor.setNote("Generating path");
            double start = source.getLsfIndex().getStartTime();
            double end = source.getLsfIndex().getEndTime();
            for (IMCMessage s : it) {
                IMCMessage lastEsSys;
                double progress = (s.getTimestamp() - start) / (end - start) * 30.0 + 1.0;
                pmonitor.setProgress((int)progress);
                LocationType loc = IMCUtils.parseLocation(s);
                loc.convertToAbsoluteLatLonDepth();
                int srcSys = s.getSrc();
                String systemName = source.getSystemName(srcSys);
                if (systemName == null || systemName.isEmpty()) continue;
                Vector<LocationType> statesSys = (Vector<LocationType>)pathsForSystems.get(systemName);
                if (statesSys == null) {
                    statesSys = new Vector<LocationType>();
                    pathsForSystems.put(systemName, statesSys);
                }
                if ((lastEsSys = (IMCMessage)lastEstimatedStateForSystems.get(systemName)) != null && (double)(s.getTimestampMillis() - lastEsSys.getTimestampMillis()) > (double)this.secondsGapInEstimatedStateForPathBreak * 1000.0) {
                    statesSys.add(null);
                }
                lastEstimatedStateForSystems.put(systemName, s);
                statesSys.add(loc);
                if (bottomRight == null) {
                    bottomRight = new LocationType(loc);
                    topLeft = new LocationType(loc);
                }
                if (loc.getLatitudeDegs() < bottomRight.getLatitudeDegs()) {
                    bottomRight.setLatitudeDegs(loc.getLatitudeDegs());
                } else if (loc.getLatitudeDegs() > topLeft.getLatitudeDegs()) {
                    topLeft.setLatitudeDegs(loc.getLatitudeDegs());
                }
                if (loc.getLongitudeDegs() < topLeft.getLongitudeDegs()) {
                    topLeft.setLongitudeDegs(loc.getLongitudeDegs());
                    continue;
                }
                if (!(loc.getLongitudeDegs() > bottomRight.getLongitudeDegs())) continue;
                bottomRight.setLongitudeDegs(loc.getLongitudeDegs());
            }
            if (topLeft == null) {
                bw.close();
                throw new Exception("This log doesn't have required data (EstimatedState)");
            }
            pmonitor.setNote("Writing path to file");
            for (String sys : pathsForSystems.keySet()) {
                Vector st = (Vector)pathsForSystems.get(sys);
                bw.write(this.path(st, "Estimated State " + sys, "estate"));
            }
            pmonitor.setProgress(70);
            PlanType plan = null;
            try {
                MissionType mt = LogUtils.generateMission(source);
                if (mt != null) {
                    plan = LogUtils.generatePlan(mt, source);
                }
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
            if (plan != null) {
                pmonitor.setNote("Writing plan");
                bw.write(this.path(plan.planPath(), "Planned waypoints", "plan"));
                pmonitor.setProgress(90);
            }
            topLeft.translatePosition(50.0, -50.0, 0.0);
            bottomRight.translatePosition(-50.0, 50.0, 0.0);
            topLeft.convertToAbsoluteLatLonDepth();
            bottomRight.convertToAbsoluteLatLonDepth();
            pmonitor.setNote("Generating sidescan overlay");
            bw.write(this.sidescanOverlay(out.getParentFile(), 6.0, topLeft, bottomRight, Ducer.both));
            if (this.separateTransducers) {
                bw.write(this.sidescanOverlay(out.getParentFile(), 6.0, topLeft, bottomRight, Ducer.board));
                bw.write(this.sidescanOverlay(out.getParentFile(), 6.0, topLeft, bottomRight, Ducer.starboard));
            }
            pmonitor.setNote("Generating bathymetry overlay");
            String mb = this.multibeamOverlay(out.getParentFile());
            if (!mb.isEmpty()) {
                bw.write(mb);
            } else {
                WorldImage imgDvl = new WorldImage(1, ColorMapFactory.createJetColorMap());
                imgDvl.setMaxVal(20.0);
                imgDvl.setMinVal(3.0);
                it = source.getLsfIndex().getIterator("EstimatedState", 0, 100L);
                for (IMCMessage s : it) {
                    LocationType loc = IMCUtils.parseState(s).getPosition();
                    double alt = s.getDouble("alt");
                    double depth = s.getDouble("depth");
                    if (alt == -1.0 || depth < MRAProperties.minDepthForBathymetry) continue;
                    imgDvl.addPoint(loc, s.getDouble("alt"));
                }
                ImageIO.write((RenderedImage)imgDvl.processData(), "PNG", new File(out.getParent(), "dvl_bath.png"));
                bw.write(this.overlay(new File(out.getParent(), "dvl_bath.png"), "DVL Bathymetry", imgDvl.getSouthWest(), imgDvl.getNorthEast(), this.visibilityForBathymetry));
            }
            bw.write(this.kmlFooter());
            bw.close();
            if (pmonitor.isCanceled()) {
                return "Cancelled by the user";
            }
            pmonitor.close();
            return "Log exported to " + out.getAbsolutePath();
        }
        catch (Exception e) {
            GuiUtils.errorMessage("Error while exporting to KML", "Exception of type " + e.getClass().getSimpleName() + " occurred: " + e.getMessage());
            e.printStackTrace();
            pmonitor.close();
            return null;
        }
    }

    public static void main(String[] args) {
        LocationType loc1 = new LocationType(41.08, -8.2343);
        LocationType loc2 = new LocationType(41.12, -8.2324);
        System.out.println(loc1.getDistanceInMeters(loc2));
        System.out.println(loc2.getDistanceInMeters(loc1));
        double[] res1 = loc2.getOffsetFrom(loc1);
        double[] res2 = WGS84Utilities.WGS84displacement((double)loc1.getLatitudeDegs(), (double)loc1.getLongitudeDegs(), (double)0.0, (double)loc2.getLatitudeDegs(), (double)loc2.getLongitudeDegs(), (double)0.0);
        System.out.println(Math.sqrt(res2[0] * res2[0] + res2[1] * res2[1]));
        System.out.println(Math.sqrt(res1[0] * res1[0] + res1[1] * res1[1]));
    }

    static enum Ducer {
        starboard,
        board,
        both;

    }
}

