/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.exporters;

import com.jmatio.io.MatFileWriter;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLCell;
import com.jmatio.types.MLChar;
import com.jmatio.types.MLDouble;
import com.jmatio.types.MLInt16;
import com.jmatio.types.MLInt64;
import com.jmatio.types.MLInt8;
import com.jmatio.types.MLSingle;
import com.jmatio.types.MLStructure;
import com.jmatio.types.MLUInt64;
import com.jmatio.types.MLUInt8;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import pt.lsts.imc.IMCFieldType;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.llf.LsfLogSource;

@PluginDescription
public class MatExporter
implements MRAExporter {
    @NeptusProperty(editable=false)
    private static final int MAX_PLAINTEXT_RAWDATA_LENGHT = 256;
    @NeptusProperty(editable=false)
    private static final int MAX_ENUMERATED_LENGHT = 50;
    @NeptusProperty(editable=false)
    private static final int MAX_BITFIELD_LENGHT = 256;
    private IMraLogGroup source;
    @NeptusProperty(editable=false)
    private String[] ignoreHeaderFields = new String[]{"sync", "mgid", "size"};
    @NeptusProperty(editable=true)
    private boolean flagWriteHeaderFieldsForInlineMessages = false;
    @NeptusProperty(editable=true)
    private boolean flagWriteEnumeratedAndBitfieldAsString = true;

    public MatExporter(IMraLogGroup source) {
        this.source = source;
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return true;
    }

    @Override
    public String process(IMraLogGroup logSource, ProgressMonitor pmonitor) {
        this.source = logSource;
        PluginUtils.editPluginProperties(this, true);
        Collection logList = this.source.getLsfIndex().getDefinitions().getMessageNames();
        File outFile = new File(this.source.getDir(), "mra/Data.mat");
        outFile.getParentFile().mkdir();
        MatFileWriter writer = new MatFileWriter();
        ArrayList<MLStructure> baseMatLabDataToWrite = new ArrayList<MLStructure>();
        double messageLogPartialPerc = 1.0 / (double)logList.size();
        double progress = 0.0;
        double structFullPrec = 60.0;
        double writeFullPrec = 40.0;
        for (String messageLog : logList) {
            try {
                if (pmonitor != null && pmonitor.isCanceled()) break;
                IMraLog parser = this.source.getLog(messageLog);
                if (parser == null || parser.getNumberOfEntries() == 0) {
                    System.out.println("Reading nothing for " + messageLog);
                    if (pmonitor != null) {
                        pmonitor.setNote(I18n.textf("Reading nothing for %message", messageLog));
                    }
                    progress += 100.0 * messageLogPartialPerc;
                    if (pmonitor == null) continue;
                    pmonitor.setProgress((int)progress);
                    continue;
                }
                System.out.println("Reading " + messageLog);
                if (pmonitor != null) {
                    pmonitor.setNote(I18n.textf("Reading %message", messageLog));
                }
                MLStructure struct = new MLStructure(messageLog, new int[]{1, 1});
                int numEntries = parser.getNumberOfEntries();
                int numInserted = 0;
                LinkedHashMap<String, MLArray> fieldMap = new LinkedHashMap<String, MLArray>();
                IMCMessage m = parser.firstLogEntry();
                while (!pmonitor.isCanceled()) {
                    for (String field : m.getHeader().getFieldNames()) {
                        this.processField(field, m, numEntries, numInserted, fieldMap);
                    }
                    for (String field : m.getFieldNames()) {
                        this.processField(field, m, numEntries, numInserted, fieldMap);
                    }
                    ++numInserted;
                    m = parser.nextLogEntry();
                    if (m != null) continue;
                }
                for (String field : fieldMap.keySet()) {
                    if (pmonitor.isCanceled()) break;
                    struct.setField(field, (MLArray)fieldMap.get(field));
                }
                if (pmonitor.isCanceled()) break;
                progress += 60.0 * messageLogPartialPerc;
                if (pmonitor != null) {
                    pmonitor.setProgress((int)progress);
                }
                baseMatLabDataToWrite.add(struct);
            }
            catch (Exception e) {
                System.out.println("Error processing " + messageLog + ". " + e.getMessage() + "!");
                String txt = I18n.textf("Error processing %message. %error error.", messageLog, e.getMessage());
                if (pmonitor != null) {
                    pmonitor.setNote(txt);
                }
                GuiUtils.errorMessage(MatExporter.class.getSimpleName(), txt);
            }
            catch (OutOfMemoryError e) {
                System.out.println("Error processing " + messageLog + ". OutOfMemoryError!");
                String txt = I18n.textf("Error processing %message. %error error.", messageLog, "OutOfMemoryError");
                if (pmonitor != null) {
                    pmonitor.setNote(txt);
                }
                GuiUtils.errorMessage(MatExporter.class.getSimpleName(), txt);
            }
        }
        System.out.println("Writing data");
        if (pmonitor != null) {
            pmonitor.setNote(I18n.text("Writing data"));
        }
        try {
            writer.write(outFile, baseMatLabDataToWrite);
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getClass().getSimpleName() + " while exporting to MAT: " + e.getMessage();
        }
        progress += 40.0;
        if (pmonitor != null) {
            pmonitor.setProgress((int)progress);
        }
        if (pmonitor != null) {
            pmonitor.setNote(I18n.text("Log exported to MAT successfully"));
            pmonitor.setProgress(100);
        }
        return "Log exported to MAT successfully";
    }

    private void processField(String field, IMCMessage message, int totalEntries, int indexToInsert, LinkedHashMap<String, MLArray> fieldMap) {
        String fieldUnit;
        IMCFieldType filedType = message.getMessageType().getFieldType(field);
        if (filedType == null) {
            filedType = message.getHeader().getMessageType().getFieldType(field);
            for (String ignoreFieldName : this.ignoreHeaderFields) {
                if (!ignoreFieldName.equalsIgnoreCase(field)) continue;
                return;
            }
        }
        if ((fieldUnit = message.getMessageType().getFieldUnits(field)) == null) {
            fieldUnit = message.getHeader().getMessageType().getFieldUnits(field);
        }
        if (this.flagWriteEnumeratedAndBitfieldAsString && ("Enumerated".equalsIgnoreCase(fieldUnit) || "Bitfield".equalsIgnoreCase(fieldUnit))) {
            boolean enumeratedOrBitfield = "Enumerated".equalsIgnoreCase(fieldUnit);
            if (fieldMap.get(field) == null) {
                fieldMap.put(field, (MLArray)new MLChar(field, new int[]{totalEntries, enumeratedOrBitfield ? 50 : 256}, 4, 0));
            }
            String val = message.getString(field);
            ((MLChar)fieldMap.get(field)).set(val == null ? "" : val, indexToInsert);
            return;
        }
        switch (filedType) {
            case TYPE_FP32: {
                if (fieldMap.get(field) == null) {
                    fieldMap.put(field, (MLArray)new MLSingle(field, new int[]{totalEntries, 1}, 7, 0));
                }
                ((MLSingle)fieldMap.get(field)).set((Number)Float.valueOf((float)message.getDouble(field)), indexToInsert);
                break;
            }
            case TYPE_FP64: {
                if (fieldMap.get(field) == null) {
                    fieldMap.put(field, (MLArray)new MLDouble(field, new int[]{totalEntries, 1}));
                }
                ((MLDouble)fieldMap.get(field)).set((Number)message.getDouble(field), indexToInsert);
                break;
            }
            case TYPE_INT8: {
                if (fieldMap.get(field) == null) {
                    fieldMap.put(field, (MLArray)new MLInt8(field, new int[]{totalEntries, 1}));
                }
                ((MLInt8)fieldMap.get(field)).set((Number)((byte)message.getInteger(field)), indexToInsert);
                break;
            }
            case TYPE_INT16: {
                if (fieldMap.get(field) == null) {
                    fieldMap.put(field, (MLArray)new MLInt16(field, new int[]{totalEntries, 1}));
                }
                ((MLInt16)fieldMap.get(field)).set((Number)((short)message.getInteger(field)), indexToInsert);
                break;
            }
            case TYPE_INT32: 
            case TYPE_INT64: {
                if (fieldMap.get(field) == null) {
                    fieldMap.put(field, (MLArray)new MLInt64(field, new int[]{totalEntries, 1}));
                }
                ((MLInt64)fieldMap.get(field)).set((Number)message.getLong(field), indexToInsert);
                break;
            }
            case TYPE_UINT8: {
                if (fieldMap.get(field) == null) {
                    fieldMap.put(field, (MLArray)new MLUInt8(field, new int[]{totalEntries, 1}));
                }
                ((MLUInt8)fieldMap.get(field)).set((Number)((byte)message.getInteger(field)), indexToInsert);
                break;
            }
            case TYPE_UINT16: 
            case TYPE_UINT32: {
                if (fieldMap.get(field) == null) {
                    fieldMap.put(field, (MLArray)new MLUInt64(field, new int[]{totalEntries, 1}));
                }
                ((MLUInt64)fieldMap.get(field)).set((Number)message.getLong(field), indexToInsert);
                break;
            }
            case TYPE_MESSAGE: {
                if (fieldMap.get(field) == null) {
                    fieldMap.put(field, (MLArray)new MLCell(field, new int[]{totalEntries, 1}));
                }
                MLStructure struct = new MLStructure(field, new int[]{1, 1});
                IMCMessage inlineMsg = message.getMessage(field);
                LinkedHashMap<String, MLArray> fieldMessageListMap = new LinkedHashMap<String, MLArray>();
                if (inlineMsg != null) {
                    if (this.flagWriteHeaderFieldsForInlineMessages) {
                        for (String fieldInline : inlineMsg.getHeader().getFieldNames()) {
                            this.processField(fieldInline, inlineMsg, 1, 0, fieldMessageListMap);
                        }
                    }
                    for (String fieldInline : inlineMsg.getFieldNames()) {
                        this.processField(fieldInline, inlineMsg, 1, 0, fieldMessageListMap);
                    }
                }
                for (String fieldInline : fieldMessageListMap.keySet()) {
                    struct.setField(fieldInline, (MLArray)fieldMessageListMap.get(fieldInline));
                }
                ((MLCell)fieldMap.get(field)).set((MLArray)struct, indexToInsert);
                break;
            }
            case TYPE_MESSAGELIST: {
                if (fieldMap.get(field) == null) {
                    fieldMap.put(field, (MLArray)new MLCell(field, new int[]{totalEntries, 1}));
                }
                Vector inlineMsgList = message.getMessageList(field);
                MLCell cell = new MLCell(field, new int[]{inlineMsgList.size(), inlineMsgList.size() != 0 ? 1 : 0});
                int numInserted = 0;
                for (IMCMessage inlineMsg : inlineMsgList) {
                    MLStructure struct = new MLStructure(field, new int[]{1, 1});
                    LinkedHashMap<String, MLArray> fieldMessageListMap = new LinkedHashMap<String, MLArray>();
                    if (inlineMsg != null) {
                        if (this.flagWriteHeaderFieldsForInlineMessages) {
                            for (String fieldInline : inlineMsg.getHeader().getFieldNames()) {
                                this.processField(fieldInline, inlineMsg, 1, 0, fieldMessageListMap);
                            }
                        }
                        for (String fieldInline : inlineMsg.getFieldNames()) {
                            this.processField(fieldInline, inlineMsg, 1, 0, fieldMessageListMap);
                        }
                    }
                    for (String fieldInline : fieldMessageListMap.keySet()) {
                        struct.setField(fieldInline, (MLArray)fieldMessageListMap.get(fieldInline));
                    }
                    cell.set((MLArray)struct, numInserted);
                    ++numInserted;
                }
                ((MLCell)fieldMap.get(field)).set((MLArray)cell, indexToInsert);
                break;
            }
            default: {
                if (fieldMap.get(field) == null) {
                    fieldMap.put(field, (MLArray)new MLChar(field, new int[]{totalEntries, 256}, 4, 0));
                }
                String val = message.getAsString(field);
                ((MLChar)fieldMap.get(field)).set(val == null ? "" : val, indexToInsert);
            }
        }
    }

    @Override
    public String getName() {
        return I18n.text("MatLab format .MAT");
    }

    public static void main(String[] args) throws Exception {
        LsfLogSource source = new LsfLogSource(new File("/home/pdias/Desktop/Sunfish-CTD/20140513/135733_sample_front/Data.lsf"), null);
        MatExporter me = new MatExporter(source);
        me.process(source, new ProgressMonitor(null, "", "", 0, 100));
    }
}

