/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.exporters;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ProgressMonitor;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.llf.LsfLogSource;

@PluginDescription
public class PCDExporter
implements MRAExporter {
    public double minLat = 180.0;
    public double maxLat = -180.0;
    public double minLon = 360.0;
    public double maxLon = -360.0;
    public double minHeight = 1000.0;
    public double maxHeight = -1.0;
    LocationType topLeftLT;
    LocationType bottomRightLT;
    File f;
    File output;
    IMraLogGroup source;

    public PCDExporter(IMraLogGroup source) {
        this.source = source;
        File baseFolder = source.getFile(".").getParentFile();
        this.f = source.getFile("multibeam.83P");
        this.output = new File(baseFolder, "multibeam.pcd");
    }

    @Override
    public String process(IMraLogGroup source, ProgressMonitor pmonitor) {
        int curPosition = 0;
        int numBeams = 0;
        int pingCount = 0;
        LinkedList pointList = new LinkedList();
        IMraLog esLog = source.getLog("EstimatedState");
        esLog.firstLogEntry();
        try {
            short pingTotalSize;
            MappedByteBuffer b;
            RandomAccessFile buf = new RandomAccessFile(this.f, "r");
            RandomAccessFile out = new RandomAccessFile(this.output, "rw");
            FileInputStream fis = new FileInputStream(this.f);
            FileChannel channel = fis.getChannel();
            Object dataBuffer = null;
            int[] data = null;
            boolean c = false;
            byte[] timestampBuffer = new byte[25];
            byte[] millisBuffer = new byte[5];
            int month = 0;
            Pattern pTimeStamp = Pattern.compile("([0-9]{2})-([A-Z]{3})-([0-9]{4})\u0000([0-9]{2}):([0-9]{2}):([0-9]{2})");
            Calendar cal = Calendar.getInstance();
            LocationType tempLt = new LocationType();
            double lat = 0.0;
            double lon = 0.0;
            int numOfEntries = 0;
            NeptusLog.pub().info((Object)"<###>Reading 83P Profile Information");
            while ((long)curPosition < channel.size()) {
                b = channel.map(FileChannel.MapMode.READ_ONLY, curPosition, 256L);
                pingTotalSize = b.getShort(4);
                numBeams = b.getShort(70);
                numOfEntries += numBeams;
                curPosition += pingTotalSize;
            }
            NeptusLog.pub().info((Object)("<###>Final number of entries: " + numOfEntries));
            out.writeBytes("VERSION .7\n");
            out.writeBytes("FIELDS x y z\n");
            out.writeBytes("SIZE 4 4 4\n");
            out.writeBytes("TYPE F F F\n");
            out.writeBytes("COUNT 1 1 1\n");
            out.writeBytes("WIDTH " + numOfEntries + "\n");
            out.writeBytes("HEIGHT 1\n");
            out.writeBytes("VIEWPOINT 0 0 0 1 0 0 0\n");
            out.writeBytes("POINTS " + numOfEntries + "\n");
            out.writeBytes("DATA ascii\n");
            curPosition = 0;
            NeptusLog.pub().info((Object)"<###>Processing Information");
            while ((long)curPosition < channel.size()) {
                b = channel.map(FileChannel.MapMode.READ_ONLY, curPosition, 256L);
                pingTotalSize = b.getShort(4);
                ((ByteBuffer)b).position(8);
                b.get(timestampBuffer);
                String timestampStr = new String(timestampBuffer);
                numBeams = b.getShort(70);
                ((ByteBuffer)b).position(112);
                b.get(millisBuffer);
                String millisStr = new String(millisBuffer);
                Matcher m = pTimeStamp.matcher(timestampStr);
                m.find();
                if (m.group(2).equalsIgnoreCase("JAN")) {
                    month = 0;
                }
                if (m.group(2).equalsIgnoreCase("FEB")) {
                    month = 1;
                }
                if (m.group(2).equalsIgnoreCase("MAR")) {
                    month = 2;
                }
                if (m.group(2).equalsIgnoreCase("APR")) {
                    month = 3;
                }
                if (m.group(2).equalsIgnoreCase("MAY")) {
                    month = 4;
                }
                if (m.group(2).equalsIgnoreCase("JUN")) {
                    month = 5;
                }
                if (m.group(2).equalsIgnoreCase("JUL")) {
                    month = 6;
                }
                if (m.group(2).equalsIgnoreCase("AUG")) {
                    month = 7;
                }
                if (m.group(2).equalsIgnoreCase("SEP")) {
                    month = 8;
                }
                if (m.group(2).equalsIgnoreCase("OCT")) {
                    month = 9;
                }
                if (m.group(2).equalsIgnoreCase("NOV")) {
                    month = 10;
                }
                if (m.group(2).equalsIgnoreCase("DEC")) {
                    month = 11;
                }
                cal.set(Integer.valueOf(m.group(3)), month, Integer.valueOf(m.group(1)), Integer.valueOf(m.group(4)), Integer.valueOf(m.group(5)), Integer.valueOf(m.group(6)));
                cal.set(14, Integer.valueOf(millisStr.substring(1, 4)));
                IMCMessage esMsg = esLog.getEntryAtOrAfter(cal.getTimeInMillis());
                double heading = Math.toDegrees(esMsg.getDouble("psi"));
                if (lat != esMsg.getDouble("lat") && lon != esMsg.getDouble("lon")) {
                    lat = esMsg.getDouble("lat");
                    lon = esMsg.getDouble("lon");
                }
                numBeams = b.getShort(70);
                short samplesPerBeam = b.getShort(72);
                short acousticRange = b.getShort(79);
                short rangeResolution = b.getShort(85);
                byte intensity = b.get(117);
                float altitude = b.getFloat(133);
                short sectorSize = b.getShort(74);
                float startAngle = (float)b.getShort(76) / 100.0f - 180.0f;
                float angleIncrement = (float)b.get(78) / 100.0f;
                if (data == null) {
                    data = new int[numBeams];
                }
                b = channel.map(FileChannel.MapMode.READ_ONLY, curPosition + 256, numBeams * 2);
                for (int i = 0; i < numBeams; ++i) {
                    data[i] = (b.get(2 * i) << 8 & 0xFF) + (b.get(2 * i + 1) & 0xFF);
                    float range = (float)(data[i] * rangeResolution) / 1000.0f;
                    double angle = startAngle + angleIncrement * (float)i;
                    double foo = (double)range * Math.cos(Math.toRadians(angle));
                    double height = (double)range * Math.cos(Math.toRadians(angle)) + esMsg.getDouble("depth");
                    double x = (double)range * Math.sin(Math.toRadians(angle));
                    double theta = -heading;
                    double[] offHeight = new double[]{esMsg.getDouble("x") + x * Math.cos(Math.toRadians(theta)), esMsg.getDouble("y") + x * Math.sin(Math.toRadians(theta)), height};
                    if (height < this.minHeight) {
                        this.minHeight = height;
                    }
                    if (height > this.maxHeight) {
                        this.maxHeight = height;
                    }
                    out.writeBytes(offHeight[0] + " " + offHeight[1] + " " + offHeight[2] + "\n");
                }
                ++pingCount;
                curPosition += pingTotalSize;
            }
            NeptusLog.pub().info((Object)"<###>Wrinting PCD file");
            buf.close();
            fis.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getClass().getSimpleName() + " while exporting to PCD: " + e.getMessage();
        }
        return "Log exported sucessfully";
    }

    public static void main(String[] args) {
        try {
            LsfLogSource source = new LsfLogSource(new File(args[0] + "/Data.lsf"), null);
            PCDExporter pcde = new PCDExporter(source);
            pcde.process(source, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return source.getFile("multibeam.83P") != null;
    }

    @Override
    public String getName() {
        return I18n.text("83P to PCD");
    }
}

