/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.exporters;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.ProgressMonitor;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.mra.api.SidescanLine;
import pt.lsts.neptus.mra.api.SidescanParameters;
import pt.lsts.neptus.mra.api.SidescanParser;
import pt.lsts.neptus.mra.api.SidescanParserFactory;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.MraVehiclePosHud;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;

@PluginDescription
public class SidescanImageExporter
implements MRAExporter {
    SidescanParser parser = null;
    IMraLogGroup source = null;
    @NeptusProperty
    public double timeVariableGain = 300.0;
    @NeptusProperty
    public double normalization = 0.1;
    @NeptusProperty
    public double swathLength = 1.0;
    @NeptusProperty
    public int imageWidth = 1920;
    @NeptusProperty
    public int imageHeight = 1080;
    @NeptusProperty
    public int hudSize = 250;

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        this.parser = SidescanParserFactory.build(source);
        return this.parser != null && !this.parser.getSubsystemList().isEmpty();
    }

    public SidescanImageExporter(IMraLogGroup source) {
        this.source = source;
    }

    @Override
    public String process(IMraLogGroup source, ProgressMonitor pmonitor) {
        File out;
        PluginUtils.editPluginProperties(this, true);
        MraVehiclePosHud hud = new MraVehiclePosHud(source, this.hudSize, this.hudSize);
        hud.setPathColor(Color.white);
        SidescanParameters params = new SidescanParameters(this.normalization, this.timeVariableGain);
        ColorMap cmap = ColorMapFactory.createBronzeColormap();
        long start = this.parser.firstPingTimestamp();
        long end = this.parser.lastPingTimestamp();
        int sys = this.parser.getSubsystemList().get(0);
        pmonitor.setMinimum(0);
        pmonitor.setMaximum((int)((end - start) / 1000L));
        try {
            pmonitor.setNote("Creating output dir");
            out = new File(source.getFile("mra"), "sss_images");
            out.mkdirs();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return e.getMessage();
        }
        int ypos = 0;
        int image_num = 1;
        ArrayList<Object> lines = new ArrayList();
        BufferedImage img = null;
        int width = this.imageWidth;
        int height = 1000;
        double startTime = (double)start / 1000.0;
        for (long time = start; time < end - 1000L; time += 1000L) {
            if (pmonitor.isCanceled()) {
                return "Cancelled by the user";
            }
            int d = 0;
            while (lines.isEmpty() && d < 10000) {
                lines = this.parser.getLinesBetween(time, time + (long)(d += 1000), sys, params);
            }
            if (lines.isEmpty()) break;
            if (img == null) {
                width = Math.min(this.imageWidth, ((SidescanLine)lines.get((int)0)).xsize);
                height = this.imageHeight;
                img = new BufferedImage(width, height, 2);
                img.getGraphics().clearRect(0, 0, img.getWidth(), img.getHeight());
            }
            BufferedImage tmp = new BufferedImage(((SidescanLine)lines.get((int)0)).data.length, 1, 1);
            for (SidescanLine sidescanLine : lines) {
                pmonitor.setNote("Generating image " + image_num);
                pmonitor.setProgress((int)((time - start) / 1000L));
                if (ypos >= height || time == end) {
                    double endTime = (double)time / 1000.0;
                    BufferedImage hudImg = hud.getImage(startTime, endTime, 1.0);
                    img.getGraphics().drawImage(hudImg, 10, height - this.hudSize - 10, this.hudSize - 10, height - 10, 0, 0, this.hudSize, this.hudSize, null);
                    try {
                        ImageIO.write((RenderedImage)img, "PNG", new File(out, "sss_" + image_num + ".png"));
                        img.getGraphics().clearRect(0, 0, img.getWidth(), img.getHeight());
                        ypos = 0;
                        ++image_num;
                    }
                    catch (Exception e) {
                        NeptusLog.pub().error((Object)e);
                        return e.getMessage();
                    }
                    startTime = endTime;
                }
                for (int c = 0; c < sidescanLine.data.length; ++c) {
                    tmp.setRGB(c, 0, cmap.getColor(sidescanLine.data[c]).getRGB());
                }
                img.getGraphics().drawImage(tmp, 0, ypos, width - 1, ypos + 1, 0, 0, tmp.getWidth(), tmp.getHeight(), null);
                ++ypos;
            }
        }
        BufferedImage hudImg = hud.getImage(startTime, (double)end / 1000.0, 1.0);
        img.getGraphics().drawImage(hudImg, 10, height - this.hudSize - 10, this.hudSize - 10, height - 10, 0, 0, this.hudSize, this.hudSize, null);
        try {
            ImageIO.write((RenderedImage)img, "PNG", new File(out, "sss_" + image_num + ".png"));
            ypos = 0;
            ++image_num;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return e.getMessage();
        }
        pmonitor.close();
        return "OK";
    }

    @Override
    public String getName() {
        return "Sidescan Images";
    }
}

