/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.exporters;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.ProgressMonitor;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.imc.ImcStringDefs;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.util.FileUtil;

@PluginDescription
public class UpdatedImcExporter
implements MRAExporter {
    public UpdatedImcExporter(IMraLogGroup source) {
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return true;
    }

    @Override
    public String process(IMraLogGroup source, ProgressMonitor pmonitor) {
        IMCDefinition updated = IMCDefinition.getInstance();
        LsfIndex index = source.getLsfIndex();
        int max = index.getNumberOfMessages();
        pmonitor.setMaximum(max);
        pmonitor.setProgress(0);
        String version = updated.getVersion();
        File out = new File(source.getDir(), "mra/imc_" + version);
        out.mkdirs();
        try {
            FileUtil.saveToFile(new File(source.getDir(), "mra/imc_" + version + "/IMC.xml").getAbsolutePath(), ImcStringDefs.getDefinitions());
            IMCOutputStream ios = new IMCOutputStream((OutputStream)new FileOutputStream(new File(out, "Data.lsf")));
            for (int i = 0; i < index.getNumberOfMessages(); ++i) {
                if (pmonitor.isCanceled()) {
                    return I18n.text("Cancelled by the user");
                }
                pmonitor.setProgress(i);
                pmonitor.setNote(I18n.textf("Message %num of %total", i, max));
                if (updated.getMessageName(index.typeOf(i)) != null) {
                    IMCMessage msg = updated.create(updated.getMessageName(index.typeOf(i)), new Object[0]);
                    msg.setValues(index.getMessage(i).getValues());
                    msg.setTimestamp(index.timeOf(i));
                    msg.setSrc(index.sourceOf(i));
                    msg.setSrcEnt(index.entityOf(i));
                    ios.writeMessage(msg);
                    continue;
                }
                NeptusLog.pub().warn((Object)("Skipping unrecognized message of type " + index.typeOf(i)));
            }
            ios.close();
            pmonitor.close();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return "Error while converting: " + e.getMessage();
        }
        return "Log writen to " + out.getAbsolutePath();
    }

    @Override
    public String getName() {
        return "Log using IMC " + IMCDefinition.getInstance().getVersion();
    }
}

