/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.exporters;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mra.api.CorrectedPosition;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.VideoCreator;

@PluginDescription
public class VideoLegendExporter
implements MRAExporter {
    private static final int width = 120;
    private static final int height = 140;
    protected SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    protected Integer legendWidth;

    public VideoLegendExporter(IMraLogGroup source) {
        this.sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.legendWidth = null;
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return true;
    }

    @Override
    public String process(IMraLogGroup source, ProgressMonitor pmonitor) {
        CorrectedPosition corPos = new CorrectedPosition(source);
        VideoCreator creator = null;
        try {
            creator = new VideoCreator(new File(source.getDir(), "overlay.mp4"), 120, 140);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return "Not able to create video";
        }
        pmonitor.setNote(I18n.text("Starting up"));
        BufferedImage tmp = new BufferedImage(120, 140, 2);
        Graphics2D g = tmp.createGraphics();
        int count = 0;
        long startTime = corPos.getPositions().iterator().next().getTime();
        int size = corPos.getPositions().size();
        pmonitor.setMaximum(size);
        for (SystemPositionAndAttitude pos : corPos.getPositions()) {
            pmonitor.setNote(I18n.text("Generating frame " + (count + 1) + " of " + size));
            if (pmonitor.isCanceled()) break;
            try {
                this.drawLegend(pos, g);
                pmonitor.setProgress(count++);
                creator.addFrame(tmp, pos.getTime() - startTime);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        creator.closeStreams();
        pmonitor.close();
        return I18n.textf("Video legend exported to %f", new File(source.getDir(), "overlay.mp4").getAbsolutePath());
    }

    protected void drawLegend(SystemPositionAndAttitude state, Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(new Font("Arial", 1, 14));
        if (state == null) {
            return;
        }
        long timeUTC = state.getTime();
        String depth = GuiUtils.getNeptusDecimalFormat(1).format(state.getPosition().getDepth());
        String alt = Double.isNaN(state.getW()) ? "N/A" : GuiUtils.getNeptusDecimalFormat(1).format(state.getW());
        String speed = GuiUtils.getNeptusDecimalFormat(1).format(state.getU());
        int roll = (int)Math.toDegrees(state.getRoll());
        int pitch = (int)Math.toDegrees(state.getPitch());
        int yaw = (int)Math.toDegrees(state.getYaw());
        String lat = CoordinateUtil.latitudeAsString(state.getPosition().getLatitudeDegs(), false, 2);
        String lon = CoordinateUtil.longitudeAsString(state.getPosition().getLongitudeDegs(), false, 2);
        Vector<String> details = new Vector<String>();
        details.add(lat);
        details.add(lon);
        details.add(I18n.text("Time") + ": " + this.sdf.format(new Date(timeUTC)));
        details.add(I18n.text("Depth") + ": " + depth);
        details.add(I18n.text("Altitude") + ": " + alt);
        details.add(I18n.text("Roll") + ": " + roll);
        details.add(I18n.text("Pitch") + ": " + pitch);
        details.add(I18n.text("Yaw") + ": " + yaw);
        details.add(I18n.text("Speed") + ": " + speed);
        g.setColor(new Color(32, 32, 64));
        g.fill(new Rectangle2D.Double(0.0, 0.0, 120.0, 140.0));
        g.setColor(Color.white);
        int y = 15;
        while (!details.isEmpty()) {
            g.drawString((String)details.firstElement(), 5, y);
            details.remove(0);
            y += 15;
        }
    }

    protected int getLegendWidth(Vector<String> strs, Graphics2D g) {
        if (this.legendWidth == null) {
            int maxSize = 0;
            for (String s : strs) {
                Rectangle2D r = g.getFontMetrics(g.getFont()).getStringBounds(s, g);
                if (!(r.getWidth() > (double)maxSize)) continue;
                maxSize = (int)Math.ceil(r.getWidth());
            }
            this.legendWidth = maxSize;
        }
        return this.legendWidth;
    }

    @Override
    public String getName() {
        return "Video Legend";
    }
}

