/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.exporters;

import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.MediaToolAdapter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.Temperature;
import pt.lsts.imc.lsf.IndexScanner;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.MraVehiclePosHud;
import pt.lsts.neptus.types.coord.LocationType;

public class VideoOverlayExporter
implements MRAExporter {
    File videoIn = null;
    File videoOut = null;

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return source.getLsfIndex().containsMessagesOfType(new String[]{"EstimatedState"});
    }

    public VideoOverlayExporter(IMraLogGroup source) {
    }

    @Override
    public String process(IMraLogGroup source, ProgressMonitor pmonitor) {
        JFileChooser chooser = new JFileChooser();
        int op = chooser.showOpenDialog(null);
        if (op != 0) {
            return "User cancelled the operation";
        }
        this.videoIn = chooser.getSelectedFile();
        this.videoOut = new File(chooser.getSelectedFile().getAbsolutePath() + ".out.avi");
        String time = JOptionPane.showInputDialog("Enter the log time, in seconds when the video starts");
        double startTime = 0.0;
        try {
            startTime = Double.parseDouble(time);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Given time was not understood";
        }
        IMediaReader reader = ToolFactory.makeReader((String)this.videoIn.toString());
        reader.setBufferedImageTypeToGenerate(5);
        IMediaWriter writer = ToolFactory.makeWriter((String)this.videoOut.toString(), (IMediaReader)reader);
        long totalTime = reader.getContainer().getDuration();
        pmonitor.setMaximum((int)totalTime / 1000000);
        double start = source.getLsfIndex().getStartTime() + startTime;
        TimeStampTool addTimeStamp = new TimeStampTool(start, source, pmonitor);
        reader.addListener((IMediaListener)addTimeStamp);
        addTimeStamp.addListener((IMediaListener)writer);
        writer.addListener((IMediaListener)ToolFactory.makeViewer());
        while (reader.readPacket() == null) {
        }
        return "done";
    }

    @Override
    public String getName() {
        return "Video Overlay";
    }

    static class TimeStampTool
    extends MediaToolAdapter {
        private final ProgressMonitor pmonitor;
        private final double timeOffset;
        private final IndexScanner scanner;
        private final IndexScanner tempScanner;
        private final MraVehiclePosHud hud;
        JLabel lbl = new JLabel("<html>?</html>");

        public TimeStampTool(double timeOffset, IMraLogGroup log, ProgressMonitor pmonitor) {
            this.pmonitor = pmonitor;
            this.timeOffset = timeOffset;
            this.scanner = new IndexScanner(log.getLsfIndex());
            this.tempScanner = new IndexScanner(log.getLsfIndex());
            this.hud = new MraVehiclePosHud(log, 200, 200);
            this.lbl.setBounds(0, 0, 200, 190);
            this.lbl.setOpaque(false);
        }

        public void onVideoPicture(IVideoPictureEvent event) {
            Graphics2D g = event.getImage().createGraphics();
            this.pmonitor.setProgress((int)(event.getPicture().getTimeStamp() / 1000000L));
            try {
                this.scanner.setTime(this.timeOffset + (double)event.getPicture().getTimeStamp() / 1000000.0);
                EstimatedState state = (EstimatedState)this.scanner.next(EstimatedState.class);
                this.tempScanner.setTime(this.timeOffset + (double)event.getPicture().getTimeStamp() / 1000000.0);
                Temperature temp = (Temperature)this.tempScanner.next(Temperature.class, "CTD");
                if (state != null) {
                    String depth = String.format("%.2f", state.getDepth());
                    String roll = String.format("%.1f", Math.toDegrees(state.getPhi()));
                    String pitch = String.format("%.1f", Math.toDegrees(state.getTheta()));
                    String yaw = String.format("%.1f", Math.toDegrees(state.getPsi()));
                    String t = String.format("%.2f", temp.getValue());
                    LocationType loc = IMCUtils.parseLocation((IMCMessage)state);
                    loc.convertToAbsoluteLatLonDepth();
                    this.lbl.setText("<html><h3>" + loc.getLatitudeAsPrettyString() + "<br>" + loc.getLongitudeAsPrettyString() + "</h3>" + "<h3>Depth: " + depth + " m<br>" + "Roll: " + roll + " \u00ba<br>" + "Pitch: " + pitch + " \u00ba<br>" + "Yaw: " + yaw + " \u00ba<br>" + "Temp.: " + t + " \u00baC</h3></html>");
                    g.drawImage((Image)this.hud.getImage(this.timeOffset + (double)event.getPicture().getTimeStamp() / 1000000.0), event.getPicture().getWidth() - 210, 10, null);
                    g.translate(10, 10);
                    this.lbl.setForeground(Color.black);
                    this.lbl.paint(g);
                    this.lbl.setForeground(Color.white);
                    g.translate(-2, -2);
                    this.lbl.paint(g);
                }
            }
            catch (Exception e) {
                return;
            }
            super.onVideoPicture(event);
        }
    }
}

