/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.exporters;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import javax.swing.ProgressMonitor;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.api.BathymetryParser;
import pt.lsts.neptus.mra.api.BathymetryParserFactory;
import pt.lsts.neptus.mra.api.BathymetrySwath;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.importers.IMraLogGroup;

public class XTFExporter
implements MRAExporter {
    IMraLogGroup source;
    BathymetryParser parser = null;
    File outFile;
    RandomAccessFile raf;
    FileChannel chan;
    ByteBuffer buf;

    public XTFExporter(IMraLogGroup source) {
        this.source = source;
        try {
            this.parser = BathymetryParserFactory.build(source);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return this.parser != null;
    }

    @Override
    public String process(IMraLogGroup source, ProgressMonitor pmonitor) {
        try {
            BathymetrySwath swath;
            this.outFile = new File(source.getFile("Data.lsf").getParent() + "/mra/Data.xtf");
            this.raf = new RandomAccessFile(this.outFile, "rw");
            this.chan = this.raf.getChannel();
            this.buf = this.chan.map(FileChannel.MapMode.READ_WRITE, 0L, 1024L);
            this.buf.order(ByteOrder.LITTLE_ENDIAN);
            this.buf.put((byte)123);
            this.buf.put((byte)1);
            this.writeString("KleinXlt");
            this.writeString("4.0");
            this.buf.putShort(34, (short)0);
            this.buf.position(164);
            this.buf.putShort((short)3);
            this.buf.putShort((short)0);
            this.buf.putShort((short)1);
            this.buf.position(256);
            this.buf.put((byte)3);
            this.buf.putShort((short)4);
            this.parser.rewind();
            int swathsRead = 0;
            while ((swath = this.parser.nextSwath()) != null) {
                int swathSize = 64;
                this.buf = this.chan.map(FileChannel.MapMode.READ_WRITE, 1024 + swathsRead * swathSize, swathSize);
                this.buf.putShort((short)-1330);
                this.buf.put((byte)42);
                this.buf.putInt(64);
                this.buf.putDouble(33, swath.getPose().getPosition().getLatitudeDegs());
                this.buf.putDouble(41, swath.getPose().getPosition().getLongitudeDegs());
                this.buf.putDouble(49, swath.getPose().getAltitude());
            }
            this.raf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return I18n.text("XTF conversion done.");
    }

    public void writeString(String s) {
        for (char c : s.toCharArray()) {
            this.buf.put((byte)c);
        }
    }

    @Override
    public String getName() {
        return I18n.text("XTF Exporter");
    }
}

