/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.importers.deltat;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeltaTHeader {
    public String fileType;
    public byte fileVersion;
    public short numBytes;
    public short numBeams;
    public short samplesPerBeam;
    public short sectorSize;
    public float startAngle;
    public short rangeResolution;
    public float angleIncrement;
    public short range;
    public double speed;
    public long timestamp;
    public boolean hasIntensity;
    public float soundVelocity;
    private static Calendar cal;
    private static Pattern pTimeStamp;
    private Matcher m;

    public DeltaTHeader() {
        pTimeStamp = Pattern.compile("([0-9]{2})-([A-Z]{3})-([0-9]{4})\u0000([0-9]{2}):([0-9]{2}):([0-9]{2})");
        cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void parse(ByteBuffer b) {
        this.fileType = this.parseFileType(b);
        this.fileVersion = b.get(3);
        int month = 0;
        byte[] timestampBuf = new byte[25];
        byte[] millisBuf = new byte[5];
        this.numBytes = b.getShort(4);
        this.numBeams = b.getShort(70);
        this.samplesPerBeam = b.getShort(72);
        this.sectorSize = b.getShort(74);
        this.startAngle = (float)b.getShort(76) / 100.0f - 180.0f;
        this.angleIncrement = (float)b.get(78) / 100.0f;
        this.range = b.getShort(79);
        this.soundVelocity = this.parseSoundVelocity(b);
        this.rangeResolution = b.getShort(85);
        this.speed = this.convertKnotsToMetersPerSecond((double)b.get(61) / 10.0);
        byte hasInt = b.get(117);
        this.hasIntensity = hasInt == 1;
        b.position(8);
        b.get(timestampBuf, 0, 25);
        b.position(112);
        b.get(millisBuf, 0, 5);
        String timestampStr = new String(timestampBuf);
        String millisStr = new String(millisBuf);
        this.m = pTimeStamp.matcher(timestampStr);
        this.m.find();
        if (this.m.group(2).equalsIgnoreCase("JAN")) {
            month = 0;
        } else if (this.m.group(2).equalsIgnoreCase("FEB")) {
            month = 1;
        } else if (this.m.group(2).equalsIgnoreCase("MAR")) {
            month = 2;
        } else if (this.m.group(2).equalsIgnoreCase("APR")) {
            month = 3;
        } else if (this.m.group(2).equalsIgnoreCase("MAY")) {
            month = 4;
        } else if (this.m.group(2).equalsIgnoreCase("JUN")) {
            month = 5;
        } else if (this.m.group(2).equalsIgnoreCase("JUL")) {
            month = 6;
        } else if (this.m.group(2).equalsIgnoreCase("AUG")) {
            month = 7;
        } else if (this.m.group(2).equalsIgnoreCase("SEP")) {
            month = 8;
        } else if (this.m.group(2).equalsIgnoreCase("OCT")) {
            month = 9;
        } else if (this.m.group(2).equalsIgnoreCase("NOV")) {
            month = 10;
        } else if (this.m.group(2).equalsIgnoreCase("DEC")) {
            month = 11;
        }
        cal.set(Integer.valueOf(this.m.group(3)), month, Integer.valueOf(this.m.group(1)), Integer.valueOf(this.m.group(4)), Integer.valueOf(this.m.group(5)), Integer.valueOf(this.m.group(6)));
        cal.set(14, Integer.valueOf(millisStr.substring(1, 4)));
        this.timestamp = cal.getTimeInMillis();
    }

    private float parseSoundVelocity(ByteBuffer b) {
        byte vel83 = b.get(83);
        if (!DeltaTHeader.isBitSet(vel83, 7).booleanValue()) {
            return 1500.0f;
        }
        byte vel84 = b.get(84);
        float sv = (float)((double)((vel83 & 0x7F) << 8 | vel84) / 10.0);
        return sv;
    }

    private double convertKnotsToMetersPerSecond(double speedKnots) {
        return speedKnots * 0.51444;
    }

    private static Boolean isBitSet(byte b, int bit) {
        return (b & 1 << bit) != 0;
    }

    private String parseFileType(ByteBuffer b) {
        byte[] byteBuf = new byte[]{b.get(0), b.get(1), b.get(2)};
        String fileTypeStr = null;
        try {
            fileTypeStr = new String(byteBuf, 0, byteBuf.length, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return fileTypeStr;
    }
}

