/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.importers.deltat;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mra.MRAProperties;
import pt.lsts.neptus.mra.api.BathymetryInfo;
import pt.lsts.neptus.mra.api.BathymetryParser;
import pt.lsts.neptus.mra.api.BathymetryPoint;
import pt.lsts.neptus.mra.api.BathymetrySwath;
import pt.lsts.neptus.mra.api.CorrectedPosition;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.importers.deltat.DeltaTHeader;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.llf.LsfLogSource;

public class DeltaTParser
implements BathymetryParser {
    private final IMraLogGroup source;
    private CorrectedPosition position = null;
    private boolean isLoaded = false;
    private File file = null;
    private FileInputStream fis;
    private final FileChannel channel;
    private ByteBuffer buf;
    private long curPos = 0L;
    private DeltaTHeader header;
    public BathymetryInfo info;
    private int realNumberOfBeams = 0;
    private int totalNumberPoints = 0;
    private boolean hasIntensity = false;

    public DeltaTParser(IMraLogGroup source) {
        this.source = source;
        this.file = DeltaTParser.findDataSource(source);
        try {
            this.fis = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.channel = this.fis.getChannel();
        this.initialize();
    }

    private void initialize() {
        File f = new File(this.source.getFile("Data.lsf").getParent() + "/mra/bathy.info");
        File folder = new File(this.source.getFile("Data.lsf").getParent() + "/mra/");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!f.exists()) {
            BathymetrySwath bs;
            this.info = new BathymetryInfo();
            double maxLat = -90.0;
            double minLat = 90.0;
            double maxLon = -180.0;
            double minLon = 180.0;
            while ((bs = this.nextSwath()) != null) {
                LocationType loc = bs.getPose().getPosition().convertToAbsoluteLatLonDepth();
                double lat = loc.getLatitudeDegs();
                double lon = loc.getLongitudeDegs();
                maxLat = Math.max(lat, maxLat);
                maxLon = Math.max(lon, maxLon);
                minLat = Math.min(lat, minLat);
                minLon = Math.min(lon, minLon);
                for (int c = 0; c < bs.getNumBeams(); ++c) {
                    BathymetryPoint p = bs.getData()[c];
                    this.info.minDepth = Math.min(this.info.minDepth, p.depth);
                    this.info.maxDepth = Math.max(this.info.maxDepth, p.depth);
                }
                this.totalNumberPoints += bs.getNumBeams();
                this.realNumberOfBeams = 0;
            }
            this.info.topLeft = new LocationType(maxLat, minLon).translatePosition(this.info.maxDepth, -this.info.maxDepth, 0.0).convertToAbsoluteLatLonDepth();
            this.info.bottomRight = new LocationType(minLat, maxLon).translatePosition(-this.info.maxDepth, this.info.maxDepth, 0.0).convertToAbsoluteLatLonDepth();
            this.info.totalNumberOfPoints = this.totalNumberPoints;
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(f));
                out.writeObject(this.info);
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.curPos = 0L;
        } else {
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(f));
                this.info = (BathymetryInfo)in.readObject();
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isLoaded = true;
    }

    public static boolean canBeApplied(IMraLogGroup source) {
        File file = DeltaTParser.findDataSource(source);
        return file != null && file.exists();
    }

    public static File findDataSource(IMraLogGroup source) {
        if (source.getFile("data.83P") != null) {
            return source.getFile("data.83P");
        }
        if (source.getFile("Data.83P") != null) {
            return source.getFile("Data.83P");
        }
        if (source.getFile("multibeam.83P") != null) {
            return source.getFile("multibeam.83P");
        }
        return null;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public CorrectedPosition getCorrectedPosition() {
        if (this.position == null) {
            this.position = new CorrectedPosition(this.source);
        }
        return this.position;
    }

    @Override
    public long getFirstTimestamp() {
        return 0L;
    }

    @Override
    public long getLastTimestamp() {
        return 0L;
    }

    @Override
    public BathymetryInfo getBathymetryInfo() {
        return this.info;
    }

    @Override
    public BathymetrySwath getSwathAt(long timestamp) {
        return null;
    }

    @Override
    public BathymetrySwath nextSwath() {
        return this.nextSwath(1.0);
    }

    @Override
    public BathymetrySwath nextSwath(double prob) {
        if (this.position == null) {
            this.position = new CorrectedPosition(this.source);
        }
        try {
            if (this.curPos >= this.channel.size()) {
                return null;
            }
            this.realNumberOfBeams = 0;
            this.buf = this.channel.map(FileChannel.MapMode.READ_ONLY, this.curPos, 256L);
            this.header = new DeltaTHeader();
            this.header.parse(this.buf);
            this.hasIntensity = this.header.hasIntensity;
            this.buf = this.header.hasIntensity ? this.channel.map(FileChannel.MapMode.READ_ONLY, this.curPos + 256L, this.header.numBeams * 4) : this.channel.map(FileChannel.MapMode.READ_ONLY, this.curPos + 256L, this.header.numBeams * 2);
            BathymetryPoint[] data = new BathymetryPoint[this.header.numBeams];
            long timestamp = this.header.timestamp + MRAProperties.timestampMultibeamIncrement;
            SystemPositionAndAttitude pose = this.position.getPosition((double)timestamp / 1000.0);
            for (int c = 0; c < this.header.numBeams; ++c) {
                double range = (double)this.buf.getShort(c * 2) * ((double)this.header.rangeResolution / 1000.0);
                if (range == 0.0 || Math.random() > prob) continue;
                if (MRAProperties.soundSpeedCorrection) {
                    range = range * (double)this.header.soundVelocity / 1500.0;
                }
                double angle = this.header.startAngle + this.header.angleIncrement * (float)c;
                float height = (float)(range * Math.cos(Math.toRadians(angle)) + pose.getPosition().getDepth());
                double x = range * Math.sin(Math.toRadians(angle));
                double yawAngle = -pose.getYaw();
                float ox = (float)(x * Math.sin(yawAngle));
                float oy = (float)(x * Math.cos(yawAngle));
                data[this.realNumberOfBeams] = new BathymetryPoint(ox, oy, height);
                ++this.realNumberOfBeams;
            }
            this.curPos += (long)this.header.numBytes;
            BathymetrySwath swath = new BathymetrySwath(this.header.timestamp, pose, data);
            swath.setNumBeams(this.realNumberOfBeams);
            return swath;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BathymetrySwath nextSwathNoData() {
        if (this.position == null) {
            this.position = new CorrectedPosition(this.source);
        }
        try {
            if (this.curPos >= this.channel.size()) {
                return null;
            }
            this.realNumberOfBeams = 0;
            this.buf = this.channel.map(FileChannel.MapMode.READ_ONLY, this.curPos, 256L);
            DeltaTHeader header = new DeltaTHeader();
            header.parse(this.buf);
            long timestamp = header.timestamp + MRAProperties.timestampMultibeamIncrement;
            SystemPositionAndAttitude pose = this.position.getPosition((double)timestamp / 1000.0);
            this.curPos += (long)header.numBytes;
            BathymetrySwath swath = new BathymetrySwath(header.timestamp, pose, null);
            swath.setNumBeams(this.realNumberOfBeams);
            return swath;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getCurrentPosition() {
        return this.curPos;
    }

    public DeltaTHeader getCurrentHeader() {
        return this.header;
    }

    @Override
    public void rewind() {
        this.curPos = 0L;
    }

    @Override
    public boolean getHasIntensity() {
        return this.hasIntensity;
    }

    public static void main(String[] args) {
        try {
            BathymetrySwath s;
            LsfLogSource source = new LsfLogSource(new File("/home/lsts/Desktop/to_upload_20130715/lauv-noptilus-1/20130715/122455_out_survey/Data.lsf"), null);
            DeltaTParser p = new DeltaTParser(source);
            int c = 0;
            while ((s = p.nextSwath()) != null) {
                System.out.println(Math.toDegrees(s.getPose().getYaw()));
            }
            NeptusLog.pub().info((Object)("<###> " + c));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

