/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.importers.jsf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mra.importers.jsf.JsfHeader;
import pt.lsts.neptus.mra.importers.jsf.JsfIndex;
import pt.lsts.neptus.mra.importers.jsf.JsfSonarData;

public class JsfParser {
    private File file;
    private FileInputStream fis;
    private FileChannel channel;
    private long curPosition = 0L;
    private JsfIndex index = new JsfIndex();
    private String indexPath;
    private LinkedHashMap<Integer, Long[]> tslist = new LinkedHashMap();
    private LinkedHashMap<Integer, Long> nextTimestamp = new LinkedHashMap();
    static final int SUBSYS_LOW = 20;
    static final int SUBSYS_HIGH = 21;

    public JsfParser(File file) {
        try {
            this.file = file;
            this.fis = new FileInputStream(file);
            this.channel = this.fis.getChannel();
            this.indexPath = file.getParent() + "/mra/jsf.index";
            if (!new File(this.indexPath).exists()) {
                NeptusLog.pub().info((Object)("Generating JSF index for " + file.getAbsolutePath()));
                this.generateIndex();
            } else {
                NeptusLog.pub().info((Object)("Loading JSF index for " + file.getAbsolutePath()));
                if (!this.loadIndex()) {
                    NeptusLog.pub().error((Object)"Corrupted JSF index file. Trying to create a new index.");
                    this.generateIndex();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public JsfIndex getIndex() {
        return this.index;
    }

    public void generateIndex() {
        JsfHeader header = new JsfHeader();
        JsfSonarData ping = new JsfSonarData();
        long count = 0L;
        long pos = 0L;
        long maxTimestampHigh = 0L;
        long maxTimestampLow = 0L;
        long minTimestampHigh = Long.MAX_VALUE;
        long minTimestampLow = Long.MAX_VALUE;
        try {
            int headerSize;
            while (this.curPosition + (long)(headerSize = 16) < this.channel.size()) {
                ArrayList<Long> l;
                MappedByteBuffer buf = this.channel.map(FileChannel.MapMode.READ_ONLY, this.curPosition, headerSize);
                buf.order(ByteOrder.LITTLE_ENDIAN);
                header.parse(buf);
                this.curPosition += (long)headerSize;
                if (header.getType() == 80) {
                    int mapSize = 240;
                    if (this.curPosition + (long)mapSize >= this.channel.size()) break;
                    ping.setHeader(header);
                    buf = this.channel.map(FileChannel.MapMode.READ_ONLY, this.curPosition, mapSize);
                    buf.order(ByteOrder.LITTLE_ENDIAN);
                    ping.parseHeader(buf);
                    this.curPosition += (long)header.getMessageSize();
                } else {
                    this.curPosition += (long)header.getMessageSize();
                    pos = this.curPosition;
                    if (this.curPosition < this.channel.size()) continue;
                    break;
                }
                long t = ping.getTimestamp();
                float f = ping.getFrequency();
                byte subsystem = ping.getHeader().getSubsystem();
                if (!this.index.frequenciesList.contains(Float.valueOf(f))) {
                    this.index.frequenciesList.add(Float.valueOf(f));
                }
                if (!this.index.subSystemsList.contains(subsystem)) {
                    this.index.subSystemsList.add(Integer.valueOf(subsystem));
                }
                if (subsystem == 20) {
                    if (!this.index.hasLow) {
                        this.index.hasLow = true;
                    }
                    if ((l = this.index.positionMapLow.get(t)) == null) {
                        l = new ArrayList();
                        l.add(pos);
                        this.index.positionMapLow.put(t, l);
                    } else {
                        l.add(pos);
                    }
                    minTimestampLow = Math.min(minTimestampLow, t);
                    maxTimestampLow = Math.max(maxTimestampLow, t);
                }
                if (subsystem == 21) {
                    if (!this.index.hasHigh) {
                        this.index.hasHigh = true;
                    }
                    if ((l = this.index.positionMapHigh.get(t)) == null) {
                        l = new ArrayList();
                        l.add(pos);
                        this.index.positionMapHigh.put(t, l);
                    } else {
                        l.add(pos);
                    }
                    minTimestampHigh = Math.min(minTimestampHigh, t);
                    maxTimestampHigh = Math.max(maxTimestampHigh, t);
                }
                ++count;
                pos = this.curPosition;
                if (this.curPosition < this.channel.size()) continue;
                break;
            }
            this.index.firstTimestampHigh = minTimestampHigh;
            this.index.firstTimestampLow = minTimestampLow;
            this.index.lastTimestampHigh = maxTimestampHigh;
            this.index.lastTimestampLow = maxTimestampLow;
            Object[] tslisthigh = this.index.positionMapHigh.keySet().toArray(new Long[0]);
            Object[] tslistlow = this.index.positionMapLow.keySet().toArray(new Long[0]);
            Arrays.sort(tslisthigh);
            Arrays.sort(tslistlow);
            this.tslist.put(20, (Long[])tslistlow);
            this.tslist.put(21, (Long[])tslisthigh);
            this.index.numberOfPackets = count;
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.indexPath));
            out.writeObject(this.index);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean loadIndex() {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.indexPath));
            this.index = (JsfIndex)in.readObject();
            Object[] tslisthigh = this.index.positionMapHigh.keySet().toArray(new Long[0]);
            Object[] tslistlow = this.index.positionMapLow.keySet().toArray(new Long[0]);
            Arrays.sort(tslisthigh);
            Arrays.sort(tslistlow);
            this.tslist.put(20, (Long[])tslistlow);
            this.tslist.put(21, (Long[])tslisthigh);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public long getFirstTimeStamp() {
        return Math.min(this.index.firstTimestampHigh, this.index.firstTimestampLow);
    }

    public long getLastTimeStamp() {
        return Math.max(this.index.lastTimestampHigh, this.index.lastTimestampLow);
    }

    public JsfSonarData getPingAtPosition(long pos, int subsystem) {
        JsfHeader header = new JsfHeader();
        JsfSonarData ping = new JsfSonarData();
        try {
            MappedByteBuffer buf = this.channel.map(FileChannel.MapMode.READ_ONLY, pos, 16L);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            header.parse(buf);
            pos += 16L;
            if (header.getSubsystem() != subsystem) {
                return null;
            }
            ping.setHeader(header);
            buf = this.channel.map(FileChannel.MapMode.READ_ONLY, pos, 240L);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            ping.parseHeader(buf);
            buf = this.channel.map(FileChannel.MapMode.READ_ONLY, pos += 240L, header.getMessageSize() - 240);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            ping.parseData(buf);
            pos += (long)(header.getMessageSize() - 240);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ping;
    }

    public ArrayList<JsfSonarData> nextPing(int subsystem) {
        return this.getPingAt(this.nextTimestamp.get(subsystem), subsystem);
    }

    public ArrayList<JsfSonarData> getPingAt(Long timestamp, int subsystem) {
        this.curPosition = 0L;
        ArrayList<JsfSonarData> ping = new ArrayList<JsfSonarData>();
        LinkedHashMap<Long, ArrayList<Long>> positionMap = subsystem == 20 ? this.index.positionMapLow : this.index.positionMapHigh;
        long ts = 0L;
        int c = 0;
        for (Long time : this.tslist.get(subsystem)) {
            if (time >= timestamp) {
                ts = time;
                break;
            }
            ++c;
        }
        this.nextTimestamp.put(subsystem, this.tslist.get(subsystem)[c + 1]);
        for (Long pos : positionMap.get(ts)) {
            ping.add(this.getPingAtPosition(pos, subsystem));
        }
        return ping;
    }

    public static void main(String[] args) throws IOException {
        JsfParser parser = new JsfParser(new File("/home/jqcorreia/lsts/logs/lauv-dolphin-1/20130626/133827_rows_a1.5m/Data.jsf"));
        System.out.println();
        System.out.println();
        System.out.println(parser.index.firstTimestampHigh);
        System.out.println(parser.index.firstTimestampLow);
        System.out.println(parser.index.lastTimestampHigh);
        System.out.println(parser.index.lastTimestampLow);
        System.out.println();
        System.out.println(parser.getFirstTimeStamp());
        System.out.println(parser.getLastTimeStamp());
    }
}

