/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.importers.jsf;

import java.io.File;
import java.util.ArrayList;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mra.api.SidescanLine;
import pt.lsts.neptus.mra.api.SidescanParameters;
import pt.lsts.neptus.mra.api.SidescanParser;
import pt.lsts.neptus.mra.importers.jsf.JsfParser;
import pt.lsts.neptus.mra.importers.jsf.JsfSonarData;

public class JsfSidescanParser
implements SidescanParser {
    private JsfParser parser;

    public JsfSidescanParser(File f) {
        this.parser = new JsfParser(f);
    }

    @Override
    public long firstPingTimestamp() {
        return this.parser.getFirstTimeStamp();
    }

    @Override
    public long lastPingTimestamp() {
        return this.parser.getLastTimeStamp();
    }

    @Override
    public ArrayList<Integer> getSubsystemList() {
        return this.parser.getIndex().subSystemsList;
    }

    @Override
    public ArrayList<SidescanLine> getLinesBetween(long timestamp1, long timestamp2, int subsystem, SidescanParameters params) {
        ArrayList<SidescanLine> list = new ArrayList<SidescanLine>();
        ArrayList<JsfSonarData> ping = this.parser.getPingAt(timestamp1, subsystem);
        if (ping.size() == 0) {
            return list;
        }
        while (ping.get(0).getTimestamp() < timestamp2) {
            double gain;
            double r;
            int i;
            int sboardNsamples;
            JsfSonarData sboard = null;
            JsfSonarData pboard = null;
            for (JsfSonarData temp : ping) {
                if (temp == null) continue;
                if (temp.getHeader().getChannel() == 0) {
                    pboard = temp;
                }
                if (temp.getHeader().getChannel() != 1) continue;
                sboard = temp;
            }
            int pboardNsamples = pboard != null ? pboard.getNumberOfSamples() : 0;
            int n = sboardNsamples = sboard != null ? sboard.getNumberOfSamples() : 0;
            if (pboard == null && sboard != null) {
                pboardNsamples = sboardNsamples;
            } else if (pboard != null && sboard == null) {
                sboardNsamples = pboardNsamples;
            }
            double[] fData = new double[pboardNsamples + sboardNsamples];
            double avgSboard = 0.0;
            double avgPboard = 0.0;
            if (pboard != null) {
                for (i = 0; i < pboardNsamples; ++i) {
                    r = pboard.getData()[i];
                    avgPboard += r;
                }
            }
            if (sboard != null) {
                for (i = 0; i < sboardNsamples; ++i) {
                    r = sboard.getData()[i];
                    avgSboard += r;
                }
            }
            avgPboard /= (double)pboardNsamples * params.getNormalization();
            avgSboard /= (double)sboardNsamples * params.getNormalization();
            if (pboard != null) {
                for (i = 0; i < pboardNsamples; ++i) {
                    r = (double)i / (double)pboardNsamples;
                    gain = Math.abs(30.0 * Math.log(r));
                    double pb = pboard.getData()[i] * Math.pow(10.0, gain / params.getTvgGain());
                    fData[i] = pb / avgPboard;
                }
            }
            if (sboard != null) {
                for (i = 0; i < sboardNsamples; ++i) {
                    r = 1.0 - (double)i / (double)sboardNsamples;
                    gain = Math.abs(30.0 * Math.log(r));
                    double sb = sboard.getData()[i] * Math.pow(10.0, gain / params.getTvgGain());
                    fData[i + pboardNsamples] = sb / avgSboard;
                }
            }
            if (pboard != null || sboard != null) {
                if (pboard == null) {
                    pboard = sboard;
                }
                SystemPositionAndAttitude pose = new SystemPositionAndAttitude();
                pose.getPosition().setLatitudeDegs((double)pboard.getLat() / 10000.0 / 60.0);
                pose.getPosition().setLongitudeDegs((double)pboard.getLon() / 10000.0 / 60.0);
                pose.setRoll(Math.toRadians((double)pboard.getRoll() * 0.0054931640625));
                pose.setYaw(Math.toRadians(pboard.getHeading() / 100));
                pose.setAltitude((double)pboard.getAltMillis() / 1000.0);
                pose.setU((double)pboard.getSpeed() * 0.51444);
                list.add(new SidescanLine(ping.get(0).getTimestamp(), ping.get(0).getRange(), pose, ping.get(0).getFrequency(), fData));
            }
            try {
                ping = this.parser.nextPing(subsystem);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
            if (ping.size() != 0) continue;
            return list;
        }
        return list;
    }
}

