/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.importers.jsf;

import java.nio.ByteBuffer;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mra.importers.jsf.JsfHeader;

public class JsfSonarData {
    private JsfHeader header;
    private long timestamp;
    private int pingNumber;
    private short validityBitmap;
    private int x;
    private int y;
    private int lat;
    private int lon;
    private Units units;
    private int numberOfSamples;
    private int depthMillis;
    private int altMillis;
    private short heading;
    private short pitch;
    private short roll;
    private float speed;
    private short factor;
    private short packetNumber;
    private float frequency;
    private float range;
    private double[] data;
    short msb;

    public JsfHeader getHeader() {
        return this.header;
    }

    public void setHeader(JsfHeader header) {
        this.header = header;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getPingNumber() {
        return this.pingNumber;
    }

    public void setPingNumber(int pingNumber) {
        this.pingNumber = pingNumber;
    }

    public short getValidityBitmap() {
        return this.validityBitmap;
    }

    public void setValidityBitmap(short validityBitmap) {
        this.validityBitmap = validityBitmap;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getLat() {
        return this.lat;
    }

    public void setLat(int lat) {
        this.lat = lat;
    }

    public int getLon() {
        return this.lon;
    }

    public void setLon(int lon) {
        this.lon = lon;
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public void setFrequency(float frequency) {
        this.frequency = frequency;
    }

    public int getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public void setNumberOfSamples(int numberOfSamples) {
        this.numberOfSamples = numberOfSamples;
    }

    public int getDepthMillis() {
        return this.depthMillis;
    }

    public void setDepthMillis(int depthMillis) {
        this.depthMillis = depthMillis;
    }

    public int getAltMillis() {
        return this.altMillis;
    }

    public void setAltMillis(int altMillis) {
        this.altMillis = altMillis;
    }

    public short getFactor() {
        return this.factor;
    }

    public void setFactor(short factor) {
        this.factor = factor;
    }

    public short getHeading() {
        return this.heading;
    }

    public void setHeading(short heading) {
        this.heading = heading;
    }

    public short getPitch() {
        return this.pitch;
    }

    public void setPitch(short pitch) {
        this.pitch = pitch;
    }

    public short getRoll() {
        return this.roll;
    }

    public void setRoll(short roll) {
        this.roll = roll;
    }

    public short getPacketNumber() {
        return this.packetNumber;
    }

    public void setPacketNumber(short packetNumber) {
        this.packetNumber = packetNumber;
    }

    public float getRange() {
        return this.range;
    }

    public void setRange(float range) {
        this.range = range;
    }

    public double[] getData() {
        return this.data;
    }

    public void setData(double[] data) {
        this.data = data;
    }

    void parseHeader(ByteBuffer buf) {
        int pingTime = buf.getInt(0);
        short hours = buf.getShort(160);
        short minutes = buf.getShort(162);
        short seconds = buf.getShort(164);
        this.msb = buf.getShort(16);
        int msbStartFreq = (this.msb & 0xF) << 16;
        this.timestamp = (long)(pingTime -= hours * 3600 + minutes * 60 + seconds) * 1000L + (long)buf.getInt(200);
        this.pingNumber = buf.getInt(8);
        if (buf.getShort(88) == Units.LATLON.getCode()) {
            this.lon = buf.getInt(80);
            this.lat = buf.getInt(84);
        } else {
            this.x = buf.getInt(80);
            this.y = buf.getInt(84);
        }
        this.numberOfSamples = buf.getShort(114) & 0xFFFF;
        this.range = (float)buf.getInt(116) / new Float(Math.pow(10.0, 9.0)).floatValue() * (float)this.numberOfSamples * 1500.0f / 2.0f;
        this.range = Math.round(this.range);
        this.frequency = (float)((buf.getShort(126) & 0xFFFF) + msbStartFreq) / 100.0f;
        this.depthMillis = buf.getInt(140);
        this.altMillis = buf.getInt(144);
        this.factor = buf.getShort(168);
        this.heading = buf.getShort(172);
        this.pitch = buf.getShort(174);
        this.roll = buf.getShort(176);
        this.speed = (float)buf.getShort(194) / 10.0f;
        if (this.numberOfSamples < 0) {
            NeptusLog.pub().info((Object)("<###>asdd " + this));
        }
        this.data = new double[this.numberOfSamples];
    }

    void parseData(ByteBuffer buf) {
        this.data = new double[this.numberOfSamples];
        double w = Math.pow(2.0, -this.factor);
        for (int i = 0; i < this.numberOfSamples * 2; i += 2) {
            int s = ((buf.get(i + 1) & 0xFF) << 8) + (buf.get(i) & 0xFF);
            double d = (double)s * w;
            if (this.header.getChannel() == 0) {
                this.data[this.numberOfSamples - i / 2 - 1] = d;
                continue;
            }
            this.data[i / 2] = d;
        }
    }

    public String toString() {
        return "Freq: " + this.frequency + " Range: " + this.range + " pingNumber: " + this.pingNumber + " channel: " + this.header.getChannel() + " numberOfSamples: " + this.numberOfSamples + " factor: " + this.factor + " speed: " + this.speed;
    }

    static enum Units {
        XY_MILI(1),
        LATLON(2),
        XY_DEC(3);

        int code;

        private Units(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }
    }
}

